"GAUSS PROGRAM NRDAT2.PRG" ;
/*  FOR GENERATING DATA SET NUMBER 2,
WHICH STUDIES HORIZONTAL SHIFTS IN THE DATA
WHICH AFFECT CURVATURE IN THE REGRESSION FUNCTION,
TO BE USED FOR COMPARISON OF
NONPARAMETRIC REGRESSION ESTIMATORS   */

LIBRARY PGRAPH ;  GRAPHSET ;

IPLOTA = 0 ;     /*  1 - MAKE PLOT TYPE A, REGRESSION CURVES  */
IPLOTB = 0 ;     /*  1 - MAKE PLOT TYPE B, DATA AS LINES  */
IPLOTC = 0 ;     /*  1 - MAKE PLOT TYPE C, DATA AS CONNECTED CIRCLES  */
IPLOTD = 0 ;     /*  1 - MAKE PLOT TYPE D, FAMILY OF ESTS  */

IDATFILE = 1 ;   /*  1 - CREATE OUTPUT DATA FILES  */

AUTOP = 0 ;       /*  0 TO VIEW ON SCREEN   */
                  /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                  /*  2 TO WRITE AS POSTSCRIPT FILES  */


N = 200 ;
LEFT = 0 ;
RIGHT = 1 ;


DEL = (RIGHT - LEFT) / N ;
XGRID = SEQA((LEFT + DEL/2),DEL,N) ;

  NTR = 6 ;
C = SEQA(.5,.1,NTR)' ;
       /*  FORWARD TRANSFORMATION, FOR PLOTTING  */
FLAG = (XGRID .< .5) ;
TXGRID = FLAG .* (.5 - (FLAG .* (1 - 2 * XGRID))^C / 2) ;
TXGRID[(N/2 + 1):N,.] = 1 - REV(TXGRID[1:(N/2),.]) ;

       /*  INVERSE OF TRANSFORMATION, FOR DATA POINTS  */
TGRID = XGRID ;
FLAG = (TGRID .< .5) ;
XTGRID = FLAG .* (.5 - (FLAG .* (1 - 2 * TGRID))^(1/C) / 2) ;
XTGRID[(N/2 + 1):N,.] = 1 - REV(XTGRID[1:(N/2),.]) ;

M = -COS(6 * PI * TGRID) ;


"SET GRAPHICS STUFF" ;
FONTS("SIMPLEX SIMGRMA" ) ;
_PDATE = "FROM NRDAT2.PRG     " ;
_PLTYPE = 6|3|4|6|3|4 ;
_PSTYPE = 1 ;
XTICS(LEFT,RIGHT,.2,1) ;


IF IPLOTA == 1 ;
    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR2A1.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR2A1.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;

    YTICS(LEFT,RIGHT,.2,1) ;
    TITLE("Example 2: Time Shift Transformations") ;
  XY(XGRID,TXGRID) ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR2A2.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR2A2.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;

    YTICS(-1,1,.5,1) ;
    TITLE("Example 2: Family of Regression Functions") ;
  XY(XTGRID,M) ;
ENDIF ;



  SIG = .05 ;
  SEED = 49509327 ;
EPS = RNDNS(N,1,SEED) ;

Y = M + SIG .* EPS ;



  TITSTR = "Example 2: Raw Data for \202s\201 = " ;
  TITSTR = TITSTR$+FTOS(SIG,"%*.*lf",4,2) ;
  TITSTR = TITSTR$+",   n = " ;
  TITSTR = TITSTR$+FTOS(N,"%*.*lf",1,0) ;
TITLE(TITSTR) ;



IF IPLOTB == 1 ;
  "SHOW DATA AS LINES" ;
  _PLCTRL = 0 ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR2B.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR2B.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
    YTICS(-1.2,1.2,.6,1) ;
  XY(XTGRID,Y) ;

ENDIF ;


IF IPLOTC == 1 ;
  "SHOW DATA AS CONNECTED CIRCLES" ;
  _PLINE = 0 ;
  _PLCTRL = ONES(NTR,1) ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR2C2.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR2C2.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
    YTICS(-1.2,1.2,.6,1) ;
  XY(XTGRID,Y) ;
ENDIF ;



IF IPLOTD == 1 ;
  "MAKE PLOT OF FAMILY OF ESTIMATES" ;
  ITR = 1 ;
  EOUT = ZEROS(N,NTR) ;
  H = .01 ;
  IKER = 1 ;
  KPAR = 0 ;
  DO WHILE ITR <= NTR ;
      "WORKING ON ESTIMATE " ITR ;

      ENDCT = 1 ;     /*  INCLUDE DAT EYOND ENDS  */
    BINCTS = BNLBR1(XTGRID[.,ITR]~Y,LEFT,RIGHT,N,ENDCT) ;

    OUT = BNLLR1(BINCTS,XGRID[1],XGRID[N],H,IKER,KPAR) ;
    EOUT[.,ITR] = OUT[.,1] ;        /*  CHOP OFF KERNEL FUNCTION  */
    ITR = ITR + 1 ;
  ENDO ;

    YTICS(-1.2,1.2,.6,1) ;
    _PLCTRL = 0 ;

      TITSTR = "Example 2: Gaussian Kernel LL Smooths, " ;
      TITSTR = TITSTR$+"\LWith Visually Chosen Global h = " ;
      TITSTR = TITSTR$+FTOS(H,"%*.*lf",5,3) ;
    TITLE(TITSTR) ;
    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR2D1.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR2D1.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
  XY(XGRID,EOUT) ;

ENDIF ;


IF IDATFILE == 1 ;

  OUTPUT FILE=NRDAT2.DAT RESET ;     /*  CREATE DATA FILE  */
      FORMAT /RD 8,6 ;
    XTGRID~M~Y ;
  OUTPUT OFF ;

  OUTPUT FILE=NRDAT2.DSC RESET ;     /*  CREATE DISCUSSION FILE  */
    "  DETAILS OF DATA FILE: NRDAT2.DAT      CREATED " DATESTR(0) ;
    ? ;
    "    THIS IS A TEST DATA SET FOR COMPARISON OF REGRESSION ESTIMATORS " ;
    "    INTENDED TO COMPARE HORIZONTAL SHIFTS IN THE DATA," ;
    "    WHICH AFFECT THE CURVATURE IN THE REGRESSION  " ;
    ? ; ? ;
      FORMAT 1,0 ;
    "         ROWS ARE OBSERVATIONS, n = " N ;
    ? ;
      FORMAT 6,4 ;
    "         COLUMNS 1-6    -  THE X'S  (VARIOUS TIME SHIFTS OF [0,1])" ;
    "         COLUMN 7       -  THE TARGET CURVE, M(X) " ;
    "         COLUMN 8       -  Y = M(X) + SIG * EPS" ;
    "                              FOR EPS ~ N(0,SIG^2), " ;
    "                                 SIG = " SIG ;
  OUTPUT OFF ;
  FORMAT 8,5 ;

ENDIF ;



END ;

