"GAUSS PROGRAM NRDAT3.PRG" ;
/*  FOR GENERATING DATA SET NUMBER 3,
WHICH STUDIES CHANGES IN THE VARIANCE FUNCTION,
TO BE USED FOR COMPARISON OF
NONPARAMETRIC REGRESSION ESTIMATORS   */

LIBRARY PGRAPH ;  GRAPHSET ;

IPLOTA = 1 ;     /*  1 - MAKE PLOT TYPE A, S.D. CURVES  */
IPLOTB = 1 ;     /*  1 - MAKE PLOT TYPE B, DATA AS CONNECTED CIRCLES  */
IPLOTC = 1 ;     /*  1 - MAKE PLOT TYPE C, WINDOW VERSION, SAME SCALES  */
IPLOTD = 1 ;     /*  1 - MAKE PLOT TYPE D, SIMPLE FAMILY OF EST'S  */

IDATFILE = 1 ;   /*  1 - CREATE OUTPUT DATA FILES  */

AUTOP = 2 ;       /*  0 TO VIEW ON SCREEN   */
                  /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                  /*  2 TO WRITE AS POSTSCRIPT FILES  */


N = 200 ;
LEFT = 0 ;
RIGHT = 1 ;


DEL = (RIGHT - LEFT) / N ;
XGRID = SEQA((LEFT + DEL/2),DEL,N) ;

M = XGRID ;
M = M + 1.5 * PDFN((XGRID - .35) / .15) ;
M = M - 1 * PDFN((XGRID - .9) / .04) ;


NSIG = 5 ;
C = SEQA(-1,.5,NSIG)' ;
MSIG = .5 + C .* (XGRID - .5) ;
MSIG = .3 * MSIG ;

  XTICS(LEFT,RIGHT,.2,1) ;
IF IPLOTA == 1 ;
    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR3A.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR3A.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;

    _PLTYPE = 6|1|3|4|2 ;
    TITLE("Example 3: Standard Deviation Function") ;
  XY(XGRID,MSIG) ;
ENDIF ;




  SEED = 49876327 ;
EPS = RNDNS(N,1,SEED) ;


Y = M + MSIG .* EPS ;

"SET GRAPHICS STUFF" ;
FONTS("SIMPLEX SIMGRMA" ) ;
_PDATE = "FROM NRDAT3.PRG     " ;
_PSTYPE = 1 ;

  TITSTR = "Example 3: Target and Data for Location Varying \202s\201 " ;
TITLE(TITSTR) ;



IF IPLOTB == 1 ;
  "SHOW DATA AS CONNECTED CIRCLES" ;
  _PLINE = 0 ;
  _PLCTRL = 0|(ONES(NSIG,1)) ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR3B.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR3B.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
    YTICS(-.5,1.5,.5,1) ;
  XY(XGRID,M~Y) ;
ENDIF ;




IF IPLOTC == 1 ;
  "MAKE WINDOWED PLOT OF DATA, SAME SCALES" ;
  BEGWIND ;
  WINDOW(2,3,0) ;
  SETWIND(0) ;
  _PLCTRL = 0|-1|0|0 ;
  _PLTYPE = 5|6|4|4 ;
  YTICS(-.5,1.5,.5,1) ;

  IW = 1 ;
  DO WHILE IW <= NSIG ;

    NEXTWIND ;
        TITSTR = "Example 3: Target, Data, and 2 sd's" ;
      TITLE(TITSTR) ;
    XY(XGRID,M~Y[.,IW]~(M+2*MSIG[.,IW])~(M-2*MSIG[.,IW])) ;

    IW = IW + 1 ;
  ENDO ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR3C.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR3C.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
  ENDWIND ;
ENDIF ;



IF IPLOTD == 1 ;
  "MAKE PLOT OF FAMILY OF ESTIMATES" ;
  ISIG = 1 ;
  EOUT = ZEROS(N,NSIG) ;
  H = .04 ;
  IKER = 1 ;
  KPAR = 0 ;
  DO WHILE ISIG <= NSIG ;
      "WORKING ON ESTIMATE " ISIG ;
      BINCTS = ONES(N,1)~Y[.,ISIG] ;
    OUT = BNLLR1(BINCTS,XGRID[1],XGRID[N],H,IKER,KPAR) ;
    EOUT[.,ISIG] = OUT[.,1] ;        /*  CHOP OFF KERNEL FUNCTION  */
    ISIG = ISIG + 1 ;
  ENDO ;

    YTICS(0,1,.2,1) ;
    _PLTYPE = 5|6|1|3|4|2 ;
    _PLCTRL = 0 ;

      TITSTR = "Example 3: Gaussian Kernel LL Smooths, " ;
      TITSTR = TITSTR$+"\LWith Visually Chosen Global h = " ;
      TITSTR = TITSTR$+FTOS(H,"%*.*lf",5,3) ;
    TITLE(TITSTR) ;
    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR3D.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR3D.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
  XY(XGRID,M~EOUT) ;

ENDIF ;



IF IDATFILE == 1 ;

  OUTPUT FILE=NRDAT3.DAT RESET ;     /*  CREATE DATA FILE  */
      FORMAT /RD 8,6 ;
    XGRID~M~Y ;
  OUTPUT OFF ;

  OUTPUT FILE=NRDAT3.DSC RESET ;     /*  CREATE DISCUSSION FILE  */
    "  DETAILS OF DATA FILE: NRDAT3.DAT      CREATED " DATESTR(0) ;
    ? ;
    "    THIS IS A TEST DATA SET FOR COMPARISON OF REGRESSION ESTIMATORS " ;
    "    INTENDED TO COMPARE DIFFERENT VARIANCE FUNCTIONS" ;
    ? ; ? ;
      FORMAT 1,0 ;
    "         ROWS ARE OBSERVATIONS, n = " N ;
    ? ;
    "         COLUMN 1       -  THE X'S  (EQUALLY SPACED [0,1])" ;
    "         COLUMN 2       -  THE TARGET CURVE, M(X) " ;
    "         COLUMNS 3-"$+FTOS((2+NSIG),"%*.*lf",1,0)
                       "    -  Y = M(X) + SIG * EPS" ;
    "                              FOR EPS ~ N(0,SIG^2) " ;
    "                              AND LOCATION VARYING SIG" ;
  OUTPUT OFF ;
  FORMAT 8,5 ;

ENDIF ;


END ;

