"GAUSS PROGRAM NRDAT4.PRG" ;
/*  FOR GENERATING DATA SET NUMBER 3,
WHICH STUDIES VARYING RANDOM DESIGN,
TO BE USED FOR COMPARISON OF
NONPARAMETRIC REGRESSION ESTIMATORS   */

LIBRARY PGRAPH ;  GRAPHSET ;

IPLOTB = 1 ;     /*  1 - MAKE PLOT TYPE B, DATA AS LINES  */
IPLOTC = 0 ;     /*  1 - MAKE PLOT TYPE C, DATA AS CIRCLES  */
IPLOTD = 0 ;     /*  1 - MAKE PLOT TYPE D, DATA AS CONNECTED CIRCLES  */
IPLOTE = 0 ;     /*  1 - MAKE PLOT TYPE E, WINDOW VERSION, SAME SCALES  */
IPLOTF = 0 ;     /*  1 - MAKE PLOT TYPE F, WINDOW VERSION, DEFAULT SCALES  */
IPLOTG = 0 ;     /*  1 - MAKE PLOT TYPE G, SIMPLE FAMILY OF EST'S  */

IDATFILE = 0 ;   /*  1 - CREATE OUTPUT DATA FILES  */

AUTOP = 0 ;       /*  0 TO VIEW ON SCREEN   */
                  /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                  /*  2 TO WRITE AS POSTSCRIPT FILES  */


N = 200 ;
LEFT = 0 ;
RIGHT = 1 ;

DEL = (RIGHT - LEFT) / N ;
XGRID = SEQA((LEFT + DEL/2),DEL,N) ;

C = SEQM(.5,2^(1/3),7)' ;
MXGRID = XGRID^C ;

M = MXGRID ;
M = M + 1.5 * PDFN((MXGRID - .35) / .15) ;
M = M - 1 * PDFN((MXGRID - .8) / .04) ;


  SEED = 49509327 ;
EPS = RNDNS(N,1,SEED) ;

  SIG = .1 ;
Y = M + SIG .* EPS ;

"SET GRAPHICS STUFF" ;
FONTS("SIMPLEX SIMGRMA" ) ;
_PDATE = "FROM NRDAT4.PRG     " ;
_PLTYPE = 6 ;
_PSTYPE = 1 ;

  TITSTR = "Example 4: Target and Data, for Different Designs" ;
TITLE(TITSTR) ;

XTICS(LEFT,RIGHT,.2,1) ;



IF IPLOTB == 1 ;
  "SHOW DATA AS LINES" ;
  _PLCTRL = 0 ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR4B.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR4B.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
    YTICS(-1,2,.5,1) ;
  XY(MXGRID~MXGRID,M~Y) ;

ENDIF ;


/*
IF IPLOTC == 1 ;
  "SHOW DATA AS CIRCLES" ;
  _PLCTRL = 0|(-ONES(NSIG,1)) ;

  _PLINE = (1~6) .* ONES(N,1) ;
  _PLINE = _PLINE~XGRID~Y[.,1]~XGRID~Y[.,NSIG] ;
  _PLINE = _PLINE~((1~1~1) .* ONES(N,1)) ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR4C.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR4C.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
    YTICS(-1.5,2.5,.5,1) ;
  XY(XGRID,M~Y) ;
ENDIF ;


IF IPLOTD == 1 ;
  "SHOW DATA AS CONNECTED CIRCLES" ;
  _PLINE = 0 ;
  _PLCTRL = 0|(ONES(NSIG,1)) ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR4D2.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR4D2.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
    YTICS(-1,2,.5,1) ;
  XY(XGRID,M~Y) ;
ENDIF ;


IF IPLOTE == 1 ;
  "MAKE WINDOWED PLOT OF DATA, SAME SCALES" ;
  BEGWIND ;
  WINDOW(2,3,0) ;
  SETWIND(0) ;
  _PLCTRL = 0|-1|0|0 ;
  _PLTYPE = 6|6|4|4 ;
  YTICS(-1,2,.5,1) ;

  IW = 1 ;
  DO WHILE IW <= NSIG ;

    NEXTWIND ;
        TITSTR = "Example 1: Target, Data, and 2 sd's for \202s\201 = " ;
        TITSTR = TITSTR$+FTOS(C[IW],"%*.*lf",4,2) ;
      TITLE(TITSTR) ;
    XY(XGRID,M~Y[.,IW]~(M+2*C[IW])~(M-2*C[IW])) ;

    IW = IW + 1 ;
  ENDO ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR4E.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR4E.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
  ENDWIND ;
ENDIF ;


IF IPLOTF == 1 ;
  "MAKE WINDOWED PLOT OF DATA, DEFAULT SCALES" ;
  BEGWIND ;
  WINDOW(2,3,0) ;
  SETWIND(0) ;
  _PLCTRL = 0|-1|0|0 ;
  _PLTYPE = 6|6|4|4 ;

        /*  RESET TO DEFAULT VERTICAL SCALES  */
  YMISS = MISS(1,1) ;
  SCALE(YMISS,YMISS) ;
  XTICS(LEFT,RIGHT,.2,1) ;

  IW = 1 ;
  DO WHILE IW <= NSIG ;

    NEXTWIND ;
        TITSTR = "Example 1: Target, Data, and 2 sd's for \202s\201 = " ;
        TITSTR = TITSTR$+FTOS(VSIG[IW],"%*.*lf",4,2) ;
      TITLE(TITSTR) ;
    XY(XGRID,M~Y[.,IW]~(M+2*VSIG[IW])~(M-2*VSIG[IW])) ;

    IW = IW + 1 ;
  ENDO ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR4F.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR4F.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
  ENDWIND ;
ENDIF ;


IF IPLOTG == 1 ;
  "MAKE PLOT OF FAMILY OF ESTIMATES" ;
  ISIG = 1 ;
  EOUT = ZEROS(N,NSIG) ;
  H = .04 ;       /*  VISUAL MIDRANGE,  FOR CENTRAL SIGMAS   */
  IKER = 1 ;
  KPAR = 0 ;
  DO WHILE ISIG <= NSIG ;
      "WORKING ON ESTIMATE " ISIG ;
      BINCTS = ONES(N,1)~Y[.,ISIG] ;
    OUT = BNLLR1(BINCTS,XGRID[1],XGRID[N],H,IKER,KPAR) ;
    EOUT[.,ISIG] = OUT[.,1] ;        /*  CHOP OFF KERNEL FUNCTION  */
    ISIG = ISIG + 1 ;
  ENDO ;

    YTICS(0,1.2,.2,1) ;
    _PLTYPE = 6|3|3|3|3|3|3|3|3 ;
    _PLCTRL = 0 ;

      TITSTR = "Example 1: Gaussian Kernel LL Smooths, " ;
      TITSTR = TITSTR$+"\LWith Visually Chosen Global h = " ;
      TITSTR = TITSTR$+FTOS(H,"%*.*lf",5,3) ;
    TITLE(TITSTR) ;
    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR4G1.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR4G1.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
  XY(XGRID,M~EOUT) ;


  H = .015 ;       /* TARGETING SMALLEST SIGMA  */
  ISIG = 1 ;
  DO WHILE ISIG <= NSIG ;
      "WORKING ON ESTIMATE " ISIG ;
      BINCTS = ONES(N,1)~Y[.,ISIG] ;
    OUT = BNLLR1(BINCTS,XGRID[1],XGRID[N],H,IKER,KPAR) ;
    EOUT[.,ISIG] = OUT[.,1] ;        /*  CHOP OFF KERNEL FUNCTION  */
    ISIG = ISIG + 1 ;
  ENDO ;
      TITSTR = "Example 1: Gaussian Kernel LL Smooths, " ;
      TITSTR = TITSTR$+"\LWith Visually Chosen Global h = " ;
      TITSTR = TITSTR$+FTOS(H,"%*.*lf",5,3) ;
    TITLE(TITSTR) ;
    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR4G2.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR4G2.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
  XY(XGRID,M~EOUT) ;


  H = .09 ;       /* TARGETING LARGEST SIGMA  */
  ISIG = 1 ;
  DO WHILE ISIG <= NSIG ;
      "WORKING ON ESTIMATE " ISIG ;
      BINCTS = ONES(N,1)~Y[.,ISIG] ;
    OUT = BNLLR1(BINCTS,XGRID[1],XGRID[N],H,IKER,KPAR) ;
    EOUT[.,ISIG] = OUT[.,1] ;        /*  CHOP OFF KERNEL FUNCTION  */
    ISIG = ISIG + 1 ;
  ENDO ;
      TITSTR = "Example 1: Gaussian Kernel LL Smooths, " ;
      TITSTR = TITSTR$+"\LWith Visually Chosen Global h = " ;
      TITSTR = TITSTR$+FTOS(H,"%*.*lf",5,3) ;
    TITLE(TITSTR) ;
    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR4G3.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR4G3.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
  XY(XGRID,M~EOUT) ;
ENDIF ;


IF IDATFILE == 1 ;

  OUTPUT FILE=NRDAT4.DAT RESET ;     /*  CREATE DATA FILE  */
      FORMAT /RD 8,6 ;
    XGRID~M~Y ;
  OUTPUT OFF ;

  OUTPUT FILE=NRDAT4.DSC RESET ;     /*  CREATE DISCUSSION FILE  */
    "  DETAILS OF DATA FILE: NRDAT4.DAT      CREATED " DATESTR(0) ;
    ? ;
    "    THIS IS A TEST DATA SET FOR COMPARISON OF REGRESSION ESTIMATORS " ;
    "    INTENDED TO COMPARE FOR A RANGE OF SIGNAL TO NOISE RATIOS" ;
    ? ; ? ;
      FORMAT 1,0 ;
    "         ROWS ARE OBSERVATIONS, n = " N ;
    ? ;
    "         COLUMN 1       -  THE X'S  (EQUALLY SPACED [0,1])" ;
    "         COLUMN 2       -  THE TARGET CURVE, M(X) " ;
    "         COLUMNS 3-"$+FTOS((2+NSIG),"%*.*lf",1,0)
                       "    -  Y = M(X) + SIG * EPS" ;
    "                              FOR EPS ~ N(0,1) " ;
    "                              AND SIG = " ;
      FORMAT 40,2 ;
    VSIG ;
  OUTPUT OFF ;
  FORMAT 8,5 ;

ENDIF ;
*/



END ;

