"GAUSS PROGRAM NRDAT5.PRG" ;
/*  FOR GENERATING DATA SETD NUMBERS 5A AND 5B,
INTENDED TO BE EXTREME EXAMPLES
TO BE USED FOR COMPARISON OF
NONPARAMETRIC REGRESSION ESTIMATORS   */

LIBRARY PGRAPH ;  GRAPHSET ;

IPLOTA = 1 ;     /*  1 - MAKE PLOT TYPE A, VERY HIGH NOISE EXAMPLE  */
IPLOTAS = 0 ;    /*  1 - MAKE PLOT TYPE AS, FAMILY OF LL SMOOTHS FOR A  */
IPLOTB = 0 ;     /*  1 - MAKE PLOT TYPE B, VERY LOW NOISE EXAMPLE  */
IPLOTBS = 0 ;    /*  1 - MAKE PLOT TYPE BS, FAMILY OF LL SMOOTHS FOR C  */

IDATFILE = 0 ;   /*  1 - CREATE OUTPUT DATA FILES  */

AUTOP = 2 ;       /*  0 TO VIEW ON SCREEN   */
                  /*  1 TO WRITE TO HPGL FILE FOR LAS PLOT  */
                  /*  2 TO WRITE AS POSTSCRIPT FILES  */


LEFT = 0 ;
RIGHT = 1 ;

NA = 4000 ;
DEL = (RIGHT - LEFT) / NA ;
XGRIDA = SEQA((LEFT + DEL/2),DEL,NA) ;

NB = 40 ;
DEL = (RIGHT - LEFT) / NB ;
XGRIDB = SEQA((LEFT + DEL/2),DEL,NB) ;

  NP = 400 ;
  DEL = (RIGHT - LEFT) / NP ;
PGRID = SEQA((LEFT + DEL/2),DEL,NP) ;


MA = XGRIDA ;
MA = MA + 1.5 * PDFN((XGRIDA - .35) / .15) ;
MA = MA - 1 * PDFN((XGRIDA - .8) / .04) ;

MB = XGRIDB ;
MB = MB + 1.5 * PDFN((XGRIDB - .35) / .15) ;
MB = MB - 1 * PDFN((XGRIDB - .8) / .04) ;

MP = PGRID ;
MP = MP + 1.5 * PDFN((PGRID - .35) / .15) ;
MP = MP - 1 * PDFN((PGRID - .8) / .04) ;


    SEED = 456748937 ;
  EPS = RNDNS(NA,1,SEED) ;
  SIGA = 1 ;
YA = MA + SIGA .* EPS ;   ;

  EPS = RNDNS(NB,1,SEED) ;
  SIGB = .02 ;
YB = MB + SIGB .* EPS ;   ;


"SET GRAPHICS STUFF" ;
FONTS("SIMPLEX SIMGRMA" ) ;
_PDATE = "FROM NRDAT5.PRG     " ;
_PLTYPE = 6 ;
_PSTYPE = 4 ;

XTICS(LEFT,RIGHT,.2,1) ;



IF IPLOTA == 1 ;
  _PLCTRL = 0|-1 ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR5A.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR5A.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;

    _PLEGCTL = 0 ;
    YTICS(-3,5,1,1) ;
      TITSTR = "Example 5A: Target and Data, High Noise, n = " ;
      TITSTR = TITSTR$+FTOS(NA,"%*.*lf",1,0) ;
      TITSTR = TITSTR$+",  sig = "$+FTOS(SIGA,"%*.*lf",4,2) ;
    TITLE(TITSTR) ;
  XY(XGRIDA,MA~YA) ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR5AZ.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR5AZ.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;

    YTICS(0,1,.2,1) ;
      TITSTR = "Example 5A: Target and Data, High Noise, n = " ;
      TITSTR = TITSTR$+FTOS(NA,"%*.*lf",1,0) ;
      TITSTR = TITSTR$+",  sig = "$+FTOS(SIGA,"%*.*lf",4,2) ;
    TITLE(TITSTR) ;
  XY(XGRIDA,MA~YA) ;

ENDIF ;



IF IPLOTAS == 1 ;
  "MAKE PLOT OF FAMILY OF ESTIMATES" ;
  VH = SEQM(.01,SQRT(2),9) ;
  IKER = 1 ;
  KPAR = 0 ;
    ENDCT = 1 ;
  BINCTS = BNLBR1(XGRIDA~YA,PGRID[1],PGRID[NP],NP,ENDCT) ;
  EOUT = ZEROS(NP,ROWS(VH)) ;
  _PLEGSTR = "True" ;
  IH = 1 ;
  DO WHILE IH <= ROWS(VH) ;
    H = VH[IH] ;
      "WORKING ON BANDWIDTH " H ;
    OUT = BNLLR1(BINCTS,PGRID[1],PGRID[NP],H,IKER,KPAR) ;
    EOUT[.,IH] = OUT[.,1] ;        /*  CHOP OFF KERNEL FUNCTION  */

    _PLEGSTR = _PLEGSTR$+"\000h = "$+FTOS(H,"%*.*lf",5,3) ;
    IH = IH + 1 ;
  ENDO ;

    _PLEGCTL = 2|4|3|.7 ;
    YTICS(0,1.2,.2,1) ;
    _PLTYPE = 6|3|3|4|3|3|3|4|3|3 ;
    _PLCTRL = 0 ;

      TITSTR = "Example 5a: High Noise, Gaussian Kernel LL Smooths" ;
      TITSTR = TITSTR$+"\LDotted Smooths are `Good at Bumps'" ;
    TITLE(TITSTR) ;
    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR5AS.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR5AS.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
  XY(PGRID,MP~EOUT) ;

ENDIF ;



IF IPLOTB == 1 ;
  _PLCTRL = 0|-1 ;

    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR5B.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR5B.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;

    _PLEGCTL = 0 ;
    YTICS(0,1,.2,1) ;
      TITSTR = "Example 5B: Target and Data, Low Noise, n = " ;
      TITSTR = TITSTR$+FTOS(NB,"%*.*lf",1,0) ;
      TITSTR = TITSTR$+",  sig = "$+FTOS(SIGB,"%*.*lf",4,2) ;
    TITLE(TITSTR) ;
  XY(XGRIDB,MB~YB) ;

ENDIF ;



IF IPLOTBS == 1 ;
  "MAKE PLOT OF FAMILY OF ESTIMATES" ;
  VH = SEQM(.005,SQRT(2),7) ;
  IKER = 1 ;
  KPAR = 0 ;
    ENDCT = 1 ;
  BINCTS = ONES(NB,1)~YB ;
  EOUT = ZEROS(NB,ROWS(VH)) ;
  _PLEGSTR = "Data\000True" ;
  IH = 1 ;
  DO WHILE IH <= ROWS(VH) ;
    H = VH[IH] ;
      "WORKING ON BANDWIDTH " H ;
    OUT = BNLLR1(BINCTS,PGRID[1],PGRID[NP],H,IKER,KPAR) ;
    EOUT[.,IH] = OUT[.,1] ;        /*  CHOP OFF KERNEL FUNCTION  */

    _PLEGSTR = _PLEGSTR$+"\000h = "$+FTOS(H,"%*.*lf",5,3) ;
    IH = IH + 1 ;
  ENDO ;

    _PLEGCTL = 2|4|3|.7 ;
    YTICS(0,1.2,.2,1) ;
    _PLTYPE = 6|6|3|3|3|3|4|3|3|3|3 ;
    _PLCTRL = -1|0|0|0|0|0|0|0|0|0|0 ;

      TITSTR = "Example 5b: Low Noise, Gaussian Kernel LL Smooths" ;
      TITSTR = TITSTR$+"\LDotted Smooth is `Visual Compromise'" ;
    TITLE(TITSTR) ;
    IF AUTOP == 1 ;
        PRSTR = "-C=3 -CF=\\GAUSS\\STEVE\\PS\\NR5BS.PLT" ;
      GRAPHPRT(PRSTR) ;
    ELSEIF AUTOP == 2 ;
        PRSTR = "-C=1 -CF=\\GAUSS\\STEVE\\PS\\NR5BS.PS" ;
      GRAPHPRT(PRSTR) ;
    ENDIF ;
  XY(XGRIDB,YB~MB~EOUT) ;

ENDIF ;




IF IDATFILE == 1 ;

  OUTPUT FILE=NRDAT5A.DAT RESET ;     /*  CREATE DATA FILE A  */
      FORMAT /RD 8,6 ;
    XGRIDA~MA~YA ;
  OUTPUT OFF ;

  OUTPUT FILE=NRDAT5B.DAT RESET ;     /*  CREATE DATA FILE B  */
      FORMAT /RD 8,6 ;
    XGRIDB~MB~YB ;
  OUTPUT OFF ;

  OUTPUT FILE=NRDAT5.DSC RESET ;     /*  CREATE DISCUSSION FILE  */
    "  DETAILS OF FILES: NRDAT5A.DAT & NRDAT5B.DAT      CREATED " DATESTR(0) ;
    ? ;
    "    THIS IS A TEST DATA SET FOR COMPARISON OF REGRESSION ESTIMATORS " ;
    "    THESE ARE EXTREME DATA SETS, IN SENSE OF:" ;
    "            A   -   HIGH NOISE   " ;
    "            B   -   LOW NOISE   " ;
    ? ; ? ; ? ;
      FORMAT 1,0 ;
    "    FOR DATA SET A     (IN NRDAT5A.DAT)  " ;
    "         ROWS ARE OBSERVATIONS, n = " NA ;
    ? ;
    "         COLUMN 1       -  THE X'S  (EQUALLY SPACED [0,1])" ;
    "         COLUMN 2       -  THE TARGET CURVE, M(X) " ;
    "         COLUMN 3       -  Y = M(X) + SIG * EPS" ;
    "                              FOR EPS ~ N(0,1) " ;
      FORMAT 5,3 ;
    "                              AND SIG = " SIGA ;
    ? ; ? ; ? ;
      FORMAT 1,0 ;
    "    FOR DATA SET B     (IN NRDAT5B.DAT)  " ;
    "         ROWS ARE OBSERVATIONS, n = " NB ;
    ? ;
    "         COLUMN 1       -  THE X'S  (EQUALLY SPACED [0,1])" ;
    "         COLUMN 2       -  THE TARGET CURVE, M(X) " ;
    "         COLUMN 3       -  Y = M(X) + SIG * EPS" ;
    "                              FOR EPS ~ N(0,1) " ;
      FORMAT 5,3 ;
    "                              AND SIG = " SIGB ;

  OUTPUT OFF ;
  FORMAT 8,5 ;

ENDIF ;



END ;

