disp('Running MATLAB script file nmpar.m') ;
%
%    For generating Normal mixture parameters,
%      of the 15 Normal Mixture densities
%      from Marron and Wand (1992),
%      plus number 16 from Janssen, et. al.
%
%    For each case, there is a matrix nmpar_, with column
%    vectors, means in 1st col, vars in 2nd col, wts in 3rd col
%
%    Stores parameters in the file nmpar.mat, which can be read by
%    "load nmpar" (automatically putting all parameter vectors in)
%    when the file nmpar.mat IS IN THE CURRENT DIRECTORY.
%   
%    Parameters from GAUSS Program NMPAR.PRG


nmtit1 = 'Gaussian' ;
mu = 0 ;
sig2 = 1 ;
w = 1 ;
nmpar1 = [mu, sig2, w] ;

nmtit2 = 'Skewed' ;
mu = [-.3; .3; 1] ;
sig2 = [1.44; .64; 4/9] ;
w = [.2; .2; .6] ;
nmpar2 = [mu, sig2, w] ;

nmtit3 = 'Str Skew' ;
sig = (2/3).^((0:7)') ;
mu = 3 * (sig - 1) ;
sig2 = sig.^2 ;
w = ones(8,1) / 8 ;
nmpar3 = [mu, sig2, w] ;

nmtit4 = 'Kurtotic' ;
mu = [0; 0] ;
sig2 = [1 ; .01] ;
w = [2/3; 1/3] ;
nmpar4 = [mu, sig2, w] ;

nmtit5 = 'Outlier' ;
mu = [0; 0] ;
sig2 = [1; .01] ;
w = [.1; .9] ;
nmpar5 = [mu, sig2, w] ;

nmtit6 = 'Bimodal' ;
mu = [-1; 1] ;
sig2 = [4/9; 4/9] ;
w = [.5; .5] ;
nmpar6 = [mu, sig2, w] ;

nmtit7 = 'Separated' ;
mu = [-1.5; 1.5] ;
sig2 = [1/4; 1/4] ;
w = [.5; .5] ;
nmpar7 = [mu, sig2, w] ;

nmtit8 = 'Asym Bim' ;
mu = [0; 1.5] ;
sig2 = [1; 1/9] ;
w = [.75; .25] ;
nmpar8 = [mu, sig2, w] ;

nmtit9 = 'Trimodal' ;
mu = [-1.2; 1.2; 0] ;
sig2 = [9/25; 9/25; 1/16] ;
w = [.45; .45; .1] ;
nmpar9 = [mu, sig2, w] ;

nmtit10 = 'Claw' ;
mu = [0; (-1:.5:1)'] ;
sig2 = [1; .01*ones(5,1)] ;
w = [.5; .1*ones(5,1)] ;
nmpar10 = [mu, sig2, w] ;

nmtit11 = 'Doub Claw' ;
mu = [-1; 1; (-1.5:.5:1.5)'] ;
sig2 = [4/9; 4/9; .0001*ones(7,1)] ;
w = [.98*[.5; .5]; .02*ones(7,1)/7] ;
nmpar11 = [mu, sig2, w] ;

nmtit12 = 'Asym Claw' ;
mu = [-2; -1; 0; 1; 2] ;
mu = mu + .5 ;
sig2 = [.16; .04; .01; .0025; .000625] ;
w = sqrt(sig2) ;
w = w / sum(w) ;
mu = [0; mu] ;
sig2 = [1; sig2] ;
w = [.5; .5*w] ;
nmpar12 = [mu, sig2, w] ;

nmtit13 = 'As Do Claw' ;
mu = [-1.5; -1; -.5] ;
mu = [mu; mu+2] ;
sig2 = [.0001; .0001; .0001] ;
sig2 = [sig2; 49*sig2] ;
w = [1/3; 1/3; 1/3;] ;
mu = [-1; 1; mu] ;
sig2 = [4/9; 4/9; sig2] ;
w = [.46; .46; .01*w; .07*w] ;
nmpar13 = [mu, sig2, w] ;

nmtit14 = 'Smoo Comb' ;
n = 6 ;
sig2 = .25.^((0:(n-1))') ;
sig = sqrt(sig2) ;
w = sig / sum(sig) ;
mu = 0 ;
il = -3 ;
ir = 3 ;
for i = 2:n ;
  mu = [mu; ir + 3 * sig(i,1)] ;
  ir = ir + 6 * sig(i,1) ;
end ;
mu = 6 * ((mu - il) / (ir - il)) - 3 ;
sig2 = (6 / (ir - il))^2 * sig2 ;
nmpar14 = [mu, sig2, w] ;

nmtit15 = 'Disc Comb' ;
mu = [0; 6; 12; 15.5; 16.5; 17.5] ;
sig2 = [1; 1; 1; 1/36; 1/36; 1/36] ;
sig = sqrt(sig2) ;
w = sig / sum(sig) ;
il = -3 ;
ir = 18 ;
mu = 6 * ((mu - il) / (ir - il)) - 3 ;
sig2 = (6 / (ir - il))^2 * sig2 ;
nmpar15 = [mu, sig2, w] ;

nmtit16 = 'Dist Bim' ;
mu = [-2.5; 2.5] ;
sig2 = [1/36; 1/36] ;
w = [.5; .5] ;
nmpar16 = [mu, sig2, w] ;

save nmpar nmpar1 nmpar2 nmpar3 nmpar4 ...
           nmpar5 nmpar6 nmpar7 nmpar8 ...
           nmpar9 nmpar10 nmpar11 nmpar12 ...
           nmpar13 nmpar14 nmpar15 nmpar16 ...
           nmtit1 nmtit2 nmtit3 nmtit4 ...
           nmtit5 nmtit6 nmtit7 nmtit8 ...
           nmtit9 nmtit10 nmtit11 nmtit12 ...
           nmtit13 nmtit14 nmtit15 nmtit16 ;

