function boxutil(x,notch,lb,lf,sym,vert,whis)
%BOXUTIL Produces a single box plot.
%	BOXUTIL(X) is a utility function for BOXPLOT, which calls
%	BOXUTIL once for each column of its first argument. Use
%	BOXPLOT rather than BOXUTIL. 

%	Copyright (c) 1993 by The MathWorks, Inc.
%	$Revision: 1.1 $  $Date: 1993/05/24 18:53:44 $

% Make sure X is a vector.
if min(size(x)) ~= 1, 
    error('The first argument must be a vector.'); 
end

if nargin ~= 7
    error('Boxutil requires seven input arguments.');
end

% define the median and the quantiles
med = prctile(x,50);
q1 = prctile(x,25);
q3 = prctile(x,75);

% find the extreme values (to determine where whiskers appear)
vhi = q3+whis*(q3-q1);
[l,ind] = min(abs((x - vhi) + (x > vhi) * max(abs(x - vhi))));
upadj = x(ind);
vlo = q1-whis*(q3-q1);
[l,ind] = min(abs((vlo - x) + (vlo > x) * max(abs(vlo - x))));
loadj = x(ind);

x1 = lb*ones(1,2);
x2 = x1+[-0.25*lf,0.25*lf];
yy = x(x<loadj | x > upadj);

if isempty(yy)
    yy = loadj;
    sym = 'g.';
end

xx = lb*ones(1,length(yy));
    lbp = lb + 0.5*lf;
    lbm = lb - 0.5*lf;

% Set up (X,Y) data for notches if desired.
if ~notch
    xx2 = [lbm lbp lbp lbm lbm];
    yy2 = [q3 q3 med med q3];
    yy3 = [med med q1 q1 med];
else
    n1 = med + 1.57*(q3-q1)/sqrt(length(x));
    n2 = med - 1.57*(q3-q1)/sqrt(length(x));
    if n1>q3, n1 = q3; end
    if n2<q1, n2 = q1; end
    lnm = lb-0.25*lf;
    lnp = lb+0.25*lf;
    xx2 = [lbm lbp lbp lnp lnm lbm lbm];
    yy2 = [q3 q3 n1 med med n1 q3];
    yy3 = [q1 q1 n2 med med n2 q1];
end

% Determine if the boxes are vertical or horizontal.
% The difference is the choice of x and y in the plot command.
if vert
    plot(x1,[q3 upadj],'g--',x1,[loadj q1],'g--',...
        x2,[loadj loadj],'g-',...
        x2,[upadj upadj],'g-',xx2,yy2,'g-',xx2,yy3,'g-',xx,yy,sym)
else
    plot([q3 upadj],x1,'g--',[loadj q1],x1,'g--',...
        [loadj loadj],x2,'g-',...
        [upadj upadj],x2,'g-',yy2,xx2,'g-',yy3,xx2,'g-',yy,xx,sym)
end
