%CONV2 Two dimensional convolution.
%   C = CONV2(A, B) performs the 2-D convolution of matrices
%   A and B.   If [ma,na] = size(A) and [mb,nb] = size(B), then
%   size(C) = [ma+mb-1,na+nb-1].
%   C = CONV2(HCOL, HROW, A) convolves A separably with HCOL
%   in the column direction and HROW in the row direction.
%   HCOL and HROW should both be vectors.
%
%   C = CONV2( ... ,'shape') returns a subsection of the 2-D
%   convolution with size specified by 'shape':
%     'full'  - (default) returns the full 2-D convolution,
%     'same'  - returns the central part of the convolution
%               that is the same size as A.
%     'valid' - returns only those parts of the convolution
%               that are computed without the zero-padded
%               edges, size(C) = [ma-mb+1,na-nb+1] when
%               size(A) > size(B).
%   CONV2 is fastest when size(A) > size(B).
%
%   See also XCORR2, CONV, FILTER2.

%   Copyright (c) 1984-98 by The MathWorks, Inc.
%   $Revision: 5.10 $  $Date: 1997/11/21 23:23:31 $
%   This function is implemented as a mex file.
