 function [xm,xv,r,stat,ifail] = g13abf(x,nk,ifail)
%
% G13ABF  Univariate time series, sample autocorrelation function
%
%[xm,xv,r,stat,ifail] = g13abf(x,nk<,ifail>)
%
% 
% The data consist of n observations x , for i=1,2,...,n from a 
%                                     i                        
% time series.
% 
% The quantities calculated are
% 
% (a)   The sample mean
%                                    n   
%                                    --  
%                                    >  x 
%                                    --  i
%                                _   i=1 
%                                x= ------
%                                     n
% 
% (b)   The sample variance (for n>=2)
%                                  n        
%                                  --     _ 2
%                                  >  (x -x) 
%                                  --   i   
%                              2   i=1      
%                             s = -----------
%                                    (n-1)
% 
% (c)   The sample autocorrelation coefficients of lags k=1,2,...,K,
%       where K is a user-specified maximum lag, and K<n, n>1.
%       
%       The coefficient of lag k is defined as
%                              n-k             
%                              --     _       _
%                              >  (x -x)(x   -x)
%                              --   i     i+k  
%                              i=1             
%                         r = ------------------
%                          k      n        
%                                 --     _ 2
%                                 >  (x -x) 
%                                 --   i   
%                                 i=1      
%
% (d)   A test statistic defined as
%                                     K    
%                                     --  2
%                              STAT=n >  r ,
%                                     --  k
%                                     k=1  
%       which can be used to test the hypothesis that the true 
%       autocorrelation function is identically zero.
%       
%       If n is large and K is much smaller than n, STAT has a 
%            2                                            
%       (chi)  distribution under the hypothesis of a zero 
%            K                                            
%       autocorrelation function. Values of STAT in the upper tail 
%       of the distribution provide evidence against the 
%       hypothesis.
%       
%g13abf
%
%Required Input Arguments:
%
%x (:)                                 real
%nk                                    integer
%
%Optional Input Arguments:                       <Default>
%
%ifail                                 integer  -1
%
%Output Arguments:
%
%xm                                    real
%xv                                    real
%r (nk)                                real
%stat                                  real
%ifail                                 integer
 
%
%             [NAGWare Gateway Generator ]
%
% Copyright (c) 1993-1995 by the Numerical Algorithms Group Ltd 1.3 
% $Revision: 1.1 $  $Date: 1995/04/12 13:38:01 $
%
%Set default input values for optional arguments
%
nx = length(x);
%
 if nargin < 3 , ifail = -1; end
%
%
if ifail~=-1 & ifail~=1
  fprintf('Error: Illegal IFAIL value: %d\n',ifail)
  ifail=-1
end
%
%Call the MEX function
%
 [xm,xv,r,stat,ifail] = nagg('g13abf',x,nk,nx,ifail);
%
