function [] = gpoutly(data) 
% GPOUTLY, General Purpose OUTLIer finder for univariate data
%     Puts a plot in the current graphics window, with a family
%     of kernel density estimates, overlaid with vertical lines
%     showing estimated standard deviation of the mean
% Inputs:
%     data - vector of data
% Output:
%     only graphics in the current window and axes
%
% Assumes path can find personal functions:
%    gpmad.m
%    vec2mat.m
%    phiinv.m

%    Copyright (c) J. S. Marron 1998



%  Check that input is a vector
%
if min(size(data)) == 1 ;     %  then is a vector, so go ahead

  %  put down kde family
  %
  gpfam(data) ;

  %  set up axis info
  %
  vax = axis ;
  left = vax(1) ;
  right = vax(2) ;
  bottom = vax(3) ;
  top = vax(4) ;

  %  overlay a robust fit normal curve
  %
  mu = median(data) ;
  sig = gpmad(data) ;
  dgrid = linspace(left,right,100)' ;
  hold on ;
    plot(dgrid,nmf(dgrid,mu,sig^2,1),'c--') ;
      vchil = get(gca,'Children') ;
      set(vchil(1),'LineWidth',2) ;
  hold off ;


  %  add vertical lines showing mean +- sd's
  %
  hold on ;
    plot([mu; mu],[bottom; top],'--') ;
    plot([mu+2*sig; mu+2*sig],[bottom; top],':') ;
    plot([mu-2*sig; mu-2*sig],[bottom; top],':') ;

    lineloc = mu + 4 * sig ;
    while lineloc < right ;    %  cont. with lines towards right boundary
      plot([lineloc; lineloc],[bottom; top],':') ;
      lineloc = lineloc + 2 * sig ;
    end ;

    lineloc = mu - 4 * sig ;
    while lineloc > left ;    %  cont. with lines towards left boundary
      plot([lineloc; lineloc],[bottom; top],':') ;
      lineloc = lineloc - 2 * sig ;
    end ;
  hold off ;




else ;      %  then wrong input, give a warning

  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Warning from gpoutly.m:       !!!') ;
  disp('!!!   input data was not a vector   !!!') ;
  disp('!!!     so no graphics created      !!!') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

end ;


