disp('Running MATLAB script file gpvpert.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION gpvper.m,
%    General Purpose Visualization of Periodicities

itest = 7 ;     %   1,2,3,4,5,6,7

format compact ;



if itest == 1 ;    

  y = [3; 4; 5; 1; 2; 3; 3] ;
  y = kron(ones(10,1),y) ;

  gpvper(y) ;


elseif itest == 2 ;

  r = 18 ;   %  [1,40], [1,20], [10,20], [17,19], [18,18], 18

  y = [3; 4; 5; 1; 2; 3; 3] ;
  y = kron(ones(10,1),y) ;

  gpvper(y,r) ;


elseif itest == 3 ;

  disp('Loading sunspot data') ;
    infstr = 'sunspot.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\gauss\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  r = [5,15] ;     %    [1,30], [5,15]

  gpvper(data,r) ;



elseif itest == 4 ;

  disp('Loading Canadian Lynx data') ;
    infstr = 'canlynx.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\gauss\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  r = [5,15] ;     %    [1,30], [5,15]

  gpvper(data,r) ;


elseif itest == 5 ;

  disp('Loading Airline Passenger Data') ;
    infstr = 'airpass.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\matlab\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  r = [1,30] ;     %    [1,30], [5,15]

  gpvper(data,r) ;


elseif itest == 6 ;

  disp('Loading Airline Passenger Data') ;
    infstr = 'airpass.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\matlab\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  data = data - gppolyf([(1:length(data))',data],1,0) ;
          %  subtract linear fit (no pic)

  r = [1,30] ;     %    [1,30], [5,15]

  gpvper(data,r) ;





elseif itest == 7 ;

  disp('Loading Airline Passenger Data') ;
    infstr = 'airpass.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\matlab\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  data = log10(data) ;

  data = data - gppolyf([(1:length(data))',data],1,0) ;
          %  subtract linear fit (no pic)

  r = [5,7] ;     %    [1,30], [3,15], [5,7]

  gpvper(data,r) ;




end ;



