disp('Running MATLAB script file ViewDimAwayt.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION ViewDimAway,
%    for VIEW of DIMensions AWAY,
%    which studies "range" of high dimensional point clouds,
%    by graphics which focus on "dimensionality" of 
%    spherical normal point clouds


itest = 50 ;     %  1  -  default version
                 %  2  -  default but with ones target
                 %  3  -  Simplest test of direct only
                 %  4  -  Simplest test of P.I.T. only
                 %  5  -  Simplest test of Q-Q plot only
                 %  6  -  work with d0
                 %  7  -  work with movie
                 %
                 %  11 - Careful 80-d N(0,I) pairwise
                 %  12 - Careful 80-d 20-d N(0,I) pairwise
                 %  13 - Careful 80-d 5-d N(0,I) pairwise
                 %  14 - 80-d .5 N(0,1) + .5 N(.3^d,1), pairwise
                 %  15 - 80-d .5 N(0,1) + .5 N(.3^d,1), 1^d target
                 %  16 - 80-d .5 N(0,1) + .5 N(.6^d,1), pairwise
                 %  17 - 80-d .5 N(0,1) + .5 N(.6^d,1), 1^d target
                 %  18 - 80-d .5 N(2^d,1) + .5 N(-2^d,1), pairwise
                 %  19 - 80-d .5 N(1^d,.2) + .5 N(-1^d,.2), pairwise
                 %
                 %  >20   Do careful parameter checks


idat = 2 ;      %  1  -  80-d  N(0,I), n = 50
                %  2  -  80-d  20-d, N(0,I), n = 50
                %  3  -  80-d  5-d, N(0,I), n = 50
                %  4  -  80-d .5 N(0,1) + .5 N(.3^d,1), n = 50
                %  5  -  80-d .5 N(0,1) + .5 N(.6^d,1), n = 50
                %  6  -  80-d .5 N(2^d,1) + .5 N((-2)^d,1), n = 50
                %  7  -  80-d .5 N(1^d,.2) + .5 N((-1)^d,.2), n = 50



format compact ;





if idat == 1 ;

  seed = 30495703 ;
  n = 50 ;
  d = 80 ;

  randn('seed',seed) ;
  mdat = randn(d,n) ;


elseif idat == 2 ;

  seed = 30495703 ;
  n = 50 ;
  d = 80 ;
  dstar = 20 ;

  randn('seed',seed) ;
  mdat = randn(dstar,n) ;
  mdat = [mdat; zeros(d-dstar,n)] ;


elseif idat == 3 ;

  seed = 30495703 ;
  n = 50 ;
  d = 80 ;
  dstar = 5 ;

  randn('seed',seed) ;
  mdat = randn(dstar,n) ;
  mdat = [mdat; zeros(d-dstar,n)] ;


elseif idat == 4 ;

  seed = 94857759 ;
  n = 25 ;
  d = 80 ;

  randn('seed',seed) ;
  mdat = randn(d,n) ;
          %  N(0,1)'s
  mdat = [mdat, randn(d,n) + 0.3 * ones(d,n)] ;
          %  N(0,.3^d)'s


elseif idat == 5 ;

  seed = 94857759 ;
  n = 25 ;
  d = 80 ;

  randn('seed',seed) ;
  mdat = randn(d,n) ;
          %  N(0,1)'s
  mdat = [mdat, randn(d,n) + 0.6 * ones(d,n)] ;
          %  N(0,.6^d)'s


elseif idat == 6 ;

  seed = 94857759 ;
  n = 25 ;
  d = 80 ;

  randn('seed',seed) ;
  mdat = randn(d,n)  + 2 * ones(d,n);
          %  N(1^d,1)'s
  mdat = [mdat, randn(d,n) - 2 * ones(d,n)] ;
          %  N(-1^d,1)'s


elseif idat == 7 ;

  seed = 94857759 ;
  n = 25 ;
  d = 80 ;

  randn('seed',seed) ;
  mdat = 0.2 * randn(d,n)  + 1 * ones(d,n);
          %  N(1^d,0.1)'s
  mdat = [mdat, 0.2 * randn(d,n) - 1 * ones(d,n)] ;
          %  N(-1^d,0.1)'s


end ;





if itest == 1 ;    %  then do simplest default

  ViewDimAway(mdat) ;


elseif itest == 2 ;    %  then do default, against ones target

  vtar = ones(d,1) ;

  ViewDimAway(mdat,vtar) ;


elseif itest == 3 ;    %  then do simplest single plot, against ones target

  vtar = ones(d,1) ;

  paramstruct = struct('iout',3, ...
                       'imovie',0, ...
                       'iscreenwrite',1 ...
                                             ) ;
  clf ;

  ViewDimAway(mdat,vtar,paramstruct) ;


elseif itest == 4 ;    %  then do simplest P. I. T., against ones target

  vtar = ones(d,1) ;

  paramstruct = struct('iout',4, ...
                       'imovie',0, ...
                       'iscreenwrite',1 ...
                                             ) ;
  clf ;

  ViewDimAway(mdat,vtar,paramstruct) ;


elseif itest == 5 ;    %  then do simplest Q-Q Plot, against ones target

  vtar = ones(d,1) ;

  paramstruct = struct('iout',5, ...
                       'imovie',0, ...
                       'iscreenwrite',1 ...
                                             ) ;
  clf ;

  ViewDimAway(mdat,vtar,paramstruct) ;


elseif itest == 6 ;    %  fiddle with d0

  paramstruct = struct('d0',3, ...
                       'imovie',0, ...
                       'iscreenwrite',1 ...
                                             ) ;

          %  set idat = 2, and try 80,40,20,10,5


  ViewDimAway(mdat,0,paramstruct) ;


elseif itest == 7 ;    %  work with movie

  paramstruct = struct('imovie',1, ...
                       'dstart',10, ...
                       'dend',30, ...
                       'iscreenwrite',1, ...
                       'savestr','TestVDA' ...
                                             ) ;

          %  idat = 2 is best for 10,30


  ViewDimAway(mdat,0,paramstruct) ;




elseif itest == 11 ;

  %  Check idat
  %
  if idat == 1 ;

    figure(1) ;
    clf ;
    set(gcf,'Position',[600 150 400 550]) ;

    paramstruct = struct('iscreenwrite',1, ...
                         'imovie',0, ...
                         'iout',1, ...
                         'titlestr','d=80, N(0,I)', ...
           'savestr','\Talks\ComplexPopn\HiDimGauss\VDA80Norm', ...
                         'dstart',50, ...
                         'dend',80 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)
 

  else ;
    disp('???  Set idat to 1, when using itest = 11') ;
  end ;


elseif itest == 12 ;

  %  Check idat
  %
  if idat == 2 ;

    figure(1) ;
    clf ;
    set(gcf,'Position',[600 150 400 550]) ;

    paramstruct = struct('iscreenwrite',1, ...
                         'imovie',1, ...
                         'iout',1, ...
                         'titlestr','d=80, 20-d N(0,I)', ...
           'savestr','\Talks\ComplexPopn\HiDimGauss\VDA80Norm20d', ...
                         'dstart',10, ...
                         'dend',35 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)
 

  else ;
    disp('???  Set idat to 2, when using itest = 12') ;
  end ;


elseif itest == 13 ;

  %  Check idat
  %
  if idat == 3 ;

    figure(1) ;
    clf ;
    set(gcf,'Position',[600 150 400 550]) ;

    paramstruct = struct('iscreenwrite',1, ...
                         'imovie',1, ...
                         'iout',1, ...
                         'titlestr','d=80, 5-d N(0,I)', ...
           'savestr','\Talks\ComplexPopn\HiDimGauss\VDA80Norm5d', ...
                         'dstart',1, ...
                         'dend',20 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)
 

  else ;
    disp('???  Set idat to 3, when using itest = 13') ;
  end ;


elseif itest == 14 ;

  %  Check idat
  %
  if idat == 4 ;

    figure(1) ;
    clf ;
    set(gcf,'Position',[600 150 400 550]) ;

    paramstruct = struct('iscreenwrite',1, ...
                         'imovie',1, ...
                         'iout',1, ...
                         'titlestr','.5 N(0,1) + .5 N(.3^d,1)', ...
           'savestr','\Talks\ComplexPopn\HiDimGauss\VDA80NpN3', ...
                         'dstart',50, ...
                         'dend',80 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)
 

  else ;
    disp('???  Set idat to 4, when using itest = 14') ;
  end ;


elseif itest == 15 ;

  %  Check idat
  %
  if idat == 4 ;

    figure(1) ;
    clf ;
    set(gcf,'Position',[600 150 400 550]) ;

    vtar = ones(d,1) ;

    paramstruct = struct('iscreenwrite',1, ...
                         'imovie',1, ...
                         'iout',1, ...
                         'titlestr','.5 N(0,1) + .5 N(.3^d,1) vs. 1^d', ...
           'savestr','\Talks\ComplexPopn\HiDimGauss\VDA80NpN3t1', ...
                         'dstart',20, ...
                         'dend',45 ...
                                          ) ;
    ViewDimAway(mdat,vtar,paramstruct)
 

  else ;
    disp('???  Set idat to 4, when using itest = 15') ;
  end ;


elseif itest == 16 ;

  %  Check idat
  %
  if idat == 5 ;

    figure(1) ;
    clf ;
    set(gcf,'Position',[600 150 400 550]) ;

    paramstruct = struct('iscreenwrite',1, ...
                         'imovie',1, ...
                         'iout',1, ...
                         'titlestr','.5 N(0,1) + .5 N(.6^d,1)', ...
           'savestr','\Talks\ComplexPopn\HiDimGauss\VDA80NpN6', ...
                         'dstart',40, ...
                         'dend',60 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)
 

  else ;
    disp('???  Set idat to 5, when using itest = 16') ;
  end ;


elseif itest == 17 ;

  %  Check idat
  %
  if idat == 5 ;

    figure(1) ;
    clf ;
    set(gcf,'Position',[600 150 400 550]) ;

    vtar = ones(d,1) ;

    paramstruct = struct('iscreenwrite',1, ...
                         'imovie',1, ...
                         'iout',1, ...
                         'titlestr','.5 N(0,1) + .5 N(.6^d,1) vs. 1^d', ...
           'savestr','\Talks\ComplexPopn\HiDimGauss\VDA80NpN6t1', ...
                         'dstart',20, ...
                         'dend',45 ...
                                          ) ;
    ViewDimAway(mdat,vtar,paramstruct)
 

  else ;
    disp('???  Set idat to 5, when using itest = 17') ;
  end ;


elseif itest == 18 ;

  %  Check idat
  %
  if idat == 6 ;

    figure(1) ;
    clf ;
    set(gcf,'Position',[600 150 400 550]) ;

    paramstruct = struct('iscreenwrite',1, ...
                         'imovie',1, ...
                         'iout',1, ...
                         'titlestr','.5 N(2^d,1) + .5 N(-2^d,1)', ...
           'savestr','\Talks\ComplexPopn\HiDimGauss\VDA80N1Nm1', ...
                         'dstart',1, ...
                         'dend',10 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)
 

  else ;
    disp('???  Set idat to 6, when using itest = 18') ;
  end ;


elseif itest == 19 ;

  %  Check idat
  %
  if idat == 7 ;

    figure(1) ;
    clf ;
    set(gcf,'Position',[600 150 400 550]) ;

    paramstruct = struct('iscreenwrite',1, ...
                         'imovie',1, ...
                         'iout',1, ...
                         'titlestr','.5 N(1^d,.2) + .5 N(-1^d,.2)', ...
           'savestr','\Talks\ComplexPopn\HiDimGauss\VDA80N1m1S01', ...
                         'dstart',1, ...
                         'dend',10 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)
 

  else ;
    disp('???  Set idat to 6, when using itest = 19') ;
  end ;







elseif itest >= 21 ;    %  then do parameter tests


  if itest == 21 ;    %  Try dummy paramstruct
    paramstruct = 3 ;
    ViewDimAway(mdat,0,paramstruct) ;

  elseif itest == 22 ;
    paramstruct = struct('iscreenwrite',1 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct) ;

  elseif itest == 23 ;
    paramstruct = struct('iscreenwrite',1,...
                         'iout',1 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct) ;

  elseif itest == 24 ;  
    paramstruct = struct('iscreenwrite',1,...
                         'iout',2 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct) ;

  elseif itest == 25 ;  
    paramstruct = struct('iscreenwrite',1,...
                         'iout',3 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct) ;

  elseif itest == 26 ;
    figure(2) ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',4 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 27 ;
    figure(3) ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',5 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 28 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',6 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 29 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',1, ...
                         'iout',2 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 30 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',1, ...
                         'iout',3 ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 31 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'savestr','test1' ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)
    dir ;

  elseif itest == 32 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'savestr','\temp\test2' ...
                                          ) ;
    ViewDimAway(mdat,0,paramstruct)
    dir \temp\*.ps ;

  elseif itest == 33 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',3, ...
                         'ndataoverlay',0 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 34 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',3, ...
                         'ndataoverlay',2 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 35 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',3, ...
                         'ndataoverlay',50 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 36 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',1, ...
                         'iout',2, ...
                         'd0',65 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 37 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',2, ...
                         'd0',20 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 38 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',2, ...
                         'dstart',30, ...
                         'dend',35, ...
                         'd0',20 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 39 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',1, ...
                         'iout',2, ...
                         'dstart',30, ...
                         'dend',35, ...
                         'd0',20 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)


  elseif itest == 40 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',1, ...
                         'iout',2, ...
                         'nrepeat',1, ...
                         'dstart',30, ...
                         'dend',35 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 41 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',1, ...
                         'iout',2, ...
                         'nrepeat',20, ...
                         'dstart',30, ...
                         'dend',33 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 42 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',1, ...
                         'titlestr','Test VDA', ...
                         'd0',20 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 43 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',2, ...
                         'titlestr','Test VDA', ...
                         'd0',20 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 44 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',3, ...
                         'titlestr','Test VDA', ...
                         'd0',20 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 45 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',4, ...
                         'titlestr','Test VDA', ...
                         'd0',20 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 46 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',5, ...
                         'titlestr','Test VDA', ...
                         'd0',20 ...
                                          ) ;
    clf ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 47 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',1, ...
                         'd0',20 ...
                                          ) ;
    clf ;
    set(gcf,'Position',[600 150 400 550]) ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 48 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',1, ...
                         'iout',1, ...
                         'savestr','temp', ...
                         'dstart',18, ...
                         'dend',22 ...
                                          ) ;
    clf ;
    set(gcf,'Position',[600 150 400 550]) ;
    ViewDimAway(mdat,0,paramstruct)
    disp('    Check that movie "temp.mpg" actually works') ;

  elseif itest == 49 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',0, ...
                         'iout',2, ...
                         'd0',20 ...
                                          ) ;
    clf ;
    set(gcf,'Position',[550 300 450 400]) ;
    ViewDimAway(mdat,0,paramstruct)

  elseif itest == 50 ;
    paramstruct = struct('iscreenwrite',1,...
                         'imovie',1, ...
                         'iout',2, ...
                         'savestr','temp', ...
                         'dstart',18, ...
                         'dend',22 ...
                                          ) ;
    close all ;
    set(gcf,'Position',[550 300 450 400]) ;
    ViewDimAway(mdat,0,paramstruct)
    disp('    Check that movie "temp.mpg" actually works') ;




  end ;



end ;



