disp('Running MATLAB script file cquantt.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION cquantt,
%    Continuous version of empirical quantiles

itest = 5 ;     %  1,2,3,4,5

format compact ;

if itest == 1 ; 
  indat = [2; 3; 8.5; 9] ;
elseif itest == 2 ; 
  indat = [3; 3; 4; 4; 4; 4; 6; 6.5; 9] ;
elseif itest == 3 ; 
  indat = [3; 3; 4; 6; 6.5; 6.5; 8; 8; 8] ;
elseif itest == 4 ; 
  indat = [3; 3; 3; 3] ;
elseif itest == 5 ; 
  indat = 8 * rand(24,1) + 1 ;
end ;

pgrid = linspace(-.1,1.1,401)' ;

out = cquant(indat,pgrid) ;

  nindat = length(indat) ;
  d = 1 / (nindat + 1) ;
plot(pgrid,out,'-y',(d:d:1-d)',sort(indat),'or') ;

