function out = gamcdf(x,alpha,lambda) 
% GAMCDF, Cumulative Distribution Function of the Gamma Distribution
% Inputs:
%     x      - matrix of quantile values
%     alpha  - matrix of shape parameters
%     lambda - matrix of scale parameters
%          these must all have the same size, or be of size 1,1
% Output:
%     out    - matrix of P(X <= x) for X ~ Gamma(alpha,lambda)
% Note:
%     Chi-Square Dist'n, with n d.f. has alpha = n/2, lamda = 1/2,
%     hence use "gamcdf(x,n/2,1/2)".

out = gammainc(lambda .* x, alpha) ;
