%MATLAB SCRIPT FILE gamcdft.m  */
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION gamcdf,
%    CUMULATIVE DISTRIBUTION FUNCTION OF THE GAMMA DIST'N

itest = 2 ;     %  1,2

format compact ;
running = [10 'MATLAB script gamcdf.m, test #' num2str(itest) 10]
          %  RECALL THAT "10" GIVES A LINE FEED

if itest == 1 ;     %  THEN RUN TEST 1: NUMERICAL INTEGRATION

  alp = 5 ;    %  HAVE TRIED 1,2,.2,5
  lam = 2 ;    %  HAVE TRIED 1,2,.2,5

  xgrid = 0:.05:200 ;
          %  GRID FOR NUMERICAL INTEGRATION
  outgam = 1 - gamcdf(xgrid,alp,lam) ;
          %  1 - CDF (AT GRID) FOR INTEGRATION
  meanni = trapz(xgrid,outgam) ;
          %  APPROX OF MEAN, BY NUMERICAL INTEGRATION

  meandir = alp / lam ;
          %  direct calculation of mean

  note = 'Mean using gamcdf, and numerical integration was: '
  meanni

  note = 'Actual mean was: '
  meandir

  note = 'absolute difference was: '
  abs(meanni - meandir) 


elseif itest == 2 ;     %  THEN RUN TEST 1: CHECK MATRICES AND CHI-SQUARE

  alp = [2 2 2; 10 10 10] / 2 ;
  lam = ones(2,3) / 2 ;

  mx = [.102587 5.99147 9.21034; 3.94030 18.3070 23.2093] ;
          %  FROM CHI-SQUARE TABLE
  table = 1 - (ones(2,1) * [.95 .05 .01]) ;
          %  FROM CHI-SQUARE TABLE

%  alp = 10 / 2 ;
%  lam = 1 / 2 ;
%  mx = 18.3070 ;
          %  TRIED UNCOMMENTING THESE TO CHECK SCALAR FUNCTION


  gamout = gamcdf(mx,alp,lam) ;

  note = 'Matrix of Table values is:'
  table

  note = 'Matrix of Calculated values is:'
  gamout

  note = 'Absolute Difference is:'
  abs(table - gamout)


end ;
