disp('Running MATLAB script file gpcd2t.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION gpcd2,
%    General Purpose Curves a Data analysis, 2nd generation

itest = 3 ;    %  1,2,3,4,5,6,7,8,9,10

ipar = 4 ;     %   1,2,3,4

itype = 5 ;    %   1,2,3,4,5

iout = 1 ;     %   1,2,3,4


format compact ;



if itest == 1 ;   
  %  Example called "Dog legs" in cdtest3.m
  n = 50 ;
  mu = [1; 0; .5] ;
  msig = [.3 0 .29; 0 .05 0; .29 0 .3] ;
  cmax = 2 ;
  randn('seed',23729877) ;
  mz = randn(3,n) ;
  mdata = sqrtm(msig) * mz + vec2mat(mu,n) ;
elseif itest == 2 ;
  %  Example called "Fans" in cdtest3.m
  n = 50 ;
  mu = [0; .5; 1] ;
  msig = [.01 .01 .01; .01 .25 .25; .01 .25 .5] ;
  cmax = 2.5 ;
  randn('seed',97987373) ;
  mz = randn(3,n) ;
  mdata = sqrtm(msig) * mz + vec2mat(mu,n) ;
elseif itest == 3 ;
  %  Example from classes\322\s322eg12.m
  d = 10 ;
  n = 50 ;
  xgrid = (.5:1:d)' ;
  mdata = (xgrid - 6).^2 ;
    randn('seed',88769874) ;
    eps1 = 4 * randn(1,n) ;
    eps2 = .5 * randn(1,n) ;
    eps3 = 1 * randn(d,n) ;
  mdata = vec2mat(mdata,n) + vec2mat(eps1,d) + ...
                 vec2mat(eps2,d) .* vec2mat(xgrid-d/2,n) + eps3 ;
elseif itest == 4 ;
  %  Example from classes\322\s322eg12.m  (with outlier added)
  d = 10 ;
  n = 50 ;
  xgrid = (.5:1:d)' ;
  mdata = (xgrid - 6).^2 ;
    randn('seed',88769874) ;
    eps1 = 4 * randn(1,n) ;
    eps2 = .5 * randn(1,n) ;
    eps3 = 1 * randn(d,n) ;
  mdata = vec2mat(mdata,n) + vec2mat(eps1,d) + ...
                 vec2mat(eps2,d) .* vec2mat(xgrid-d/2,n) + eps3 ;
  mdata = [mdata, 15 * (sin(pi * xgrid) + 1)] ;
elseif itest == 5 ;
  %  Example from classes\322\s322eg12.m  (with 2 outliers added)
  d = 10 ;
  n = 50 ;
  xgrid = (.5:1:d)' ;
  mdata = (xgrid - 6).^2 ;
    randn('seed',88769874) ;
    eps1 = 4 * randn(1,n) ;
    eps2 = .5 * randn(1,n) ;
    eps3 = 1 * randn(d,n) ;
  mdata = vec2mat(mdata,n) + vec2mat(eps1,d) + ...
                 vec2mat(eps2,d) .* vec2mat(xgrid-d/2,n) + eps3 ;
  mdata = [mdata, 15 * (sin(pi * xgrid) + 1)] ;
  mdata = [mdata, 10 * (sin((pi / 2) * xgrid) + 1)] ;
elseif itest == 6 ;
  %  called "Sin''s, Dec. Power" in cdtest2.m
  d = 10 ;
  n = 50 ;
  xgrid = (.5:1:d)' ;
    randn('seed',33399845) ;
  mdata = vec2mat(8 * randn(1,n),d) ;
    swave = vec2mat(sin(2 * pi * xgrid / d),n) ;
  mdata = mdata + (4 * swave .* vec2mat(randn(1,n),d)) ;
    swave = vec2mat(sin(4 * pi * xgrid / d),n) ;
  mdata = mdata + (2 * swave .* vec2mat(randn(1,n),d)) ;
    swave = vec2mat(sin(6 * pi * xgrid / d),n) ;
  mdata = mdata + (1 * swave .* vec2mat(randn(1,n),d)) ;
  mdata = mdata + .05 * randn(d,n) ;
elseif itest == 7 ;
  %  called "Sin''s, Inc. Power" in cdtest2.m
  d = 10 ;
  n = 50 ;
  xgrid = (.5:1:d)' ;
    randn('seed',98723999) ;
  mdata = vec2mat(1 * randn(1,n),d) ;
    swave = vec2mat(sin(2 * pi * xgrid / d),n) ;
  mdata = mdata + (2 * swave .* vec2mat(randn(1,n),d)) ;
    swave = vec2mat(sin(4 * pi * xgrid / d),n) ;
  mdata = mdata + (4 * swave .* vec2mat(randn(1,n),d)) ;
    swave = vec2mat(sin(6 * pi * xgrid / d),n) ;
  mdata = mdata + (8 * swave .* vec2mat(randn(1,n),d)) ;
  mdata = mdata + .05 * randn(d,n) ;
elseif itest == 8 ;
  %  new example, with 2 "clusters"
  d = 10 ;
  n = 50 ;
  xgrid = (.5:1:d)' ;
    randn('seed',23923874) ;
  mdata = (xgrid - 5).^2 - 5 ;
    randn('seed',88769874) ;
    mflag = vec2mat(2 * (randn(1,n) > .5) - 1,d) ;
    eps1 = 2 * randn(1,n) ;
    eps2 = .5 * randn(1,n) ;
    eps3 = .5 * randn(d,n) ;
  mdata = mflag .* vec2mat(mdata,n) + vec2mat(eps1,d) + ...
                 vec2mat(eps2,d) .* vec2mat(xgrid-d/2,n) + eps3 ;
elseif itest == 9 ;
  %  new example, with 4 "clusters"
  d = 50 ;
  n = 50 ;
  xgrid = (.5:1:d)' ;
    randn('seed',93759872) ;
    rand('seed',30458744) ;
  mdata = 5 * (1 - cos(4 * pi * xgrid / d)) ;
  mdata = vec2mat(mdata,n) ;
    halfd = floor(d/2) ;
    mflag = (1 - 2 * (rand(2,d) > .5)) ;
         %  random +- 1's
  mdata(1:halfd,:) = vec2mat(mflag(1,:),halfd) .* mdata(1:halfd,:) ;
  mdata((halfd+1):d,:) = vec2mat(mflag(2,:),d-halfd) .* ...
                                                mdata((halfd+1):d,:) ;
    eps3 = 1 * randn(d,n) ;
  mdata = mdata + eps3 ;
elseif itest == 10 ;
  %  new example, with 4 "clusters"
  d = 50 ;
  n = 50 ;
  xgrid = (.5:1:d)' ;
    randn('seed',93759872) ;
    rand('seed',30458744) ;
  mdata = 5 * (1 - cos(4 * pi * xgrid / d)) ;
  mdata = vec2mat(mdata,n) ;
    halfd = floor(d/2) ;
    mflag = (1 - 2 * (rand(2,d) > .5)) ;
         %  random +- 1's
  mdata(1:halfd,:) = vec2mat(mflag(1,:),halfd) .* mdata(1:halfd,:) ;
  mdata((halfd+1):d,:) = vec2mat(mflag(2,:),d-halfd) .* ...
                                                mdata((halfd+1):d,:) ;
    eps1 = .3 * randn(1,n) ;
    eps2 = .17 * randn(1,n) ;
    eps3 = .5 * randn(d,n) ;
  mdata = mdata + vec2mat(eps1,d) + ...
                 vec2mat(eps2,d) .* vec2mat(xgrid-d/2,n) + eps3 ;
end ; 



if ipar == 1 ;
  gpcd2(mdata) ;
elseif ipar == 2 ;
  gpcd2(mdata,itype) ;
elseif ipar == 3 ;
  gpcd2(mdata,itype,iout) ;
elseif ipar == 4 ;
    outps = ['cd2t' num2str(itest) num2str(itype)] ;
  gpcd2(mdata,itype,iout,outps) ;
  disp(' Now use Ghost view to check out file cd2t_.ps') ;
end;



