disp('Running MATLAB script file gpfamt.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION gpfam,
%    General Purpose Family Approach to smoothing

itest = 16 ;     %  1,2 small tests (density estimation)
                %  3  real data tests (density estimation)
                %  4  normal mixture tests (density estimation)
                %  11 small test (regression)
                %  12 real data tests (regression)
                %  13 NR book examples (regression)
                %  14 B-spline test examples (regression)
                %  15 ER Wavelet Examples (regression)
                %  16 fiddle with number in family


format compact ;


if itest == 1 ;   %  
  indat = [(randn(250,1) - 1.5); (randn(250,1) + 1.5)] ;
  gpfam(indat) ;
elseif itest == 2 ;   %
  indat = [randn(3000,1); .25 * randn(1000,1) + 2] ;
  gpfam(indat) ;
end ;
  title(['Family Approach, Test ' num2str(itest)]) ;


if itest == 3 ;    %  then do real data tests

  idat = 0 ;     %  0 - to loop through all
                 %  1 - Income Data
                 %  2 - Geyser Data
                 %  3 - Stamp Data
                 %  4 - Chondrite Data
                 %  5 - Buffalo Snowfall Data
                 %  6 - Suicide Data
                 %  7 - Coal Seam Data
                 %  8 - Marine Data
                 %  9 - Dust Data
                 %  10 - Galactic Cluster Data

  if idat == 0 ;
    idats = 1 ;
    idate = 10 ;
  else ;
    idats = idat ;
    idate = idat ;
  end ;

  for iidat = idats:idate ;

    if iidat == 1 ;
      dtitstr = 'Incomes' ;
      infstr = 'inc75.all' ;
      iincol = 1 ;    %  want all data as 1 column
    elseif iidat == 2 ;
      dtitstr = 'Geyser' ;
      infstr = 'geyser.dat' ;
      iincol = [2; 1] ;    %  data come as 2 columns, want col. 1
    elseif iidat == 3 ;
      dtitstr = 'Stamps' ;
      infstr = 'stamp' ;
      iincol = 1 ;    %  want all data as 1 column
    elseif iidat == 4 ;
      dtitstr = 'Chondrite' ;
      infstr = 'chrondit.asc' ;
      iincol = 1 ;    %  want all data as 1 column
    elseif iidat == 5 ;
      dtitstr = 'Snowfalls' ;
      infstr = 'buffalo.sno' ;
      iincol = 1 ;    %  want all data as 1 column
    elseif iidat == 6 ;
      dtitstr = 'Suicides' ;
      infstr = 'suicide.dat' ;
      iincol = 1 ;    %  want all data as 1 column
    elseif iidat == 7 ;
      dtitstr = 'Coal Seam' ;
      infstr = 'fishcoal.iva' ;
      iincol = 1 ;    %  want all data as 1 column
    elseif iidat == 8 ;
      dtitstr = 'Marine' ;
      infstr = 'freddat.asc' ;
      iincol = 1 ;    %  want all data as 1 column
    elseif iidat == 9 ;
      dtitstr = 'Dust' ;
      infstr = 'raydust.dat' ;
      iincol = 1 ;    %  want all data as 1 column
    elseif iidat == 10 ;
      dtitstr = 'Galaxies' ;
      infstr = 'galaxy.dat' ;
      iincol = 1 ;    %  want all data as 1 column
    end ;

    disp(['    Loading ' dtitstr ' Data']) ;
      infstr = ['\gauss\steve\data\' infstr] ;
      fid = fopen(infstr,'r') ;
        if iincol(1) == 1 ;
          data = fscanf(fid,'%g') ;
        elseif iincol(1) == 2 ;
          data = fscanf(fid,'%g') ;
          data = reshape(data,2,length(data)/2)' ;
                   %  since reshape fills down cols first
          data = data(:,iincol(2)) ;
        end ;
      fclose(fid) ;
%    disp(['    Read in ' num2str(length(data)) ' data points']) ;

    gpfam(data) ;
      title([dtitstr ' Data']) ;

    disp(['Any key to continue']) ;
    pause ;

  end ;

elseif itest == 4 ;    %  then do normal mixture tests

  %  Load Normal mixtures parameters from nnpar.mat
  %  !!!   Careful:  file nmpar.mat needs to be in the current directory  !!!
  %  Then all parameter matrices are in current directory
  load nmpar.mat
  
  %  Loop through distributions
  idiste = 16 ;
  for idist = 1:idiste ;
    eval(['parmat = nmpar' num2str(idist) ' ;']) ;
    eval(['titstr = nmtit' num2str(idist) ' ;']) ;
    disp(['    Working on #' num2str(idist) titstr]) ;

    for inobs = 2:4 ;
      nobs = 10^inobs ;
      disp(['      Working on n = ' num2str(nobs)]) ;

      %  Generate psuedo data and do family plot 
      data = nmdata(nobs,parmat) ;
      gpfam(data) ;
      title(['#' num2str(idist) ' ' titstr ', n = ' num2str(nobs)]) ;

      disp('Any key to continue') ;
      pause

    end ;

  end ;

elseif itest == 11 ;    %  then do small regression test

  indat = rand(500,1) .^ 2 ;
  indat = [indat, (indat - .4).^4 + .01 * randn(500,1)] ;

  clf ;
  gpfam(indat) ;
    title('Simple regression example') ;

  disp('Hit any key to overlay scatterplot') ;
  pause ;
  hold on ;
    plot(indat(:,1),indat(:,2),'.b') ;
  hold off

elseif itest == 12 ;    %  then do real data regression

  idat = 0 ;     %  0 - to loop through all
                 %  1 - Canadian Earning Data
                 %  2 - Canadian Lynx Data
                 %  3 - Cars Data
                 %  4 - Motorcycle Data
                 %  5 - NIcFoo Data
                 %  6 - Swamp Data
                 %  7 - Sunspot Data
                 %  8 - Fossil Data
                 %  9 - Share Yield Data

  if idat == 0 ;
    idats = 1 ;
    idate = 7 ;
  else ;
    idats = idat ;
    idate = idat ;
  end ;

  for iidat = idats:idate ;

    clf ;
    if iidat == 1 ;
      dtitstr = 'Earning Power' ;
           %  Data from Aman Ullah, from Canadian survey of 
           %  earning power as a function of age.  
           %  Used in Chu and Marron Stat. Sci. paper.
      infstr = 'canearn.dat' ;
      frmtstr = '%g %g' ;
      insize = [2, inf] ;
      vicol = [1, 2] ;
      datatran = [] ;
      xstr = 'Age' ;
      ystr = 'Income' ;
    elseif iidat == 2 ;
      dtitstr = 'Canadian Lynx' ;
           %  Famous time series data, from lynx trappings
      infstr = 'canlynx.dat' ;
      frmtstr = '%g' ;
      insize = [1,inf] ;
      vicol = [1] ;
      datatran = 'data(:,2) = log10(data(:,2) + 1) ;' ;
      xstr = 'Year' ;
      ystr = 'log10(# Lynx trapped + 1)' ;
    elseif iidat == 3 ;
      dtitstr = 'Cars' ;
           %  Subset of famous cars data, found by Mat Wand as
           %  good example of need for monotonic smoothing
      infstr = 'cars.mat' ;
      frmtstr = '%g %g' ;
      insize = [2, inf] ;
      vicol = [1, 2] ;
      datatran = [] ;
      xstr = 'Displacement' ;
      ystr = 'Mileage' ;
    elseif iidat == 4 ;
      dtitstr = 'Motorcycle' ;
           %  Full version of Haerdle's motorcycle crash data
      infstr = 'motodata.txt' ;
      frmtstr = '%g %g %s' ;
      insize = [5, inf] ;
      vicol = [1, 2] ;
      datatran = 'data = data(1:800,:) ;' ;
         %  First 800 are first trace
      xstr = 'Time' ;
      ystr = 'Acceleration' ;
    elseif iidat == 5 ;
      dtitstr = 'Food Expenditures' ;
      infstr = 'nicfoo.dat' ;
      frmtstr = '%g %g' ;
      insize = [2, inf] ;
      vicol = [1, 2] ;
      datatran = [] ;
      xstr = 'Net Income' ;
      ystr = 'Exp. for Food' ;
    elseif iidat == 6 ;
      dtitstr = 'Swamp Phosphorus' ;
      infstr = 's7xform.sho' ;
      frmtstr = '%g %g' ;
      insize = [2, inf] ;
      vicol = [1, 2] ;
%above lines are for data with "big gap", 
%which causes problem for hrsw
%following is alternate version, without this problem
%(but uninteresting data)
%      infstr = 's7ts.dat' ;
%      frmtstr = '%g %g %g %g %g %g' ;
%      insize = [6, inf] ;
%      vicol = [4, 5] ;
      datatran = 'data(:,2) = log10(data(:,2)) ;' ;
      xstr = 'Day' ;
      ystr = 'log10(Phosphorus Conc.)' ;
    elseif iidat == 7 ;
      dtitstr = 'Sunspots' ;
      infstr = 'sunspot.dat' ;
      frmtstr = '%g' ;
      insize = [1, inf] ;
      vicol = [1] ;
      datatran = 'data(:,2) = sqrt(data(:,2)) ;' ;
      xstr = 'Year' ;
      ystr = 'sqrt(# Sunspots)' ;
    elseif iidat == 8 ;
      dtitstr = 'Fossils' ;
      %  from Tim Bralower
      infstr = 'fossils.dat' ;
      frmtstr = '%g %g %g' ;
      insize = [3, inf] ;
      vicol = [1, 2] ;
      datatran = [] ;
      xstr = 'Age (mil. years)' ;
      ystr = 'Strontium Ratio' ;
    elseif iidat == 9 ;
      dtitstr = 'Share Yield' ;
      %  from Probal Chaudhuri
      %  Index of Stock Profits on "ordinary shares", Indian Stock Market
      %  on scale of "interest rates"
      %  from Reserve Bank of India Bulletin
      %  time series of monthly data, April 1982 - March 1991
      infstr = 'sharyiel.dat' ;
      frmtstr = '%g' ;
      insize = [1, inf] ;
      vicol = [1] ;
      datatran = [] ;
      xstr = 'month' ;
      ystr = 'Share yield' ;
    end ;


    disp(['    Loading ' dtitstr ' Data']) ;
      infstr = ['\gauss\steve\data\' infstr] ;
      fid = fopen(infstr,'r') ;
        data = fscanf(fid,frmtstr,insize) ;
        data = data' ;
          %  since data rows are read in as columns
        data = data(:,vicol) ;
        if size(data,2) == 1 ;  %  then have only one column
                                %  so add dummy column for x's
          data = [(1:length(data))', data] ;
        end ;
      fclose(fid) ;
    disp(['    Read in ' num2str(size(data,1)) ' data points']) ;


    if length(datatran) ~= 0 ;    %  Then do some data transformation
      eval(datatran) ;
    end ;

    gpfam(data) ;
      title(dtitstr) ;
      xlabel(xstr) ;
      ylabel(ystr) ;

      disp('  Hit any key to overlay scatterplot') ;
      pause ;
      hold on ;
        plot(data(:,1),data(:,2),'.b') ;
      hold off ;

    disp(['Any key to continue']) ;
    pause ;

  end ;

elseif itest == 13 ;    %  then do NR Book regression examples

  iset = 0 ;    %  0 - Loop through all
                %  1 - Range of Noise Levels
                %  2 - Shifting Design Points
                %  3 - Heteroscedasticity
                %  4 - (Not ready yet)
                %  5 - 2 extreme data sets


  if iset == 1 | iset == 0 ;
    disp('Running example 1') ;

    fid = fopen('\gauss\steve\nrbook\nrdat1.dat','r') ;
      data = fscanf(fid,'%g %g %g %g %g %g %g %g',[8, inf]) ;
      data = data' ;
          %  since data rows are read in as columns
    fclose(fid) ;

    clf ;
    for ieg = 1:6 ;
      disp(['        Working on part ' num2str(ieg)]) ;
      subplot(2,3,ieg) ;
        gpfam([data(:,1), data(:,ieg+2)]) ;
          title('NR Book e.g. 1') ;
          hold on ;
            plot(data(:,1),data(:,ieg+2),'.w') ;
            plot(data(:,1),data(:,2),'--b') ;
          hold off ;
    end ;

    disp('Any key to continue') ;
    pause ;
  end ;


  if iset == 2 | iset == 0 ;
    disp('Running example 2') ;

    fid = fopen('\gauss\steve\nrbook\nrdat2.dat','r') ;
      data = fscanf(fid,'%g %g %g %g %g %g %g %g',[8, inf]) ;
      data = data' ;
          %  since data rows are read in as columns
    fclose(fid) ;

    clf ;
    for ieg = 1:6 ;
      disp(['        Working on part ' num2str(ieg)]) ;
      subplot(2,3,ieg) ;
        gpfam([data(:,ieg), data(:,8)]) ;
          title('NR Book e.g. 2') ;
          hold on ;
            plot(data(:,ieg),data(:,8),'.w') ;
            plot(data(:,ieg),data(:,7),'--b') ;
          hold off ;
    end ;

    disp('Any key to continue') ;
    pause ;
  end ;

  if iset == 3 | iset == 0 ;
    disp('Running example 3') ;

    fid = fopen('\gauss\steve\nrbook\nrdat3.dat','r') ;
      data = fscanf(fid,'%g %g %g %g %g %g %g',[7, inf]) ;
      data = data' ;
          %  since data rows are read in as columns
    fclose(fid) ;

    clf ;
    for ieg = 1:5 ;
      disp(['        Working on part ' num2str(ieg)]) ;
      subplot(2,3,ieg) ;
        gpfam([data(:,1), data(:,ieg+2)]) ;
          title('NR Book e.g. 3') ;
          hold on ;
            plot(data(:,1),data(:,ieg+2),'.w') ;
            plot(data(:,1),data(:,2),'--b') ;
          hold off ;
    end ;

    disp('Any key to continue') ;
    pause ;
  end ;

  if iset == 4 | iset == 0 ;
    disp('Example 4 was not finished') ;
  end ;

  if iset == 5 | iset == 0 ;
    disp('Running example 5') ;

    fid = fopen('\gauss\steve\nrbook\nrdat5a.dat','r') ;
      data = fscanf(fid,'%g %g %g',[3, inf]) ;
      data = data' ;
          %  since data rows are read in as columns
    fclose(fid) ;

    clf ;
    gpfam([data(:,1), data(:,3)]) ;
      title('NR Book, e.g. 5a') ;
          hold on ;
            plot(data(:,1),data(:,3),'.w') ;
            plot(data(:,1),data(:,2),'--b') ;
          hold off ;
    disp('Any key to continue') ;
    pause ;

    fid = fopen('\gauss\steve\nrbook\nrdat5b.dat','r') ;
      data = fscanf(fid,'%g %g %g',[3, inf]) ;
      data = data' ;
          %  since data rows are read in as columns
    fclose(fid) ;

    clf ;
    gpfam([data(:,1), data(:,3)]) ;
      title('NR Book, e.g. 5b') ;
          hold on ;
            plot(data(:,1),data(:,3),'.w') ;
            plot(data(:,1),data(:,2),'--b') ;
          hold off ;

  end ;

elseif itest == 14 ;    %  then do B-spline regression examples 

  clf
  for ifile = 1:9 ;
    disp(['        Working on part ' num2str(ifile)]) ;

    infstr = ['\gauss\steve\bspline\bs3' num2str(ifile) '.dat'] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,'%g %g %g',[3, inf]) ;
      data = data' ;
          %  since data rows are read in as columns
    fclose(fid) ;

    subplot(3,3,ifile) ;
      gpfam([data(:,1), data(:,3)]) ;
        title('B-spline Targets') ;
        hold on ;
          plot(data(:,1),data(:,3),'.w') ;
          plot(data(:,1),data(:,2),'--b') ;
        hold off ;
        axis([0,1,0,1]) ;
          %  Comment this last out to see all of data
  end ;

elseif itest == 15 ;    %  then do ER wavelet regression examples 

  clf ;
  nobs = 1024 ;
  xgrid = linspace(1/(2*nobs), 1 - (1/(2*nobs)), nobs)' ;

  for idist = 1:10 ;

    %  Following lines are modifications of Sudeshna Adak's Gen_sign.m
    if idist == 1 ;
      tarstr = 'Step' ;
      m = 0.2 + 0.6*(xgrid > 1/3 & xgrid <= 0.75); 
    elseif idist == 2 ;
      tarstr = 'Wave' ;
      m = 0.5 + (0.2.*cos(4*pi*xgrid)) + (0.1.*cos(24*pi*xgrid));
    elseif idist == 3 ;
      tarstr = 'Blip' ;
       m = (0.32 + (0.6.*xgrid) + ...
                      0.3*exp(-100*((xgrid-0.3).^2))).*(xgrid <= 0.8) + ...
           (-0.28 + (0.6.*xgrid) + ... 
                      0.3*exp(-100*((xgrid-1.3).^2))).*(xgrid > 0.8);
    elseif idist == 4 ;
      tarstr = 'Blocks' ;
      pos = [ .1 .13 .15 .23 .25 .40 .44 .65  .76 .78 .81];
      hgt = [4 (-5) 3 (-4) 5 (-4.2) 2.1 4.3  (-3.1) 2.1 (-4.2)];
      m = 2*ones(size(xgrid));
      for j=1:length(pos)
        m = m + (1 + sign(xgrid-pos(j))).*(hgt(j)/2) ;
      end
      m = (0.6/9.2)*m + 0.2;
    elseif idist == 5 ;
      tarstr = 'Bumps' ;
      pos = [ .1 .13 .15 .23 .25 .40 .44 .65  .76 .78 .81];
      hgt = [ 4  5   3   4  5  4.2 2.1 4.3  3.1 5.1 4.2];
      wth = [.005 .005 .006 .01 .01 .03 .01 .01  .005 .008 .005];
      m = zeros(size(xgrid));
      for j =1:length(pos)
        m = m + hgt(j)./( 1 + abs((xgrid - pos(j))./wth(j))).^4;
      end 
      m = ((0.6/5.3437952)*m) + 0.2;
    elseif idist == 6 ;
      tarstr = 'HeaviSine' ;
      m = 4.*sin(4*pi.*xgrid) - sign(xgrid - .3) - sign(.72 - xgrid) + 5;
      m = (0.6/9)*m + 0.2;
    elseif idist == 7 ;
      tarstr = 'Doppler' ;
      m = sqrt(xgrid.*(1-xgrid)).*sin((2*pi*1.05) ./(xgrid+.05)) + 0.5;
      m = 0.6*m + 0.2;
    elseif idist == 8 ;
      tarstr = 'Angles' ;
      m = ((2*xgrid + 0.5).*(xgrid <= 0.15)) + ...
        ((-12*(xgrid-0.15) + 0.8).*(xgrid > 0.15 & xgrid <= 0.2)) + ...
        0.2*(xgrid > 0.2 & xgrid <= 0.5) + ...
        ((6*(xgrid - 0.5) + 0.2).*(xgrid > 0.5 & xgrid <= 0.6)) + ...
        ((-10*(xgrid - 0.6) + 0.8).*(xgrid > 0.6 & xgrid <= 0.65)) + ...
        ((-0.5*(xgrid - 0.65) + 0.3).*(xgrid > 0.65 & xgrid <= 0.85)) + ...
        ((2*(xgrid - 0.85) + 0.2).*(xgrid > 0.85));
    elseif idist == 9 ;
      tarstr = 'Parabolas' ;
      pos = [0.1 0.2 0.3 0.35 0.37 0.41 0.43 0.5 0.7 0.9];
      hgt = [(-30) 60 (-30) 500 (-1000) 1000 (-500) 7.5 (-15) 7.5];
      m = zeros(size(xgrid));
      for j =1:length(pos)
        m = m + hgt(j).*((xgrid-pos(j)).^2).*(xgrid > pos(j));
      end
      m = m + 0.8;
    elseif idist == 10 ;
      tarstr = 'Time Shifted Sine' ;
      u = xgrid;
      for j =1:4,
        u = 0.5*(1-cos(pi*u));
      end
      m = 0.3*sin(3*pi*(u+xgrid)) + 0.5;
    end ;

    for isig = 1:2 ;

      if isig == 1 ;
        sigstr = 'Low Noise' ;
        sig = .02 ;
      elseif isig == 2 ;
        sigstr = 'High Noise' ;
        sig = .1 ;
      end ;

        randn('seed',92394873) ;
      ydat = m + sig * randn(nobs,1) ;
      data = [xgrid, ydat] ; 

      gpfam(data) ;
      hold on ;     
        plot(xgrid,m,'--r',xgrid,ydat,'.b') ;
          title([tarstr ', ' sigstr]) ;
          axis([0,1,0,1]) ;
      hold off ;     

      disp('    Any key to continue') ;
      pause ;

    end ;

  end ; 

elseif itest == 16 ;   %  twiddle number of family members
  indat = [randn(300,1); .25 * randn(100,1) + 2] ;

  subplot(2,2,1) ;
    gpfam(indat,0,0,9) ;

  subplot(2,2,2) ;
    gpfam(indat) ;

  subplot(2,2,3) ;
    gpfam(indat,0,0,21) ;

  subplot(2,2,4) ;
    gpfam(indat,0,0,31) ;

end ;

