disp('Running MATLAB script file gppgramt.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION gppgram,
%    General Purpose PeriodoGRAM

itest = 11 ;     %   1,2,3,4,5,6,7,8,9,1

format compact ;



if itest == 1 ;    


  n = 200 ;
  xgrid = (1:n)' ;
  y = sin(2*pi*3*xgrid/n) ;
  y = y + .1 * randn(n,1) ;

  gppgram(y) ;


elseif itest == 2 ;

  ip = 2 ;    %  0,1,2

  n = 20 ;
  xgrid = (1:n)' ;
  y = sin(2*pi*3*xgrid/n) ;
  y = y + .1 * randn(n,1) ;

  gppgram(y,ip) 

elseif itest == 3 ;

  itr = 1 ;      % 0, 0.25, 1

  n = 200 ;
  xgrid = (1:n)' ;
  y = sin(2*pi*3*xgrid/n) ;
  y = y + .1 * randn(n,1) ;

  gppgram(y,1,itr) ;


elseif itest == 4 ;

  r = [20, 40] ;

  n = 200 ;
  xgrid = (1:n)' ;
  y = sin(2*pi*30*xgrid/n) ;
  y = y + .1 * randn(n,1) ;

  gppgram(y,1,1/4,r) ;


elseif itest == 5 ;

  vn = [255; 256; 1023; 1024; 4095; 4096; 16383; 16384; 65535; 65536] ;

  vt = [] ;
  for i = 1:length(vn) ;

    n = vn(i) ;
    y = randn(n,1) ;

    disp(['Time for ' num2str(n)]) ;
    tic ;
      temp = gppgram(y,0) ;
    t = toc

    vt = [vt; t] ;

  end ;

  figure ;
  
  plot(log(vn)./log(2), log10(vt)) ;
    xlabel('log2(n)') ;
    ylabel('log10(time)') ;


elseif itest == 6 ;

  disp('Loading sunspot data') ;
    infstr = 'sunspot.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\gauss\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  gppgram(sqrt(data)) ;


elseif itest == 7 ;

  disp('Loading Canadian Lynx data') ;
    infstr = 'canlynx.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\gauss\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  gppgram(log10(data)) ;


elseif itest == 8 ;

  disp('Loading Airline Passenger Data') ;
    infstr = 'airpass.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\matlab\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  data = log10(data) ;

  data = data - gppolyf([(1:length(data))',data],1,0) ;
          %  subtract linear fit (no pic)

  gppgram(data,1,0,[2,20]) ;


elseif itest == 9 ;

  data = cos(2 * pi * 30.5 * (1:200)' / 200) ;
  data = data + cos(2 * pi * 31 * (1:200)' / 200) ;
  data = data + cos(2 * pi * 31.5 * (1:200)' / 200) ;

  gppgram(data) ;



elseif itest == 10 ;

  data = vec2mat((1:15)', 10) ;
  data = reshape(data,size(data,1)*size(data,2),1) ;
          %  makes a "saw tooth" function

  gppgram(data) ;



elseif itest == 11 ;

  data = vec2mat([(1:10)'; (3*ones(5,1))], 10) ;
  data = reshape(data,size(data,1)*size(data,2),1) ;
          %  makes an "irregular periodic" function

  gppgram(data) ;



end ;



