disp('Running MATLAB script file gppolyft.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION gppolyf,
%    General Purpose Polynomial Fitting

itest = 4 ;     %   1,2,3,4

format compact ;



if itest == 1 ;    

  p = 3 ;       %  0, 1, 2, 3

  mdata = (0:.2:2)' ;
  mdata = [mdata, exp(mdata)+ 0.1 * randn(length(mdata),1)] ; 

  gppolyf(mdata,p) ;


elseif itest == 2 ;

 ip = 2 ;    %  0,1,2

  mdata = (0:.2:2)' ;
  mdata = [mdata, exp(mdata)+ 0.1 * randn(length(mdata),1)] ; 

  gppolyf(mdata,1,ip) 


elseif itest == 3 ;

  p = 5 ;     %  0,1,2,3,4,5

  n = 300 ;
  xgrid = (1:n)' ;
  y = sin(2*pi*xgrid/n) ;
  y = y + .1 * randn(n,1) ;

  gppolyf([xgrid,y],p) ;


elseif itest == 4 ;

  p = 3 ;     %  0,1,2,3

  disp('Loading Airline Passenger Data') ;
    infstr = 'airpass.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\matlab\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;
  
  n = length(data) ;

  gppolyf([(1:n)',data],p) ;



end ;



