disp('Running MATLAB script file gptrigft.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION gptrigf,
%    General Purpose Trigonometric Fitting

itest = 7 ;     %   1,2,3,4,5,6,7

format compact ;



if itest == 1 ;    

  fr = 2.5 ;    %  1, 1.1, 1.3, 1.6, 2, 2.5

  n = 200 ;
  xgrid = (1:n)' ;
  y = sin(2*pi*xgrid/n) ;
  y = y + .1 * randn(n,1) ;

  gptrigf(y,fr) ;


elseif itest == 2 ;

 ip = 2 ;    %  0,1,2

  n = 40 ;
  xgrid = (1:n)' ;
  y = sin(2*pi*xgrid/n) ;
  y = y + .1 * randn(n,1) ;

  gptrigf(y,1.3,ip) 


elseif itest == 3 ;

  fr = 2/3 ;     %  1, 1/3, 2/3

  x = ((1:3:101)') / 33 ;
  y = (x < 1.5) ;

  gptrigf([x,y],fr) ;


elseif itest == 4 ;

  fr = 20 ;    %  1, 5, 10, 20

  y = (1:5)' ;
  y = kron(ones(10,1),y) ;

  gptrigf(y,fr) ;


elseif itest == 5 ;

  disp('Loading sunspot data') ;
    infstr = 'sunspot.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\gauss\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  fr = 21.3 ;    %  21, 22, 21.3

  gptrigf(sqrt(data),fr) ;


elseif itest == 6 ;

  disp('Loading Canadian Lynx data') ;
    infstr = 'canlynx.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\gauss\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  fr = 11.8 ;    %  12,13,12.2,11.8

  gptrigf(log10(data),fr) ;


elseif itest == 7 ;


  disp('Loading Airline Passenger Data') ;
    infstr = 'airpass.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\matlab\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  data = log10(data) ;

  data = data - gppolyf([(1:length(data))',data],1,0) ;
          %  subtract linear fit (no pic)

  fr = 12 ;    %  12

  gptrigf(data,fr) ;


end ;



