disp('Running MATLAB script file gpve1t.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION gpve1,
%    General Purpose Visual Error Criterion

itest = 4 ;     %   1,2,3,4

format compact ;

if itest == 1 ;     %  crude test for debugging
  xin = (1:10)' ;
  v1in = 2 * xin ;
  v2in = 2 * xin + .1 ;
  isc = 0 ;     %  tried 0 and 2
  ino = 3 ;     %  tried 1,2,3,0
  out = gpve1(xin,v1in,v2in,isc,0,ino) 
  
elseif itest == 2 ;     %  look at an interesting example
  xin = linspace(0,1,100)' ;
  v1in = 16 * (xin - .5).^2 ;
  v2in = 2 + sin(8 * pi * xin) ;
  subplot(2,2,1) ;
    [out,lineind] = gpve1(xin,v1in,v2in) ;
    plot(xin,[v1in, v2in],[xin,xin(lineind)]',[v1in,v2in(lineind)]') ;
  subplot(2,2,2) ;
    [out,lineind] = gpve1(xin,v2in,v1in) ;
    plot(xin,[v2in, v1in],[xin,xin(lineind)]',[v2in,v1in(lineind)]') ;
  subplot(2,2,3) ;
    [out,lineind] = gpve1(xin,v1in,v2in,0) ;
    plot(xin,[v1in, v2in],[xin,xin(lineind)]',[v1in,v2in(lineind)]') ;
  subplot(2,2,4) ;
    [out,lineind] = gpve1(xin,v2in,v1in,0) ;
    plot(xin,[v2in, v1in],[xin,xin(lineind)]',[v2in,v1in(lineind)]') ;

elseif itest == 3 ;     %  look at a step function example
  xin = linspace(0,1,100)' ;
  v1in = 50 * ones(100,1) ;
  v1in(11:30) = 30 * ones(20,1) ;
  v1in(71:90) = 90 * ones(20,1) ;
  xin = linspace(0,1,100)' ;
  v2in = 55 * ones(100,1) ;
  v2in(8:39) = 40 * ones(32,1) ;
  v2in(72:95) = 80 * ones(24,1) ;
  subplot(2,2,1) ;
    [out,lineind] = gpve1(xin,v1in,v2in) ;
    plot(xin,[v1in, v2in],[xin,xin(lineind)]',[v1in,v2in(lineind)]') ;
  subplot(2,2,2) ;
    [out,lineind] = gpve1(xin,v2in,v1in) ;
    plot(xin,[v2in, v1in],[xin,xin(lineind)]',[v2in,v1in(lineind)]') ;
  subplot(2,2,3) ;
    [out,lineind] = gpve1(xin,v1in,v2in,1) ;
    plot(xin,[v1in, v2in],[xin,xin(lineind)]',[v1in,v2in(lineind)]') ;
  subplot(2,2,4) ;
    [out,lineind] = gpve1(xin,v2in,v1in,1) ;
    plot(xin,[v2in, v1in],[xin,xin(lineind)]',[v2in,v1in(lineind)]') ;

elseif itest == 4 ; 
  xin = linspace(0,2,401)' ;
  v1in = 4 * exp(-(xin - .5).^2 / .01) ;
  v2in = 4 * exp(-(xin - .51).^2 / .01) ;
  disp('Time for direct matrix:') ;
  isc = 2 ;     %  tried 0,1,2
  isy = 1 ;     %  tried 0,1
  tic ;
    out1 = gpve1(xin,v1in,v2in,isc,isy,0,0)  ;
          %  direct matrix version
  toc ;
  disp('Time for slow loop:') ;
  tic ;
    out2 = gpve1(xin,v1in,v2in,isc,isy,0,1) ;
          %  slower loop version
  toc ;

  disp('Distances were:') ;
    out1

  disp('Error between 2 versions was:')
    error = abs(out1 - out2) 

elseif itest == 5 ; 
%  xgrid = linspace(0,10,401)' ;
%  gpve1(xgrid,v1,v2,iscale,isymm,inorm,iloop) 
end ;
