disp('Running MATLAB script file gpvpert.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION gpvper.m,
%    General Purpose Visualization of Periodicities

itest = 17 ;     %   1,...,17

format compact ;



if itest == 1 ;    

  y = [3; 4; 5; 1; 2; 3; 3] ;
  y = kron(ones(10,1),y) ;

  gpvper(y) ;


elseif itest == 2 ;

  r = 18 ;   %  [1,40], [1,20], [10,20], [17,19], [18,18], 18

  y = [3; 4; 5; 1; 2; 3; 3] ;
  y = kron(ones(10,1),y) ;

  gpvper(y,0,r) ;


elseif itest == 3 ;

  disp('Loading sunspot data') ;
    infstr = 'sunspot.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\gauss\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  vl = 0 ;      %  0, 11, [10,11], [10,11,12], 
                    %  [10,11,12,21], [20,21,22], [20,21,22,23,24]
                    %  [20,22,0; 21,23,24]
  r = [10.8, 11, 11.2] ;
                 %    [1,30], [5,15], [1,50], 11, 10, 10.5, 10.8, 
                 %       10.9, 10.99, [10.8, 10.9, 10.99, 11.01, 11.1]
                 %       [11.01, 11.1, 11.2, 11.3], [10,10.5,11]
                 %       [10.8,11,11.2]
  imode = 2 ;    %    1, 2

%  gpvper(data) ;
  gpvper(data,vl,r,imode) ;



elseif itest == 4 ;

  disp('Loading Canadian Lynx data') ;
    infstr = 'canlynx.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\gauss\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  vl = 0 ;      %  0, 10, [10,0; 9,11], 19, [19,0; 18,20],
                   %  38, [37,38,39], [38,0; 37,39]
  r = [9.5, 9.6, 9.7] ;     %    [1,55], [5,15], 10, 9, 9.5, [9, 9,5, 10]
                   %  [9.5, 9.6, 9.7]
  imode = 2 ;      %    1, 2

%  gpvper(data,vl,r) ;
  gpvper(data,vl,r,imode) ;


elseif itest == 5 ;

  disp('Loading Airline Passenger Data') ;
    infstr = 'airpass.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\matlab\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  vl = [12, 13, 14] ;       %  0, 12, [12; 13], [12,13,14]
  r = [1,30] ;     %    [1,30], [5,15]

  gpvper(data,vl,r) ;


elseif itest == 6 ;

  disp('Loading Airline Passenger Data') ;
    infstr = 'airpass.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\matlab\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  data = data - gppolyf([(1:length(data))',data],1,0) ;
          %  subtract linear fit (no pic)

  vl = [12, 13, 14] ;      %  0, 6, [6; 12], [12, 13, 14]
  r = [1,30] ;     %    [1,30], [5,15]

  gpvper(data,vl,r) ;





elseif itest == 7 ;

  disp('Loading Airline Passenger Data') ;
    infstr = 'airpass.dat' ;
    frmtstr = '%g' ;
    insize = [1, inf] ;
    vicol = [1] ;
    infstr = ['\matlab\steve\data\' infstr] ;
    fid = fopen(infstr,'r') ;
      data = fscanf(fid,frmtstr,insize) ;
      data = data' ;
        %  since data rows are read in as columns
      data = data(:,vicol) ;
    fclose(fid) ;
  disp(['    Read in ' num2str(size(data,1)) ' data points']) ;

  data = log10(data) ;

  data = data - gppolyf([(1:length(data))',data],1,0) ;
          %  subtract linear fit (no pic)

  vl = 0 ;     %  0, [6; 12], 12
  r = 12 ;     %    [1,30], [3,15], [5,7], 12, 11, 13
  imode = 2 ;    %    1, 2

  gpvper(data,vl,r,imode) ;



elseif itest == 8 ;

  seed = 57875777 ;
  randn('seed',seed) ;
  data = randn(200,1) ;

  vl = (5:12) ;    %  0, (5:12)

  gpvper(data,vl) ;


elseif itest == 9 ;

  data = cos(2 * pi * 30.5 * (1:200)' / 200) ;

  vl = 0 ;     %  0, 13, [13; 20], [13,0; 19,20]
  r = [6.5, 6.55, 6.6] ;    %  [1,30], [1,40], 13, [6, 6.5, 7],
               %   [6.5, 6.6, 6.7], [6.5, 6.55, 6.6]
  imode = 2 ;    %    1, 2

  gpvper(data,vl,r,imode) ;


elseif itest == 10 ;

  txgrid = (1 - cos(pi .* (1:200)' / 200) / 2) ;
  data = cos(2 * pi * 30.5 * txgrid) ;

  vl = 0 ;     %  0,13,(9:13)
  r = [9,10,11] ;   %  [1,30],11,[10,11,12],[9,10,11]
  imode = 2 ;    %    1, 2

  gpvper(data,vl,r,imode) ;


elseif itest == 11 ;

  data = cos(2 * pi * 30.5 * (1:200)' / 200) ;
  data = data + cos(2 * pi * 31 * (1:200)' / 200) ;
  data = data + cos(2 * pi * 31.5 * (1:200)' / 200) ;

  vl = 0 ;   %  0, 19, [19,13], [19,20; 13,0], [13,0; 19,20]
  r = [6.3,6.4,6.5] ;  %  [1,50],13,19,6,7,6.5,6.4,6.45
                   %  [6,6.5,7] [6.3,6.4,6.5]
  imode = 2 ;    %    1, 2

  gpvper(data,vl,r,imode) ;


elseif itest == 12 ;

  data = vec2mat((1:15)', 10) ;
  data = reshape(data,size(data,1)*size(data,2),1) ;
          %  makes a "saw tooth" function

  vl = [5, 3] ;    %  0, 10, [10; 3], [5, 3]
  r = 15 ;    %  [1,20], 15
  imode = 2 ;    %    1, 2

  gpvper(data,vl,r,imode) ;


elseif itest == 13 ;

  data = vec2mat([(1:10)'; (3*ones(5,1))], 10) ;
  data = reshape(data,size(data,1)*size(data,2),1) ;
          %  makes an "irregular periodic" function

  vl = 5 ;    %  0, 5
  r = [1,20];

  gpvper(data,vl,r) ;


elseif itest == 14 ;

  data1 = vec2mat((1:10)', 24) ;
  data1 = reshape(data1,size(data1,1)*size(data1,2),1) ;
          %  makes an "irregular periodic" function

  data2 = vec2mat((6:(-1):1)', 40) ;
  data2 = reshape(data2,size(data2,1)*size(data2,2),1) ;
          %  makes an "irregular periodic" function

  data = data1 + data2 ;

  vl = [5,6] ;    %  0, 3, 6, [5,6]
  r = [1,40] ;

  gpvper(data,vl,r) ;


elseif itest == 15 ;

  data = vec2mat([1;0;0;0;0;1;0;0;0;1;0;0;1;0], 10) ;
  data = reshape(data,size(data,1)*size(data,2),1) ;
          %  makes an "irregular periodic" function

  vl = 7 ;    %  0, 7
  r = [1,30];

  gpvper(data,vl,r) ;


elseif itest == 16 ;

  txgrid = pi .* (1:200)' / 200 ;
  data = cos(2 * pi * 30.5 * txgrid) ;

  vl = 0 ;     %  0,23,[21,23,25],(21:25)
  r = [23, 24, 25] ;   %  [1,40], 23, [23,24,25]
  imode = 2 ;    %    1, 2

  gpvper(data,vl,r,imode) ;


elseif itest == 17 ;

  n = 200 ;
  xgrid = (1:n)' / n ;
  seed = 43987493 ;
  rand('seed',seed) ;
  txgrid = gpkde(rand(10,1),.15,[1/n;1;n]) ;
%  figure ;
%    subplot(2,1,1) ;
%      plot(xgrid,txgrid) ;
  txgrid = cumsum(txgrid) ;
  txgrid = txgrid / txgrid(n) ;
%    subplot(2,1,2) ;
%      plot(xgrid,txgrid) ;
%  gppause ;
  data = cos(2 * pi * 20 * txgrid) ;

  vl = 0 ;     %  0, 9, [9; 11], 9:11, 8:12,
                  %     18, [18,22], 18:22, [18,22,25], 18:25
  r = [9,10,11] ;  %  [1,30], 9, [9,10,11]
  imode = 2 ;    %    1, 2

  gpvper(data,vl,r,imode) ;


end ;



