disp('Running MATLAB script file sss2t.m') ;
%
%    FOR DEVELOPMENT AND TESTING OF MATLAB FUNCTION sss2,
%    Use friendly version of Significance in Scale Space



itest = 139 ;      %  1 - standard examples from sizer/2d
                 %  2 - test out variety of variances
                 %  3 - test out other options
                 %  3.5 - extension of 3 for global variable part
                 %  4 - investigate different alphas
                 %  5 - test different image sizes
                 %  6 - test movies
                 %  7 - test sliders
                 %  8 - test streamlines (different sample sizes)
                 %  9 - test streamlines (different targets and noises)
                 %  10 - test 0 signal case
                 %  11 - test single line case
                 %  12 - test m ~= n, and also m or n odd
                 %  13 - test 0 signal, different alphas
                 %  > 100 but < 200, various parameter tests
                 %  > 200, some special tests


if itest == 1 ;     %  some standard tests

  idecim = 1 ;     %  0 - use given 64 x 64 image
                   %  1 - decimate to 32 x 32 to increase speed

  ieg = 2 ;    %   0  -  loop through all
               %   1  -  parallel peaks
               %   2  -  peaks and valleys
               %   3  -  sombrero
               %   4  -  volcano
               %   5  -  piecewise linear

  inoise = 2 ;    %  0  -  loop through all
                  %  1  -  low noise
                  %  2  -  medium noise
                  %  3  -  high noise




  %  set looping parameters
  %
  if ieg == 0 ;
    ies = 1 ;
    iee = 5 ;
  else ;
    ies = ieg ;
    iee = ieg ;
  end ;

  if inoise == 0 ;
    ins = 1 ;
    ine = 3 ;
  else ;
    ins = inoise ;
    ine = inoise ;
  end ;




  %  Main loop
  %
  for ie = ies:iee ;


    %  Loop through noise levels
    %
    for in = ins:ine ;

      eval(['load \matlab\steve\sss\data\sss1d' num2str(ie) ...
                                num2str(in) ';']) ;
          % this loads the variables: xgridygrid mdat sig titstr noistr

      figure(1) ;
      clf ;

      if idecim == 1 ;
        mdat = mdat(1:2:63,1:2:63) ;
           %  decimation of data (to keep run time short for testing)
      end ;

      sss2(mdat,[3,1],[1,(.064)^2]) ;
%                |:  1 - arrows only
%                |:  2 - dots only
%                |:  3 - dots and arrows
%                |:  4 - streamlines
%                  |:  1 - single pixels
%                  |:  2 - 2 x 2 boxes


      subplot(2,2,1) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',[titstr ', ' titlestr]) ;

      subplot(2,2,2) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',[noistr ', ' titlestr]) ;

      subplot(2,2,3) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',['SSS, ' titlestr]) ;

      subplot(2,2,4) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',[date ', ' titlestr]) ;


        orient landscape ;
      eval(['print -dpsc \matlab\steve\ps\sss1' num2str(ie) ...
                                num2str(in) '.ps ;']) ;



    end ;


  end ;


elseif itest == 2 ;     %  test different variances


  idecim = 0 ;     %  0 - use given 64 x 64 image
                   %  1 - decimate to 32 x 32 to increase speed

  ivar = 0 ;   %  0 - loop through all
               %  1 - known sig2
               %  2 - pooled sig2
               %  3 - local sig2

  itype = 0 ;   %  0 - loop through all
               %  1 - arrows only, single pixel
               %  2 - arrows only, 2 x 2 blocks
               %  3 - dots only, single pixel
               %  4 - dots only, 2 x 2 blocks
               %  5 - arrows and dots, single pixel
               %  6 - arrows and dots, 2 x 2 blocks
               %  7 - streamlines


  ieg = 2 ;    % 
               %   1  -  parallel peaks
               %   2  -  peaks and valleys
               %   3  -  sombrero
               %   4  -  volcano
               %   5  -  piecewise linear

  inoise = 1 ;    % 
                  %  1  -  low noise
                  %  2  -  medium noise
                  %  3  -  high noise




  %  set looping parameters
  %
  if ivar == 0 ;
    ivs = 1 ;
    ive = 3 ;
  else ;
    ivs = ivar ;
    ive = ivar ;
  end ;

  if itype == 0 ;
    its = 1 ;
    ite = 7 ;
  else ;
    its = itype ;
    ite = itype ;
  end ;


  %  load data
  %
  eval(['load \matlab\steve\sss\data\sss1d' num2str(ieg) ...
                                num2str(inoise) ';']) ;
          % this loads the variables: xgrid ygrid mdat sig titstr noistr

  if idecim == 1 ;
    mdat = mdat(1:2:63,1:2:63) ;
         %  decimation of data (to keep run time short for testing)
  end ;



  %  Main loop
  %
  for iv = ivs:ive ;

    if iv == 1 ;    %  known sig2
      varp = [0,sig^2] ;
      varstr = 'known sig2' ;
    elseif iv == 2 ;    %  pooled sig2
      varp = [1,0] ;
      varstr = 'pooled sig2' ;
    elseif iv == 3 ;    %  local sig2
      varp = [1,1] ;
      varstr = 'local sig2' ;
    end ;



    %  Loop through implementation types
    %
    for it = its:ite ;


      if it == 1 ;    %  1 - arrows only, single pixel
        type = [1,1] ;
      elseif it == 2 ;    %  2 - arrows only, 2 x 2 blocks
        type = [1,2] ;
      elseif it == 3 ;    %  3 - dots only, single pixel
        type = [2,1] ;
      elseif it == 4 ;    %  4 - dots only, 2 x 2 blocks
        type = [2,2] ;
      elseif it == 5 ;    %  5 - arrows and dots, single pixel
        type = [3,1] ;
      elseif it == 6 ;    %  6 - arrows and dots, 2 x 2 blocks
        type = [3,2] ;
      elseif it == 7 ;    %  7 - streamlines
        type = [4,0] ;
      end ;

    disp(['Working on ' varstr ', type ' num2str(type)]) ;


      figure(1) ;
      clf ;


      sss2(mdat,type,varp) ;


      subplot(2,2,1) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',[varstr ', ' titlestr]) ;

      subplot(2,2,2) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',[titstr ', ' noistr ', ' titlestr]) ;

      subplot(2,2,3) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',['SSS ' num2str(type(1)) ...
                                          num2str(type(2)) ', ' titlestr]) ;

      subplot(2,2,4) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',[date ', ' titlestr]) ;


        orient landscape ;
      eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) ...
                            num2str(iv) num2str(it) '.ps ;']) ;



    end ;


  end ;


elseif itest == 3 ;     %  test out other options


  idecim = 1 ;     %  0 - use given 64 x 64 image
                   %  1 - decimate to 32 x 32 to increase speed

  ieg = 2 ;    % 
               %   1  -  parallel peaks
               %   2  -  peaks and valleys
               %   3  -  sombrero
               %   4  -  volcano
               %   5  -  piecewise linear

  inoise = 1 ;    % 
                  %  1  -  low noise
                  %  2  -  medium noise
                  %  3  -  high noise

  %  load data
  %
  eval(['load \matlab\steve\sss\data\sss1d' num2str(ieg) ...
                                num2str(inoise) ';']) ;
          % this loads the variables: xgrid ygrid mdat sig titstr noistr

  if idecim == 1 ;
    mdat = mdat(1:2:63,1:2:63) ;
         %  decimation of data (to keep run time short for testing)
  end ;




  %  first test defaults
  sss2(mdat) ;
  gppause ;

  vitype = 0 
  sss2(mdat,vitype) ;
  gppause ;

  vitype = [0, 2, 2] 
  sss2(mdat,vitype) ;
  gppause ;

  vitype = [0, 2, 3] 
  sss2(mdat,vitype) ;
  gppause ;

  vitype = 1 
  sss2(mdat,vitype) ;
  gppause ;

  vitype = [1, 2] 
  sss2(mdat,vitype) ;
  gppause ;

  vitype = [1, 2, 1] 
  sss2(mdat,vitype) ;
  gppause ;

  vitype = [1, 2, 1, 0] 
  sss2(mdat,vitype) ;
  gppause ;

  vitype = [1, 2, 1, 0, 0] 
  sss2(mdat,vitype) ;
  gppause ;

  vitype = [1, 2, 1, 0, 1] 
  sss2(mdat,vitype) ;
  gppause ;

  vitype = [1, 2, 1, 0, 2] 
  sss2(mdat,vitype) ;
  gppause ;

  vitype = [1, 2, 1, 0, 0, 0] 
  sss2(mdat,vitype) ;
  gppause ;

  vitype = [1, 2, 1, 0, 0, 1] 
  sss2(mdat,vitype) ;
  gppause ;

  vitype = [1, 2, 1, 1] 
  varp = [1,0] 
  sss2(mdat,vitype,varp) ;
  gppause ;

  alpha = 0.05 
  sss2(mdat,vitype,varp,alpha) ;
  gppause ;

  alpha = 0.01 
  sss2(mdat,vitype,varp,alpha) ;
  gppause ;

  alpha = 0.20 
  sss2(mdat,vitype,varp,alpha) ;
  gppause ;

  alpha = 0.05 
  vhgp = 0 
  sss2(mdat,vitype,varp,alpha,vhgp) ;
  gppause ;

  vhgp = 3 
  sss2(mdat,vitype,varp,alpha,vhgp) ;
  gppause ;

  vhgp = [.25; 16] 
  sss2(mdat,vitype,varp,alpha,vhgp) ;
  gppause ;

  vhgp = [.25; 16; 5] 
  sss2(mdat,vitype,varp,alpha,vhgp) ;
  gppause ;

  vhgp = 0 
  vgp = 0 
  sss2(mdat,vitype,varp,alpha,vhgp,vgp) ;
  gppause ;

  bdryflag = 0
  sss2(mdat,vitype,varp,alpha,vhgp,vgp,bdryflag) ;
  gppause ;

elseif itest == 3.5 ;

  idecim = 1 ;     %  0 - use given 64 x 64 image
                   %  1 - decimate to 32 x 32 to increase speed

  ieg = 2 ;    % 
               %   1  -  parallel peaks
               %   2  -  peaks and valleys
               %   3  -  sombrero
               %   4  -  volcano
               %   5  -  piecewise linear

  inoise = 1 ;    % 
                  %  1  -  low noise
                  %  2  -  medium noise
                  %  3  -  high noise

  %  load data
  %
  eval(['load \matlab\steve\sss\data\sss1d' num2str(ieg) ...
                                num2str(inoise) ';']) ;
          % this loads the variables: xgrid ygrid mdat sig titstr noistr

  if idecim == 1 ;
%    mdat = mdat(1:2:63,1:2:63) ;
    mdat = mdat(1:4:63,1:4:63) ;
         %  decimation of data (to keep run time short for testing)
  end ;

  vitype = [1, 2, 1, 1] 
  varp = [1,0] 
  alpha = 0.05 
  vhgp = 0 
  vgp = 0 
  bdryflag = 0


  subplot(1,3,2) ;
  h = 2
  global GRAPHHAND A3DSLIMOV
  GRAPHHAND = gca 
  sss2(mdat,0,varp,alpha,h,vgp,bdryflag) ;
  gppause ;

  disp('try new figure window') ;
  GRAPHHAND = figure
  vitype = [1,2]
  sss2(mdat,vitype,varp,alpha,vhgp,vgp,bdryflag) ;
  gppause ;
  
  disp('movie in specified figure window') ;
  vitype = [1,2,2]
  sss2(mdat,vitype,varp,alpha,vhgp,vgp,bdryflag) ;
  gppause ;

  GRAPHHAND = figure
  disp('slider in specified figure window') ;
  vitype = [1,2,3]
  sss2(mdat,vitype,varp,alpha,vhgp,vgp,bdryflag) ;
  gppause ;

  disp('second slider') ;
  GRAPHHAND = [GRAPHHAND figure]
  vitype = [2,1,3]
  sss2(mdat,vitype,varp,alpha,vhgp,vgp,bdryflag) ;
  gppause ;



elseif itest == 4 ;     %  investigate alpha


  idecim = 0 ;     %  0 - use given 64 x 64 image
                   %  1 - decimate to 32 x 32 to increase speed

  ieg = 2 ;    % 
               %   1  -  parallel peaks
               %   2  -  peaks and valleys
               %   3  -  sombrero
               %   4  -  volcano
               %   5  -  piecewise linear

  inoise = 1 ;    % 
                  %  1  -  low noise
                  %  2  -  medium noise
                  %  3  -  high noise

  %  load data
  %
  eval(['load \matlab\steve\sss\data\sss1d' num2str(ieg) ...
                                num2str(inoise) ';']) ;
          % this loads the variables: xgrid ygrid mdat sig titstr noistr

  if idecim == 1 ;
    mdat = mdat(1:2:63,1:2:63) ;
         %  decimation of data (to keep run time short for testing)
  end ;


  type = [3, 1]
  varp = [1, 0] 

  alpha = 0.05 
  sss2(mdat,type,varp,alpha) ;

  subplot(2,2,1) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',['pooled sig, ' titlestr]) ;

  subplot(2,2,2) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',[titstr ', ' noistr ', ' titlestr]) ;

  subplot(2,2,3) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',['SSS ' num2str(type(1)) ...
                                          num2str(type(2)) ...
                                          ', alpha = ' num2str(alpha) ...
                                          ', ' titlestr]) ;

  subplot(2,2,4) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',[date ', ' titlestr]) ;

    orient landscape ;
  eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) 'a.ps ;']) ;

  gppause ;



  alpha = 0.01 
  sss2(mdat,type,varp,alpha) ;

  subplot(2,2,1) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',['pooled sig, ' titlestr]) ;

  subplot(2,2,2) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',[titstr ', ' noistr ', ' titlestr]) ;

  subplot(2,2,3) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',['SSS ' num2str(type(1)) ...
                                          num2str(type(2)) ...
                                          ', alpha = ' num2str(alpha) ...
                                          ', ' titlestr]) ;

  subplot(2,2,4) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',[date ', ' titlestr]) ;

    orient landscape ;
  eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) 'b.ps ;']) ;

  gppause ;





  alpha = 0.001 
  sss2(mdat,type,varp,alpha) ;

  subplot(2,2,1) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',['pooled sig, ' titlestr]) ;

  subplot(2,2,2) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',[titstr ', ' noistr ', ' titlestr]) ;

  subplot(2,2,3) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',['SSS ' num2str(type(1)) ...
                                          num2str(type(2)) ...
                                          ', alpha = ' num2str(alpha) ...
                                          ', ' titlestr]) ;

  subplot(2,2,4) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',[date ', ' titlestr]) ;

    orient landscape ;
  eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) 'c.ps ;']) ;

  gppause ;






  alpha = 0.20 
  sss2(mdat,type,varp,alpha) ;

  subplot(2,2,1) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',['pooled sig, ' titlestr]) ;

  subplot(2,2,2) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',[titstr ', ' noistr ', ' titlestr]) ;

  subplot(2,2,3) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',['SSS ' num2str(type(1)) ...
                                          num2str(type(2)) ...
                                          ', alpha = ' num2str(alpha) ...
                                          ', ' titlestr]) ;

  subplot(2,2,4) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',[date ', ' titlestr]) ;

    orient landscape ;
  eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) 'd.ps ;']) ;

  gppause ;





  alpha = 0.50 
  sss2(mdat,type,varp,alpha) ;

  subplot(2,2,1) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',['pooled sig, ' titlestr]) ;

  subplot(2,2,2) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',[titstr ', ' noistr ', ' titlestr]) ;

  subplot(2,2,3) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',['SSS ' num2str(type(1)) ...
                                          num2str(type(2)) ...
                                          ', alpha = ' num2str(alpha) ...
                                          ', ' titlestr]) ;

  subplot(2,2,4) ;
    titlestr = get(get(gca,'Title'),'String') ;
    set(get(gca,'Title'),'String',[date ', ' titlestr]) ;

    orient landscape ;
  eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) 'e.ps ;']) ;

  gppause ;





elseif itest == 5 ;     %  test different image sizes
   
   
  idec = 0 ;   %  0 - loop through all
               %  1 - 16x16
               %  2 - 32x32
               %  3 - 64x64
               %  4 - 128x128
               %  5 - 256x256

  itype = 0 ;   %  0 - loop through all
               %  1 - arrows only, single pixel
               %  2 - arrows only, 2 x 2 blocks
               %  3 - dots only, single pixel
               %  4 - dots only, 2 x 2 blocks
               %  5 - arrows and dots, single pixel
               %  6 - arrows and dots, 2 x 2 blocks
               %  7 - streamlines
               %  11 - single h

  ieg = 2 ;    % 
               %   1  -  parallel peaks
               %   2  -  peaks and valleys
               %   3  -  sombrero
               %   4  -  volcano
               %   5  -  piecewise linear

  inoise = 2 ;    % 
                  %  1  -  low noise
                  %  2  -  medium noise
                  %  3  -  high noise




  %  set looping parameters
  %
  if idec == 0 ;
    ids = 1 ;
    ide = 5 ;
  else ;
    ids = idec ;
    ide = idec ;
  end ;

  if itype == 0 ;
    its = 1 ;
    ite = 7 ;
  else ;
    its = itype ;
    ite = itype ;
  end ;


  %  load data
  %
  eval(['load \matlab\steve\sss\data\sss1dbig' num2str(ieg) ...
                                num2str(inoise) ';']) ;
          % this loads the variables: xgrid ygrid mdat sig titstr noistr
  mdatbig = mdat ;
          
          


  %  Main loop
  %
  for id = ids:ide ;

    if id == 1 ;    %  decimate to 16x16
      mdat = mdatbig(1:16:256,1:16:256) ;      
      decstr = '16 x 16' ;
    elseif id == 2 ;    %  decimate to 32x32
      mdat = mdatbig(1:8:256,1:8:256) ;      
      decstr = '32 x 32' ;
    elseif id == 3 ;    %  decimate to 64x64
      mdat = mdatbig(1:4:256,1:4:256) ;      
      decstr = '64 x 64' ;
    elseif id == 4 ;    %  decimate to 128x128
      mdat = mdatbig(1:2:256,1:2:256) ;      
      decstr = '128 x 128' ;
    elseif id == 5 ;    %  use full 256x256 image
      mdat = mdatbig ;      
      decstr = '256 x 256' ;
    end ;



    %  Loop through implementation types
    %
    for it = its:ite ;


      if it == 1 ;    %  1 - arrows only, single pixel
        type = [1,1] ;
      elseif it == 2 ;    %  2 - arrows only, 2 x 2 blocks
        type = [1,2] ;
      elseif it == 3 ;    %  3 - dots only, single pixel
        type = [2,1] ;
      elseif it == 4 ;    %  4 - dots only, 2 x 2 blocks
        type = [2,2] ;
      elseif it == 5 ;    %  5 - arrows and dots, single pixel
        type = [3,1] ;
      elseif it == 6 ;    %  6 - arrows and dots, 2 x 2 blocks
        type = [3,2] ;
      elseif it == 7 ;    %  7 - streamlines
        type = [4,0] ;
      elseif it == 11 ;    %  11 - arrows only, 2 x 2 blocks (for single h)
        type = [1,2] ;
      end ;

    disp(['Working on ' decstr ', type ' num2str(type)]) ;


      figure(1) ;
      clf ;


      if it < 10 ;
        sss2(mdat,[type, 1, 1, 2]) ;
          %  2  says automatically use full page when needed
      else ;     %  then try single h stuff
        sss2(mdat,type,[1,0],0.05,4) ;
          %  [1,0] is varp
          %  4  is h
      end ;



      if size(get(gcf,'Children'),1) == 4 ;
                              %  then have 4x4 array, so modify titles, etc.

        subplot(2,2,1) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',[decstr ', ' titlestr]) ;

        subplot(2,2,2) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',[titstr ', ' noistr ', ' titlestr]) ;

        subplot(2,2,3) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',['SSS ' num2str(type(1)) ...
                                          num2str(type(2)) ', ' titlestr]) ;

        subplot(2,2,4) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',[date ', ' titlestr]) ;


          orient landscape ;
        eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) ...
                              num2str(id) num2str(it) '.ps ;']) ;

      elseif gcf == 4 ;   %  then have 4 full page images

        figure(1) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',[decstr ', ' titlestr]) ;

          orient landscape ;
        eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) ...
                              num2str(id) num2str(it) 'a.ps ;']) ;

        figure(2) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',[titstr ', ' noistr ', ' titlestr]) ;

          orient landscape ;
        eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) ...
                              num2str(id) num2str(it) 'b.ps ;']) ;


        figure(3) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',['SSS ' num2str(type(1)) ...
                                          num2str(type(2)) ', ' titlestr]) ;

          orient landscape ;
        eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) ...
                              num2str(id) num2str(it) 'c.ps ;']) ;


        figure(4) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',[date ', ' titlestr]) ;

          orient landscape ;
        eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) ...
                              num2str(id) num2str(it) 'd.ps ;']) ;


      end ;


    end ;


  end ;





elseif itest == 6 ;     %  test movies
   
   
  idec = 3 ;   %  0 - loop through all
               %  1 - 16x16
               %  2 - 32x32
               %  3 - 64x64
               %  4 - 128x128
               %  5 - 256x256

  itype = 10 ;   %  0 - loop through all
               %  1 - arrows only, single pixel
               %  2 - arrows only, 2 x 2 blocks
               %  3 - dots only, single pixel
               %  4 - dots only, 2 x 2 blocks
               %  5 - arrows and dots, single pixel
               %  6 - arrows and dots, 2 x 2 blocks
               %  10 - smooths only


  ieg = 2 ;    % 
               %   1  -  parallel peaks
               %   2  -  peaks and valleys
               %   3  -  sombrero
               %   4  -  volcano
               %   5  -  piecewise linear

  inoise = 2 ;    % 
                  %  1  -  low noise
                  %  2  -  medium noise
                  %  3  -  high noise




  %  set looping parameters
  %
  if idec == 0 ;
    ids = 1 ;
    ide = 5 ;
  else ;
    ids = idec ;
    ide = idec ;
  end ;

  if itype == 0 ;
    its = 1 ;
    ite = 6 ;
  else ;
    its = itype ;
    ite = itype ;
  end ;


  %  load data
  %
  eval(['load \matlab\steve\sss\data\sss1dbig' num2str(ieg) ...
                                num2str(inoise) ';']) ;
          % this loads the variables: xgrid ygrid mdat sig titstr noistr
  mdatbig = mdat ;
          
          

  %  Main loop
  %
  for id = ids:ide ;

    if id == 1 ;    %  decimate to 16x16
      mdat = mdatbig(1:16:256,1:16:256) ;      
      decstr = '16 x 16' ;
    elseif id == 2 ;    %  decimate to 32x32
      mdat = mdatbig(1:8:256,1:8:256) ;      
      decstr = '32 x 32' ;
    elseif id == 3 ;    %  decimate to 64x64
      mdat = mdatbig(1:4:256,1:4:256) ;      
      decstr = '64 x 64' ;
    elseif id == 4 ;    %  decimate to 128x128
      mdat = mdatbig(1:2:256,1:2:256) ;      
      decstr = '128 x 128' ;
    elseif id == 5 ;    %  use full 256x256 image
      mdat = mdatbig ;      
      decstr = '256 x 256' ;
    end ;



    %  Loop through implementation types
    %
    for it = its:ite ;


      if it == 1 ;    %  1 - arrows only, single pixel
        type = [1,1] ;
      elseif it == 2 ;    %  2 - arrows only, 2 x 2 blocks
        type = [1,2] ;
      elseif it == 3 ;    %  3 - dots only, single pixel
        type = [2,1] ;
      elseif it == 4 ;    %  4 - dots only, 2 x 2 blocks
        type = [2,2] ;
      elseif it == 5 ;    %  5 - arrows and dots, single pixel
        type = [3,1] ;
      elseif it == 6 ;    %  6 - arrows and dots, 2 x 2 blocks
        type = [3,2] ;
      elseif it == 10 ;    %  10 - smooths only
        type = [0,0] ;
      end ;

      type = [type, 2] ;
          %  third entry controls movie, etc.

      disp(['Working on ' decstr ', type ' num2str(type)]) ;


      figure(1) ;
      clf ;


      sss2(mdat,type,[1,0],0.05,[1,16,33]) ;
          %  [1,0]  -  variance parameter
          %  0.05   -  alpha
          %  [1,16,33]  -  33 frames   1-16 (adds 8 more to usual)


      %  rename mpeg file
      %
      rnstr = ['!rename sss1.mpg sss1' ...
                                num2str(id) num2str(it) '.mpg ;'] ;
      eval(rnstr) ;


    end ;


  end ;





elseif itest == 7 ;     %  test slider form
   
   
  idec = 3 ;   %  0 - loop through all
               %  1 - 16x16
               %  2 - 32x32
               %  3 - 64x64
               %  4 - 128x128
               %  5 - 256x256

  itype = 6 ;   %  0 - loop through all
               %  1 - arrows only, single pixel
               %  2 - arrows only, 2 x 2 blocks
               %  3 - dots only, single pixel
               %  4 - dots only, 2 x 2 blocks
               %  5 - arrows and dots, single pixel
               %  6 - arrows and dots, 2 x 2 blocks


  ieg = 2 ;    % 
               %   1  -  parallel peaks
               %   2  -  peaks and valleys
               %   3  -  sombrero
               %   4  -  volcano
               %   5  -  piecewise linear

  inoise = 3 ;    % 
                  %  1  -  low noise
                  %  2  -  medium noise
                  %  3  -  high noise




  %  set looping parameters
  %
  if idec == 0 ;
    ids = 1 ;
    ide = 5 ;
  else ;
    ids = idec ;
    ide = idec ;
  end ;

  if itype == 0 ;
    its = 1 ;
    ite = 6 ;
  else ;
    its = itype ;
    ite = itype ;
  end ;


  %  load data
  %
  eval(['load \matlab\steve\sss\data\sss1dbig' num2str(ieg) ...
                                num2str(inoise) ';']) ;
          % this loads the variables: xgrid ygrid mdat sig titstr noistr
  mdatbig = mdat ;
          
          

  %  Main loop
  %
  for id = ids:ide ;

    if id == 1 ;    %  decimate to 16x16
      mdat = mdatbig(1:16:256,1:16:256) ;      
      decstr = '16 x 16' ;
    elseif id == 2 ;    %  decimate to 32x32
      mdat = mdatbig(1:8:256,1:8:256) ;      
      decstr = '32 x 32' ;
    elseif id == 3 ;    %  decimate to 64x64
      mdat = mdatbig(1:4:256,1:4:256) ;      
      decstr = '64 x 64' ;
    elseif id == 4 ;    %  decimate to 128x128
      mdat = mdatbig(1:2:256,1:2:256) ;      
      decstr = '128 x 128' ;
    elseif id == 5 ;    %  use full 256x256 image
      mdat = mdatbig ;      
      decstr = '256 x 256' ;
    end ;



    %  Loop through implementation types
    %
    for it = its:ite ;


      if it == 1 ;    %  1 - arrows only, single pixel
        type = [1,1] ;
      elseif it == 2 ;    %  2 - arrows only, 2 x 2 blocks
        type = [1,2] ;
      elseif it == 3 ;    %  3 - dots only, single pixel
        type = [2,1] ;
      elseif it == 4 ;    %  4 - dots only, 2 x 2 blocks
        type = [2,2] ;
      elseif it == 5 ;    %  5 - arrows and dots, single pixel
        type = [3,1] ;
      elseif it == 6 ;    %  6 - arrows and dots, 2 x 2 blocks
        type = [3,2] ;
      end ;

      type = [type, 3] ;
          %  third entry controls movie, etc.

      disp(['Working on ' decstr ', type ' num2str(type)]) ;


      figure(1) ;
      clf ;


      %  set up global variables 
      %
      global SLIMOV VLOG10H CURRENTH SLIDERHAND STITLEHAND SSSSTR ;
          %  SLIMOV - slider's movie matrix
          %  VLOG10H - vector of log10 bandwidths
          %  CURRENTH - current value of bandwidth for slider
          %  SLIDERHAND - Handle for Slider (to get value)
          %  STITLEHAND - Handle for Title of Slider (showing bandwidth value)
          %  SSSSTR - String for type of SSS that is running


      sss2(mdat,type) ;



    end ;


  end ;




elseif itest == 8 ;     %  test streamlines
   
   
  idec = 0 ;   %  0 - loop through all
               %  1 - 16x16
               %  2 - 32x32
               %  3 - 64x64
               %  4 - 128x128
               %  5 - 256x256

  ieg = 2 ;    % 
               %   1  -  parallel peaks
               %   2  -  peaks and valleys
               %   3  -  sombrero
               %   4  -  volcano
               %   5  -  piecewise linear

  inoise = 2 ;    % 
                  %  1  -  low noise
                  %  2  -  medium noise
                  %  3  -  high noise




  %  set looping parameters
  %
  if idec == 0 ;
    ids = 1 ;
    ide = 5 ;
  else ;
    ids = idec ;
    ide = idec ;
  end ;

  %  load data
  %
  eval(['load \matlab\steve\sss\data\sss1dbig' num2str(ieg) ...
                                num2str(inoise) ';']) ;
          % this loads the variables: xgrid ygrid mdat sig titstr noistr
  mdatbig = mdat ;
          
          

  %  Main loop
  %
  for id = ids:ide ;

    if id == 1 ;    %  decimate to 16x16
      mdat = mdatbig(1:16:256,1:16:256) ;      
      decstr = '16 x 16' ;
    elseif id == 2 ;    %  decimate to 32x32
      mdat = mdatbig(1:8:256,1:8:256) ;      
      decstr = '32 x 32' ;
    elseif id == 3 ;    %  decimate to 64x64
      mdat = mdatbig(1:4:256,1:4:256) ;      
      decstr = '64 x 64' ;
    elseif id == 4 ;    %  decimate to 128x128
      mdat = mdatbig(1:2:256,1:2:256) ;      
      decstr = '128 x 128' ;
    elseif id == 5 ;    %  use full 256x256 image
      mdat = mdatbig ;      
      decstr = '256 x 256' ;
    end ;



%    %  Loop through implementation types%
%    %
%    for it = its:ite ;
%
%
%      if it == 1 ;    %  1 - arrows only, single pixel
%        type = [1,1] ;
%      elseif it == 2 ;    %  2 - arrows only, 2 x 2 blocks
%        type = [1,2] ;
%      elseif it == 3 ;    %  3 - dots only, single pixel
%        type = [2,1] ;
%      elseif it == 4 ;    %  4 - dots only, 2 x 2 blocks
%        type = [2,2] ;
%      elseif it == 5 ;    %  5 - arrows and dots, single pixel
%        type = [3,1] ;
%      elseif it == 6 ;    %  6 - arrows and dots, 2 x 2 blocks
%        type = [3,2] ;
%      end ;

%      type = [type, 3] ;
%          %  third entry controls movie, etc.

type = 4 ;

      disp(['Working on ' decstr ', type ' num2str(type)]) ;


      figure(1) ;
      clf ;




%      sss2(mdat,type,[1,0],0.05,4) ;
      sss2(mdat,type) ;



      if gcf == 1 ;    %  then have 4x4 array, so modify titles, etc.

        subplot(2,2,1) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',[decstr ', ' titlestr]) ;

        subplot(2,2,2) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',[titstr ', ' noistr ', ' titlestr]) ;

        subplot(2,2,3) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',['SSS, StrmLn, ' titlestr]) ;

        subplot(2,2,4) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',[date ', ' titlestr]) ;


          orient landscape ;
        eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) ...
                                              num2str(id) '.ps ;']) ;

      elseif gcf == 4 ;   %  then have 4 full page images

        figure(1) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',[decstr ', ' titlestr]) ;

          orient landscape ;
        eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) ...
                                            num2str(id) 'a.ps ;']) ;

        figure(2) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',[titstr ', ' noistr ', ' titlestr]) ;

          orient landscape ;
        eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) ...
                                           num2str(id) 'b.ps ;']) ;


        figure(3) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',['SSS, StrmLn, ' titlestr]) ;

          orient landscape ;
        eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) ...
                                            num2str(id) 'c.ps ;']) ;


        figure(4) ;
          titlestr = get(get(gca,'Title'),'String') ;
          set(get(gca,'Title'),'String',[date ', ' titlestr]) ;

          orient landscape ;
        eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) ...
                                         num2str(id) 'd.ps ;']) ;


      end ;


%    end ;


  end ;




elseif itest == 9 ;     %  repeat standard tests for streamlines


  ieg = 0 ;    %   0  -  loop through all
               %   1  -  parallel peaks
               %   2  -  peaks and valleys
               %   3  -  sombrero
               %   4  -  volcano
               %   5  -  piecewise linear

  inoise = 0 ;    %  0  -  loop through all
                  %  1  -  low noise
                  %  2  -  medium noise
                  %  3  -  high noise




  %  set looping parameters
  %
  if ieg == 0 ;
    ies = 1 ;
    iee = 5 ;
  else ;
    ies = ieg ;
    iee = ieg ;
  end ;

  if inoise == 0 ;
    ins = 1 ;
    ine = 3 ;
  else ;
    ins = inoise ;
    ine = inoise ;
  end ;




  %  Main loop
  %
  for ie = ies:iee ;


    %  Loop through noise levels
    %
    for in = ins:ine ;

      eval(['load \matlab\steve\sss\data\sss1d' num2str(ie) ...
                                num2str(in) ';']) ;
          % this loads the variables: xgrid ygrid mdat sig titstr noistr

      figure(1) ;
      clf ;


      sss2(mdat,4) ;
          %  Type 4 for streamlines


      subplot(2,2,1) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',[titstr ', ' titlestr]) ;

      subplot(2,2,2) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',[noistr ', ' titlestr]) ;

      subplot(2,2,3) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',['SSS, ' titlestr]) ;

      subplot(2,2,4) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',[date ', ' titlestr]) ;


        orient landscape ;
      eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) num2str(ie) ...
                                num2str(in) '.ps ;']) ;



    end ;


  end ;







elseif itest == 10 ;     %  test 0 signal


  seed = 12943809 ;
  seed = 38474095 ;
  seed = 98723947 ;
  randn('seed',seed) ;

  n = 32 ;
  mdat = randn(n,n) ;  

   
   
  ivarp = 2 ;     %  1 - known variance
                  %  2 - pooled est.
                  %  3 - local est.

  if ivarp == 1 ;
    varp = [0,1] ;
    varstr = 'Known variance' ;
  elseif ivarp == 2 ;
    varp = [1,0] ;
    varstr = 'Pooled estimated variance' ;
  elseif ivarp == 3 ;
    varp = [1,1] ;
    varstr = 'Local estimated variance' ;
  end ;


  type = [3,1] ;   %  5 - arrows and dots, single pixel

  type = [type, 3] ;
          %  third entry controls movie, etc.

  disp(['  Working on ' varstr]) ;

  figure(1) ;
  clf ;


  %  set up global variables 
  %
  global SLIMOV VLOG10H CURRENTH SLIDERHAND STITLEHAND SSSSTR ;
          %  SLIMOV - slider's movie matrix
          %  VLOG10H - vector of log10 bandwidths
          %  CURRENTH - current value of bandwidth for slider
          %  SLIDERHAND - Handle for Slider (to get value)
          %  STITLEHAND - Handle for Title of Slider (showing bandwidth value)
          %  SSSSTR - String for type of SSS that is running


  sss2(mdat,type,varp) ;





elseif itest == 11 ;     %  test single line


  seed = 12943809 ;
  seed = 38474095 ;
  seed = 98723947 ;
  randn('seed',seed) ;

  n = 32 ;
  ht = 100 ;
  ht = 10 ;
  ht = 2 ;
  mdat = diag(ht * ones(n,1)) + randn(n,n) ;  

   
   
  ivarp = 1 ;     %  1 - known variance
                  %  2 - pooled est.
                  %  3 - local est.

  if ivarp == 1 ;
    varp = [0,1] ;
    varstr = 'Known variance' ;
  elseif ivarp == 2 ;
    varp = [1,0] ;
    varstr = 'Pooled estimated variance' ;
  elseif ivarp == 3 ;
    varp = [1,1] ;
    varstr = 'Local estimated variance' ;
  end ;


  type = [3,1] ;   %  5 - arrows and dots, single pixel

  type = [type, 3] ;
          %  third entry controls movie, etc.

  disp(['  Working on ' varstr]) ;

  figure(1) ;
  clf ;


  %  set up global variables 
  %
  global SLIMOV VLOG10H CURRENTH SLIDERHAND STITLEHAND SSSSTR ;
          %  SLIMOV - slider's movie matrix
          %  VLOG10H - vector of log10 bandwidths
          %  CURRENTH - current value of bandwidth for slider
          %  SLIDERHAND - Handle for Slider (to get value)
          %  STITLEHAND - Handle for Title of Slider (showing bandwidth value)
          %  SSSSTR - String for type of SSS that is running


  sss2(mdat,type,varp) ;





elseif itest == 12 ;     %  test out n ~= m and also odd

  n = 25 ;
  m = 40 ;

  ieg = 2 ;    % 
               %   1  -  parallel peaks
               %   2  -  peaks and valleys
               %   3  -  sombrero
               %   4  -  volcano
               %   5  -  piecewise linear

  inoise = 1 ;    % 
                  %  1  -  low noise
                  %  2  -  medium noise
                  %  3  -  high noise

  %  load data
  %
  eval(['load \matlab\steve\sss\data\sss1d' num2str(ieg) ...
                                num2str(inoise) ';']) ;
          % this loads the variables: xgrid ygrid mdat sig titstr noistr


  mdat = mdat(65-n:64,21:20+m) ;
          %  a nonsquare piece, with interesting features




      sss2(mdat,[4,0]) ;
%                |:  1 - arrows only
%                |:  2 - dots only
%                |:  3 - dots and arrows
%                |:  4 - streamlines
%                  |:  1 - single pixels
%                  |:  2 - 2 x 2 boxes





elseif itest == 13 ;     %  test 0 signal, different alphas


  seed = 12943809 ;
  seed = 38474095 ;
  seed = 98723947 ;
  randn('seed',seed) ;

  n = 32 ;
  mdat = randn(n,n) ;  

   
   
  ivarp = 0 ;     %  0 - loop through all
                  %  1 - known variance
                  %  2 - pooled est.
                  %  3 - local est.


  ialpha = 6 ;    %  0 - loop through all
                  %  1 - alpha = .001
                  %  2 - alpha = .01
                  %  3 - alpha = .05
                  %  4 - alpha = .2
                  %  5 - alpha = .5
                  %  6 - alpha = .9


  if ivarp == 0 ;
    ivs = 1 ;
    ive = 3 ;
  else ;
    ivs = ivarp ;
    ive = ivarp ;
  end ;


  if ialpha == 0 ;
    ias = 1 ;
    iae = 6 ;
  else 
    ias = ialpha ;
    iae = ialpha ;
  end ;


  for iv = ivs:ive ;     %    loop through variance choices


    if iv == 1 ;
      varp = [0,1] ;
      varstr = 'Known variance' ;
    elseif iv == 2 ;
      varp = [1,0] ;
      varstr = 'Pooled estimated variance' ;
    elseif iv == 3 ;
      varp = [1,1] ;
      varstr = 'Local estimated variance' ;
    end ;


    for ia = ias:iae ;     %   loop though alphas

      if ia == 1 ;
        alpha = 0.001 ;
      elseif ia == 2 ;
        alpha = 0.01 ;
      elseif ia == 3 ;
        alpha = 0.05 ;
      elseif ia == 4 ;
        alpha = 0.2 ;
      elseif ia == 5 ;
        alpha = 0.5 ;
      elseif ia == 6 ;
        alpha = 0.9 ;
      end ;



      disp(['Working on ' varstr ', alpha = ' num2str(alpha)]) ;


      type = [3,1] ;   %  5 - arrows and dots, single pixel


      sss2(mdat,type,varp,alpha) ;




      subplot(2,2,1) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',['No Signal, alpha = ' ...
                                        num2str(alpha) ', ' titlestr]) ;

      subplot(2,2,2) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',[varstr ', ' titlestr]) ;

      subplot(2,2,3) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',['SSS ' num2str(type) ', ' ...
                                                     titlestr]) ;

      subplot(2,2,4) ;
        titlestr = get(get(gca,'Title'),'String') ;
        set(get(gca,'Title'),'String',[date ', ' titlestr]) ;


        orient landscape ;
      eval(['print -dpsc \matlab\steve\ps\sss1' num2str(itest) num2str(iv) ...
                                num2str(ia) '.ps ;']) ;



    end ;    %  ialpha loop

  end ;    %  ivarp loop




elseif  itest > 100  &  itest < 200 ;    %  then test defaults



  if itest == 101 ;    % just do basics
    idecim = 1 ;     %  0 - use given 64 x 64 image
                     %  1 - decimate to 32 x 32 to increase speed

    ieg = 2 ;    %   1  -  parallel peaks
                 %   2  -  peaks and valleys
                 %   3  -  sombrero
                 %   4  -  volcano
                 %   5  -  piecewise linear

    inoise = 2 ;    %  1  -  low noise
                    %  2  -  medium noise
                    %  3  -  high noise


    paramstruct = [] ;


  elseif itest == 102 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = ['???'] ;


  elseif itest == 103 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1 ...
                                              ) ;


  elseif itest == 104 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'imovie',1 ...
                                              ) ;


  elseif itest == 105 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',0, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 106 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',1, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 107 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',2, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 108 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 109 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',4, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 110 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',4, ...
                         'igrid',2, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 111 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'igrid',1, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 112 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',2, ...
                         'igrid',1, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 113 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',1, ...
                         'igrid',1, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 114 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',1, ...
                         'igrid',1, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 115 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'ivarunknown',1, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 116 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'ivarunknown',0, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 117 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'ivarunknown',0, ...
                         'varinput',0.001, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 118 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'ivarunknown',0, ...
                         'varinput',10, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 119 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'ivarlocal',0, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 120 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'ivarlocal',1, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 121 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'alpha',0.05, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 122 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'alpha',0.005, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 123 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'alpha',0.2, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 124 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'hmin',0, ...
                         'hmax',64, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 125 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'hmin',0.5, ...
                         'hmax',4, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 126 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'hmin',4, ...
                         'hmax',4, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 127 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'hmin',4, ...
                         'hmax',4, ...
                         'imovie',1 ...
                                              ) ;


  elseif itest == 128 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'nh',-25, ...
                         'imovie',1 ...
                                              ) ;


  elseif itest == 129 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'nh',4, ...
                         'imovie',1 ...
                                              ) ;


  elseif itest == 130 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'nh',100, ...
                         'imovie',1 ...
                                              ) ;


  elseif itest == 131 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'nh',1, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 132 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'hmin',4, ...
                         'hmax',27, ...
                         'nh',1, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 133 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'hmin',4, ...
                         'hmax',2, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 134 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 2 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'vgp',27, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 135 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 4 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'bdryp',1, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 136 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 4 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'bdryp',0, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 137 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 4 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'bdryp',2, ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 138 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 4 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'savestr','\temp\sss2test', ...
                         'imovie',0 ...
                                              ) ;


  elseif itest == 139 ;    %  nonstandard paramstruct
    idecim = 1 ;  
    ieg = 4 ;  
    inoise = 2 ;
          %  see itest == 101  for definitions of these

    paramstruct = struct('iscreenwrite',1, ...
                         'stype',3, ...
                         'savestr','\temp\sss2test', ...
                         'imovie',1 ...
                                              ) ;


  end ;    %  of itest if block




  eval(['load \matlab\steve\sss\data\sss1d' num2str(ieg) ...
                            num2str(inoise) ';']) ;
           % this loads the variables: xgridygrid mdat sig titstr noistr


  if idecim == 1 ;
    mdat = mdat(1:2:63,1:2:63) ;
           %  decimation of data (to keep run time short for testing)
  end ;

  close all ;
          %  this seems to avoid getting ghost colors
          %  appearing in some plots

  sss2(mdat,paramstruct) ;





elseif  itest > 200 ;    %  then test specialized stuff


%  itoobigctrl
%  ismallessctrl






end ;





