%  Matlab script PapFig1.m
%  J. S. Marron's modification of Sudeshna Adak's script RiskFig1.m
%
%  Designed to be run as a single script, and to print an output file.
%


global x_tmp x_use x_length x_name sigchoice  fig_hand4 x_noise noiseamp
global signal_name n
disp('**** This produces Fig 1 of paper   ****');

RiskInit ;
fig_hand4 = figure(1) ;
clf ;

%fig_hand4 = figure;
%               'units','normal','position',[0.25,0,0.75,1.0],...
        set( fig_hand4, 'Name', 'Paper Figure 1', ...
           'units','normal','position',[0.3,0.4,(2/3)*1.1,(2/3)*0.85],...
           'PaperUnits','normalized','PaperPosition',...
            [0.0,0,1.0,0.85],'PaperOrientation','landscape');
sigchoice = ones(1,10);nplot = sum(sigchoice);
b = 1:10; b = b(sigchoice == 1);
  for i = 1:nplot,
    Gen_signal(b(i),'No');
subplot(ceil(nplot/4),4,i)
       plot((0:(x_length-1))/x_length,x_tmp);
       axis([0 1 0 1]);
%       grid on;
       titlestr = ['#' num2str(b(i)) '  ' signal_name]; 
       title(titlestr);
    end
Gen_signal(b(1),'No');
  subplot(3,4,11)
    plot((0:(x_length-1))/x_length,x_tmp);
    title('Low Noise, sig = 0.02');
    hold on;
    axis([0 1 0 1]);
%    grid on;
    x_noise = normrnd(0,0.02,size(x_tmp));
    x_noisy = x_tmp + x_noise;
    plot((0:(x_length-1))/x_length,x_noisy,'.');
    hold off;
 subplot(3,4,12)
    plot((0:(x_length-1))/x_length,x_tmp);
    title('High Noise, sig = 0.1');
    hold on;
    axis([0 1 0 1]);
%    grid on;
    x_noise = normrnd(0,0.1,size(x_tmp));
    x_noisy = x_tmp + x_noise;
    plot((0:(x_length-1))/x_length,x_noisy,'.');
    hold off;


disp('creating postscript file') ;
  orient landscape ;
print -dps PapFig1.ps ;
