%  Gauss script PapFig10.m
%  J. S. Marron's modification of Sudeshna Adak's script RiskFig10.m
%
%  Designed to be run as a single script, and to print an output file.
%

global x_use x_length x_name sigchoice  fig_hand3 PlotFig
global x_fft x_haar x_symm x_coif x_daub x_noise Signals____entries
global x_tmp signal_name

RiskInit ;

disp('********************************************************************');
disp('*     Hello: This is going to take 2 to 3 minutes                  *');
disp('*     Wait till then to look at the plot                           *');
disp('********************************************************************');
nvec = 2.^(6:12);
lambdMO = [1.47391  1.66865 1.85982 2.04748 2.23203 2.41405 ...
           2.59427 2.77343 2.95218 3.13093 3.30975];
% Minimax Optimal lamda derived in Donoho-Johnstone, Biometrika 94
sigchoice = zeros(1,10); sigchoice(3) = 1;
sigchoice(8) = 1;
 
fig_hand3 = figure(1) ;
clf ;
 
%fig_hand3 = figure;
        set( fig_hand3, 'Name', 'Paper Figure 10', ...
               'units','normal','position',[0.5,0.2,(2/3)*0.8,(2/3)*1.1],...
               'PaperUnits','normalized','PaperPosition',...
                [0.0,0,1.0,1.0],'PaperOrientation','landscape');
disp('***  This produces Figure 10 of the Paper ***');
      nplot = sum(sigchoice);
b = 1:10; b = b(sigchoice == 1);
  for i = 1:nplot,
   x_name = deblank(Signals____entries(b(i),:)) ;
    figure(fig_hand3);
   [x_hard_ideal_low,x_hard_risk_low] = ...
      CalcSamplesizeRisk(nvec,x_name,'Symmlet 8',0.02,'Hard');
   [x_soft_ideal_low,x_soft_risk_low] = ...
      CalcSamplesizeRisk(nvec,x_name,'Symmlet 8',0.02,'Soft');
   [x_softmo_ideal_low,x_softmo_risk_low] = ...
      CalcSamplesizeRisk(nvec,x_name,'Symmlet 8',0.02,'Soft',lambdMO);
   [x_hard_ideal_high,x_hard_risk_high] = ...
      CalcSamplesizeRisk(nvec,x_name,'Symmlet 8',0.1,'Hard');
   [x_soft_ideal_high,x_soft_risk_high] = ...
      CalcSamplesizeRisk(nvec,x_name,'Symmlet 8',0.1,'Soft');
   [x_softmo_ideal_high,x_softmo_risk_high] = ...
      CalcSamplesizeRisk(nvec,x_name,'Symmlet 8',0.1,'Soft',lambdMO);
      Size = log2(nvec);
ymin = min([min(x_hard_risk_low) min(x_soft_risk_low) ...
      min(x_softmo_risk_low)  min(x_hard_risk_high) ...
      min(x_soft_risk_high) min(x_softmo_risk_high)]);
ymax = max([max(x_hard_risk_low) max(x_soft_risk_low) ...
      max(x_softmo_risk_low)  max(x_hard_risk_high) ...
      max(x_soft_risk_high) max(x_softmo_risk_high)]);
delta = 0.05*(ymax-ymin);
figure(fig_hand3);


   subplot(3,2,(2*(i-1)+1)),
      plot(Size,x_hard_risk_low);
      hold on;v = axis;axis([min(Size) max(Size) (ymin-delta) (ymax+delta)]);
      plot(Size,x_soft_risk_low,'--');
      plot(Size,x_softmo_risk_low,'-.');
        vhand = get(gca,'Children') ;
        set(vhand(1:3),'LineWidth',2) ;
      xlabel('log2(n)');ylabel('log10(Risk)');
      titlestr = ['#' num2str(b(i)) '  ' x_name ':  sigma = 0.02'];
      title(titlestr);

       %  lines from PapFig6.m
       vax = axis ;
         lx = vax(1) + .45 * (vax(2) - vax(1)) ;
         ly = vax(3) + .81 * (vax(4) - vax(3)) ;
         lxjump = 0.2 * (vax(2) - vax(1)) ;
         lyjump = .07 * (vax(4) - vax(3)) ;
       text(lx+1.2*lxjump,ly+2*lyjump,'Hard, lam_D') ;
       text(lx+1.2*lxjump,ly+lyjump,'Soft, lam_D') ;
       text(lx+1.2*lxjump,ly,'Soft, lam_MO') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:3),'FontSize',8) ;
       plot([lx ;lx+lxjump ],[ly+2*lyjump; ly+2*lyjump],'-') ;
       plot([lx ;lx+lxjump ],[ly+lyjump; ly+lyjump],'--') ;
       plot([lx ;lx+lxjump ],[ly; ly],'-.') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:3),'LineWidth',2) ;

      hold off;


   subplot(3,2,(2*(i-1)+2)),
      plot(Size,x_hard_risk_high);
      hold on;v = axis;axis([min(Size) max(Size) (ymin-delta) (ymax+delta)]);
      plot(Size,x_soft_risk_high,'--');
      plot(Size,x_softmo_risk_high,'-.');
        vhand = get(gca,'Children') ;
        set(vhand(1:3),'LineWidth',2) ;
      xlabel('log2(n)');ylabel('log10(Risk)');
      titlestr = ['#' num2str(b(i)) '  ' x_name ':  sigma = 0.1'];
      title(titlestr);

       %  lines from PapFig2.m
       vax = axis ;
         lx = vax(1) + .45 * (vax(2) - vax(1)) ;
         ly = vax(3) + .11 * (vax(4) - vax(3)) ;
         lxjump = 0.2 * (vax(2) - vax(1)) ;
         lyjump = .07 * (vax(4) - vax(3)) ;
       text(lx+1.2*lxjump,ly+2*lyjump,'Hard, lam_D') ;
       text(lx+1.2*lxjump,ly+lyjump,'Soft, lam_D') ;
       text(lx+1.2*lxjump,ly,'Soft, lam_MO') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:3),'FontSize',8) ;
       plot([lx ;lx+lxjump ],[ly+2*lyjump; ly+2*lyjump],'-') ;
       plot([lx ;lx+lxjump ],[ly+lyjump; ly+lyjump],'--') ;   
       plot([lx ;lx+lxjump ],[ly; ly],'-.') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:3),'LineWidth',2) ;

      hold off;


end      
    
disp('***************************************************************');
disp('*                Basis used:     Symmlet 8                    *');
disp('*    Threshold Scale chosen to minimize risk in each case     *');
disp('***************************************************************');
%ax=axes('Units','Normal','Position',[0,0,1,0.2],'Visible','off',...
%'FontSize',8);
%legend('-','Hard lambdaD','--','Soft lambdaD',':','Soft lambdaMO');

 
disp('creating postscript file') ;
  orient tall ;
print -dps PapFig10.ps ;
  
