%  Matlab script PapFig11.m
%  J. S. Marron's modification of Sudeshna Adak's script RiskFig11.m
%
%  Designed to be run as a single script, and to print an output file.
%

global x_use x_length x_name sigchoice  fig_hand3 PlotFig
global x_fft x_haar x_symm x_coif x_daub x_noise Signals____entries
global x_tmp signal_name
disp('********************************************************************');
disp('*     Hello: This is going to take 2 to 3 minutes                  *');
disp('*     Wait till then to look at the plot                           *');
disp('********************************************************************');
x_length = 1024;
 
RiskInit ;
fig_hand3 = figure(1) ;
clf ;
 
%fig_hand3 = figure;
        set( fig_hand3, 'Name', 'Paper Figure 11', ...
             'units','normal','position',[0.5,0.2,(2/3)*0.8,(2/3)*1.1],...
             'PaperUnits','normalized','PaperPosition',...
              [0.0,0,1.0,1.0],'PaperOrientation','landscape');
disp('***  This produces Figure 11 of the Paper ***');
sigma = 10.^linspace(-3,0,50);Lsigma = log10(sigma+eps);
%Rawrisk = log10(sigma + eps);
lambdMO = [1.47391  1.66865 1.85982 2.04748 2.23203 2.41405 ...
           2.59427 2.77343 2.95218 3.13093 3.30975];
% Minimax Optimal lamda derived in Donoho-Johnstone, Biometrika 94
n0 = 2.^(6:12);
for i = 1:length(n0),
    if x_length == n0(i)
      lambdMO = lambdMO(i);
    end
    if any(x_length == n0) == 0
      disp('Do not know lambda-MO for this length of signal');
    end
end
sigchoice = zeros(1,10); sigchoice(5) = 1;sigchoice(10) = 1;
      nplot = sum(sigchoice);
b = 1:10; b = b(sigchoice == 1);
  for i = 1:nplot,
    Gen_signal(b(i),'No');
    figure(fig_hand3);
        x_symm = FWT_PO(x_tmp,0,MakeONFilter('Symmlet',8));
    x_symm_hard = ...
       CalcNoiseLevelRisk(x_length,x_symm,sigma);
    x_symm_soft = ...
       CalcNoiseLevelRisk(x_length,x_symm,sigma,'Soft');
    x_symm_softmo = ...
       CalcNoiseLevelRisk(x_length,x_symm,sigma,'Soft',lambdMO);
    x_raw = log10(sigma.^2*x_length);
ymin = min([min(x_symm_hard) min(x_symm_soft) min(x_symm_softmo)]);
ymax = max([max(x_symm_hard) max(x_symm_soft) max(x_symm_softmo)]);
delta = 0.05*(ymax-ymin);
figure(fig_hand3);


%   subplot(ceil(nplot/2),2,i),
   subplot(3,2,2*(i-1)+1),
      plot(Lsigma,x_symm_hard);
      hold on;v = axis;axis([min(Lsigma) max(Lsigma) (ymin-delta) (ymax+delta)]);
      plot(Lsigma,x_symm_soft,'--');
      plot(Lsigma,x_symm_softmo,'-.');
      plot(Lsigma,x_raw,':');
        vhand = get(gca,'Children') ;
        set(vhand(1:3),'LineWidth',2) ;
      line([log10(0.02) log10(0.02)],[(ymin-delta) (ymax+delta)]);
      line([log10(0.1) log10(0.1)],[(ymin-delta) (ymax+delta)]);
      xlabel('log10(sigma)');ylabel('log10(Risk)');
      titlestr = ['#' num2str(b(i)) '  ' signal_name]; 
title(titlestr);

       %  lines from PapFig6.m
       vax = axis ;
         lx = vax(1) + .6 * (vax(2) - vax(1)) ;
         ly = vax(3) + .11 * (vax(4) - vax(3)) ;
         lxjump = 0.2 * (vax(2) - vax(1)) ;
         lyjump = .07 * (vax(4) - vax(3)) ;
       text(lx+1.2*lxjump,ly+2*lyjump,'Haar') ;
       text(lx+1.2*lxjump,ly+lyjump,'Symm8') ; 
       text(lx+1.2*lxjump,ly,'Fourier') ;
       text(lx+1.2*lxjump,ly-lyjump,'Raw Y') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:4),'FontSize',8) ;
       plot([lx ;lx+lxjump ],[ly+2*lyjump; ly+2*lyjump],'-') ;
       plot([lx ;lx+lxjump ],[ly+lyjump; ly+lyjump],'--') ;   
       plot([lx ;lx+lxjump ],[ly; ly],'-.') ;
       plot([lx ;lx+lxjump ],[ly-lyjump; ly-lyjump],':') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:4),'LineWidth',2) ;
 
      hold off;


end    
displength = num2str(x_length);    
disp('***************************************************************');
disp(['*      The length of the signal used =  '  displength '      *']);
disp('*                Basis used:     Symmlet 8                    *');
disp('*    Threshold Scale chosen to minimize risk in each case     *');
disp('***************************************************************');
%ax=axes('Units','Normal','Position',[0,0,1,0.2],'Visible','off',...
%'FontSize',8);
%legend('-','Hard lambdaD','--','Soft lambdaD','-.','Soft lambdaMO',...
%':','Raw Y');

 
disp('creating postscript file') ;
  orient tall ;
print -dps PapFig11.ps ;
  
