%  Matlab script PapFig13.m
%  J. S. Marron's modification of Sudeshna Adak's script RiskFig13.m
%
%  Designed to be run as a single script, and to print an output file.
%

global x_use x_length x_name sigchoice  
global fig_hand3 PlotFig global x_fft x_haar x_symm x_coif x_daub x_noise
global x_tmp signal_name
 
RiskInit ;
fig_hand3 = figure(1) ;
clf ;
 
viewvec = [-3,-1.5,7] ;

 
sigchoice = zeros(1,10); sigchoice(2) = 1;sigchoice(4) = 1;
%fig_hand3 = figure;
        set( fig_hand3, 'Name', 'Paper Figure 13', ...
             'units','normal','position',[0.2,0.5,(2/3)*1.1,(2/3)*0.8],...
             'PaperUnits','normalized','PaperPosition',...
              [0.0,0,1.0,1.0],'PaperOrientation','landscape');
disp('***  This produces Figure 13 of the Paper ***');
lambdMO = [1.47391  1.66865 1.85982 2.04748 2.23203 2.41405 ...
           2.59427 2.77343 2.95218 3.13093 3.30975];
% Minimax Optimal lamda derived in Donoho-Johnstone, Biometrika 94
x_length = 1024;
n0 = 2.^(6:12);
for i = 1:length(n0),
    if x_length == n0(i)
      lambdMO = lambdMO(i);
    end
    if any(x_length == n0) == 0
      disp('Do not know lambda-MO for this length of signal');
    end
end
la = log2(lambdMO/sqrt(2*log(x_length)));


%figure(fig_hand3);clg;orient landscape;     
      nplot = sum(sigchoice);
b = 1:10; b = b(sigchoice == 1);
  for i = 1:nplot,
    Gen_signal(b(i),'No');
   x_symm = FWT_PO(x_tmp,0,MakeONFilter('Symmlet',8));
   [x_symm_risk_low,u_symm] = ...
      CalcThreshValueRisk(x_symm,x_length,0.02,'Soft');
   [x_symm_risk_high,u_symm] = ...
      CalcThreshValueRisk(x_symm,x_length,0.1,'Soft');
      Scale = 0:log2(x_length);
ymin = min(Scale); ymax = max(Scale);
zmin = min(min(x_symm_risk_low));zmax=max(max(x_symm_risk_low));
figure(fig_hand3);


   subplot(nplot,2,(2*(i-1)+1)),
      mesh(u_symm,Scale,x_symm_risk_low');
      hold on;v = axis;
      axis([min(u_symm) max(u_symm) min(Scale) max(Scale) zmin zmax]);
line([0 0],[ymin ymax],[zmin zmin],'LineStyle',':')
line([0 0],[ymin ymax],[zmax zmax],'LineStyle',':')
line([0 0],[ymin ymin],[zmin zmax],'LineStyle',':')
line([0 0],[ymax ymax],[zmin zmax],'LineStyle',':')
line([la la],[ymin ymax],[zmin zmin],'LineStyle',':')
line([la la],[ymin ymax],[zmax zmax],'LineStyle',':')
line([la la],[ymin ymin],[zmin zmax],'LineStyle',':')
line([la la],[ymax ymax],[zmin zmax],'LineStyle',':')
[temp,j0] = min(min(x_symm_risk_low));
[temp,i0] = min(min(x_symm_risk_low'));
x0 = u_symm(i0); y0 = Scale(j0);
line([x0 x0],[y0 y0],[zmin zmax],'LineStyle','--');
    vhand = get(gca,'Children') ;
    set(vhand(1),'LineWidth',2) ;
    set(vhand(2:9),'LineWidth',1) ;
 
      xlabel('log2(lam/sqrt(2log(n)))');
      ylabel('Threshold Scale');
      zlabel('log10(Risk)');
titlestr = ...
['#' num2str(b(i)) '  ' signal_name ':  sigma = 0.02'];
      title(titlestr);
      hold off;
zmin = min(min(x_symm_risk_high));zmax=max(max(x_symm_risk_high));
  view(viewvec) ;


   subplot(nplot,2,(2*(i-1)+2)),
      mesh(u_symm,Scale,x_symm_risk_high');
      hold on;v = axis;
      axis([min(u_symm) max(u_symm) min(Scale) max(Scale) zmin zmax]);
line([0 0],[ymin ymax],[zmin zmin],'LineStyle',':')
line([0 0],[ymin ymax],[zmax zmax],'LineStyle',':')
line([0 0],[ymin ymin],[zmin zmax],'LineStyle',':')
line([0 0],[ymax ymax],[zmin zmax],'LineStyle',':')
line([la la],[ymin ymax],[zmin zmin],'LineStyle',':')
line([la la],[ymin ymax],[zmax zmax],'LineStyle',':')
line([la la],[ymin ymin],[zmin zmax],'LineStyle',':')
line([la la],[ymax ymax],[zmin zmax],'LineStyle',':')
[temp,j0] = min(min(x_symm_risk_high));
[temp,i0] = min(min(x_symm_risk_high'));
x0 = u_symm(i0); y0 = Scale(j0);
line([x0 x0],[y0 y0],[zmin zmax],'LineStyle','--');
    vhand = get(gca,'Children') ;
    set(vhand(1),'LineWidth',2) ;
    set(vhand(2:9),'LineWidth',1) ;
 
      xlabel('log2(lam/sqrt(2log(n)))');
      ylabel('Threshold Scale');
      zlabel('log10(Risk)');
titlestr = ...
['#' num2str(b(i)) '  ' signal_name ':  sigma = 0.1'];
      title(titlestr);
  view(viewvec) ;

      hold off;
end   
displength = num2str(x_length);
disp('***************************************************************');
disp(['*      The length of the signal used =  '  displength '      *']);
disp('*           Basis used : Symmlet 8                            *');
disp('*        Type of Thresholding:  Soft                          *');
disp('***************************************************************');

 
disp('creating postscript file') ;
  orient landscape ;
print -dps PapFig13.ps ;
  
