%  Mtatlab script PapFig2.m
%  J. S. Marron's modification of Sudeshna Adak's script RiskFig2.m
%
%  Designed to be run as a single script, and to print an output file.
%

global x_use x_length x_name sigchoice  
global fig_hand1 PlotFig global x_fft x_haar x_symm x_coif x_daub x_noise
global x_tmp signal_name
 
RiskInit ;
fig_hand1 = figure(1) ;
clf ;
 
%   fig_hand1 = figure;
        set( fig_hand1, 'Name', 'Paper Figure 2',...
             'units','normal','position',[0.3,0.4,(2/3)*1.1,(2/3)*0.85],...
             'PaperUnits','normalized','PaperPosition',...
              [0.0,0.1,1.0,0.85],'PaperOrientation','landscape');
    sigchoice = zeros(1,10);
    sigchoice(1) = 1;sigchoice(8) = 1;sigchoice(10) = 1;
disp('**** This produces Fig. 2 of paper ****');

nplot = sum(sigchoice);
b = 1:10; b = b(sigchoice == 1);
  for i = 1:nplot,
    Gen_signal(b(i),'No');
    figure(fig_hand1);


       x_fft = fft(x_tmp)/(sqrt(x_length));
       x_fft2 = x_fft(1:x_length/2);
subplot(nplot,4,(4*(i-1)+3)),
       plot(linspace(0,1,x_length/2),log10(abs(x_fft2)+eps));
       ylabel('log10(Abs(Coeffs))');
       titlestr = ['#' num2str(b(i)) ' ' signal_name ':  Fourier'];
       title(titlestr);
       axis([0, 1, -5, 1]) ;


       x_haar = FWT_PO(x_tmp,0,MakeONFilter('Haar'));
subplot(nplot,4,(4*(i-1)+1)),

%  now insert some lines copied out of PlotWaveCoeff.m,
%  modifed to create the image plot:

     wc = x_haar ;
     wavecoef = reshape(wc,1,length(wc));
        [n,J] = dyadlength(wavecoef);
        mimag = [] ;
        L = 0 ;
        for j=(J-1):-1:L
          vcoeff = wavecoef(dyad(j)) ;
          vcoeff = kron(vcoeff,ones(1,2^(J-1-j))) ;
          mimag = [mimag; vcoeff] ;
        end

        mimag = log10(abs(mimag) + 10^(-12)) ;
          minmimag = min(min(mimag)) ;
          maxmimag = max(max(mimag)) ;
        mimag = (mimag - minmimag) / (maxmimag - minmimag) ;
          %  linearly map mimag to [0,1]
        mimag = ceil(256 * mimag) ;
          %  map mimag to integers 1-256

       mimag = flipud(mimag) ;
          %  put so coarser scales are at top

        colormap(gray(256)) ;
        image(linspace(0,1,128),0:7,mimag) ; 
           titlestr = ['#' num2str(b(i)) ' ' signal_name ':  Haar'];
           title(titlestr);
           ylabel('j') ;


       x_symm = FWT_PO(x_tmp,0,MakeONFilter('Symmlet',8));
subplot(nplot,4,(4*(i-1)+2)),

%  now insert some lines copied out of PlotWaveCoeff.m,
%  modifed to create the image plot:

     wc = x_symm ;
     wavecoef = reshape(wc,1,length(wc));
        [n,J] = dyadlength(wavecoef);
        mimag = [] ;
        L = 0 ;
        for j=(J-1):-1:L
          vcoeff = wavecoef(dyad(j)) ;
          vcoeff = kron(vcoeff,ones(1,2^(J-1-j))) ;
          mimag = [mimag; vcoeff] ;
        end

        mimag = log10(abs(mimag) + 10^(-12)) ;
          minmimag = min(min(mimag)) ;
          maxmimag = max(max(mimag)) ;
        mimag = (mimag - minmimag) / (maxmimag - minmimag) ;
          %  linearly map mimag to [0,1]
        mimag = ceil(256 * mimag) ;
          %  map mimag to integers 1-256

       mimag = flipud(mimag) ;
          %  put so coarser scales are at top

        colormap(gray(256)) ;
        image(linspace(0,1,128),0:7,mimag) ; 
           titlestr = ['#' num2str(b(i)) ' ' signal_name ':  Symmlet 8'];
           title(titlestr);
           ylabel('j') ;



       x_fft = fliplr(sort(log10(abs(x_fft)+eps)));
       x_haar = fliplr(sort(log10(abs(x_haar)+eps)));
       x_symm = fliplr(sort(log10(abs(x_symm)+eps)));
       ymax = max([max(x_fft) max(x_haar) max(x_symm)]);
       ymin = min([min(x_fft) min(x_haar) min(x_symm)]);
subplot(nplot,4,(4*(i-1)+4)),plot(linspace(0,1,x_length),x_fft,'-.');
       hold on;
       plot(linspace(0,1,x_length),x_haar);
       plot(linspace(0,1,x_length),x_symm,'--');
       y1 = ymax-0.2*(ymax-ymin);
       title(['Sorted Spectra']);
       hold off;
       axis([0, 1, -5, 1]) ;

       %  add legend with line types
       vax = axis ;
       lx = vax(1) + .3 * (vax(2) - vax(1)) ;
       ly = vax(3) + .7 * (vax(4) - vax(3)) ;
       lxjump = 0.3 * (vax(2) - vax(1)) ;
       lyjump = .1 * (vax(4) - vax(3)) ;
       text(lx+1.2*lxjump,ly+2*lyjump,'Haar') ;      
       text(lx+1.2*lxjump,ly+lyjump,'Symm8') ;      
       text(lx+1.2*lxjump,ly,'Fourier') ;      
       hold on ;
         plot([lx ;lx+lxjump ],[ly+2*lyjump; ly+2*lyjump],'-') ;
         plot([lx ;lx+lxjump ],[ly+lyjump; ly+lyjump],'--') ;
         plot([lx ;lx+lxjump ],[ly; ly],'-.') ;
       hold off ;


  end

%ax=axes('Units','Normal','Position',[0,0,1,0.1],'Visible','off',...
%'FontSize',8);
%legend('-','Haar','--','Symm8','-.','Fourier',-1);
 

disp('creating postscript file') ;
  orient landscape ;
print -dps PapFig2.ps ;
  
