%  Matlab script PapFig3.m
%  J. S. Marron's modification of Sudeshna Adak's script RiskFig3.m
%
%  Designed to be run as a single script, and to print an output file.
%

global x_use x_length x_name sigchoice  
global fig_hand2 PlotFig global x_fft x_haar x_symm x_coif x_daub x_noise
global x_tmp signal_name
 
RiskInit ;
fig_hand2 = figure(1) ;
clf ;
 
%fig_hand2 = figure;
        set( fig_hand2, 'Name', 'Power Remaining',...
            'units','normal','position',[0.3,0.4,(2/3)*1.1,(2/3)*0.85],...
             'PaperUnits','normalized','PaperPosition',...
              [0.0,0.1,1.0,0.85],'PaperOrientation','landscape');
   sigchoice = zeros(1,10);sigchoice(1) = 1;
signal_name = 'Step'; x_name = 'Step';
nvec = 4.^(3:6);
disp('**** This produces Fig. 3 of paper ****');
       for i = 1:length(nvec) 
          x_length = nvec(i);
          n = x_length;
    n = 2^fix(log2(n));        % Generates dyadic length signal
    t = (1:n) ./n;
x_tmp = 0.2 + 0.6*(t > 1/3 & t <= 0.75); 
          x_fft = fft(x_tmp)/(sqrt(x_length));
[x_fft_risk_low,x_fft_risk_high,x_av_low,x_av_high,x_fft_asb] = ...
               CalcProjRisk(x_fft,nvec(i));
          x_haar = FWT_PO(x_tmp,0,MakeONFilter('Haar'));
[x_haar_risk_low,x_haar_risk_high,x_av_low,x_av_high,x_haar_asb] = ...
               CalcProjRisk(x_haar,nvec(i));     
          x_symm = FWT_PO(x_tmp,0,MakeONFilter('Symmlet',8));
[x_symm_risk_low,x_symm_risk_high,x_av_low,x_av_high,x_symm_asb] = ...
               CalcProjRisk(x_symm,nvec(i));
ymin = min([min(x_fft_risk_low) min(x_fft_risk_high) ...
            min(x_av_low) min(x_av_high) ...
            min(x_haar_risk_low) min(x_haar_risk_high) ...
            min(x_symm_risk_low) min(x_symm_risk_high)]);
ymax =  max([max(x_fft_risk_low) max(x_fft_risk_high) ...
            max(x_av_low) max(x_av_high) ...
            max(x_haar_risk_low) max(x_haar_risk_high) ...
            max(x_symm_risk_low) max(x_symm_risk_high)]); 
figure(fig_hand2);
lognocoeff = log2(1:nvec(i));
subplot(2,2,i),plot(lognocoeff,x_haar_risk_low,'g');hold on;
  vchand = get(gca,'Children') ;
  set(vchand(1),'LineWidth',2) ;
v = axis;axis([0 log2(max(nvec)) -8 0]);
plot(lognocoeff,x_haar_risk_high,'r');
  vchand = get(gca,'Children') ;
  set(vchand(1),'LineWidth',2) ;
plot(lognocoeff,x_haar_asb);
plot(lognocoeff,x_symm_risk_low,'g--');
  vchand = get(gca,'Children') ;
  set(vchand(1),'LineWidth',2) ;
plot(lognocoeff,x_symm_risk_high,'r--');
  vchand = get(gca,'Children') ;
  set(vchand(1),'LineWidth',2) ;
plot(lognocoeff,x_symm_asb,'--');
plot(lognocoeff,x_fft_risk_low,'g-.');
  vchand = get(gca,'Children') ;
  set(vchand(1),'LineWidth',2) ;
plot(lognocoeff,x_fft_risk_high,'r-.');
  vchand = get(gca,'Children') ;
  set(vchand(1),'LineWidth',2) ;
plot(lognocoeff,x_fft_asb,'-.');
plot(lognocoeff,x_av_low,'g:');
plot(lognocoeff,x_av_high,'r:');
hold off;
xlabel('log2(No. of terms in projection)');
ylabel('log10(Ro)');
titlestr = ['# 1' '  ' signal_name ':  n = ' num2str(nvec(i))];
title(titlestr);

if i == 1 ;    %  Then add explanatory stuff
%  ax=axes('Units','Normal','Position',[0,0,1.0,0.2],'Visible','off',...
%  'FontSize',8);
%  legend(':','AV','-','Haar','--','Symmlet 8','-.','Fourier',-1);

       %  lines from PapFig2.m
       vax = axis ;
         lx = vax(1) + .55 * (vax(2) - vax(1)) ;
         ly = vax(3) + .7 * (vax(4) - vax(3)) ;
         lxjump = 0.2 * (vax(2) - vax(1)) ;
         lyjump = .1 * (vax(4) - vax(3)) ;
       text(lx+1.2*lxjump,ly+2*lyjump,'Haar') ;
       text(lx+1.2*lxjump,ly+lyjump,'Symm8') ;
       text(lx+1.2*lxjump,ly,'Fourier') ;
       text(lx+1.2*lxjump,ly-5*lyjump,'Avg Var') ;
       text(lx+0.25*lxjump,ly-6*lyjump,'(bold)     Avg S B') ;
         nx = vax(1) + .02 * (vax(2) - vax(1)) ;
         ny1 = vax(3) + .6 * (vax(4) - vax(3)) ;
         ny2 = vax(3) + .33 * (vax(4) - vax(3)) ;
       text(nx,ny1,'High') ;
       text(nx,ny2,'Low') ;
       hold on ;
         plot([lx ;lx+lxjump ],[ly+2*lyjump; ly+2*lyjump],'-') ;
         plot([lx ;lx+lxjump ],[ly+lyjump; ly+lyjump],'--') ;
         plot([lx ;lx+lxjump ],[ly; ly],'-.') ;
         plot([lx ;lx+lxjump ],[ly-5*lyjump; ly-5*lyjump],':') ;
       hold off ;


end ;


      end


 
disp('creating postscript file') ;
  orient landscape ;
print -dps PapFig3.ps ;
  
