%  Matlab script PapFig6.m
%  J. S. Marron's modification of Sudeshna Adak's script RiskFig6.m
%
%  Designed to be run as a single script, and to print an output file.
%

global x_use x_length x_name sigchoice  
global fig_hand3 PlotFig global x_fft x_haar x_symm x_coif x_daub x_noise
global x_tmp signal_name
 
RiskInit ;
fig_hand3 = figure(1) ;
clf ;
 
%fig_hand3 = figure;
        set( fig_hand3, 'Name', 'Paper Figure 6', ...
             'units','normal','position',[0.5,0.2,(2/3)*0.8,(2/3)*1.1],...
             'PaperUnits','normalized','PaperPosition',...
             [0.0,0,1.0,1.0],'PaperOrientation','landscape');
disp('***  This produces Figure 6 of the Paper ***');
x0 = log2(x_length/2);
pr_length = x_length;
x_length = 1024;
sigchoice = zeros(1,10); sigchoice(1) = 1;sigchoice(2) = 1;
sigchoice(8) = 1;
      nplot = sum(sigchoice);
b = 1:10; b = b(sigchoice == 1);
  for i = 1:nplot,
    Gen_signal(b(i),'No');
    figure(fig_hand3);
   x_haar = FWT_PO(x_tmp,0,MakeONFilter('Haar'));
   x_symm = FWT_PO(x_tmp,0,MakeONFilter('Symmlet',8));
   x_fft = fft(x_tmp)/(sqrt(x_length));
   x_fft2 = [real(x_fft(1:(x_length/2))) imag(x_fft(1:(x_length/2)))];
   [x_fft_ideal_low,x_raw_low,x_fft_risk_low] = ...
      CalcThreshScaleRisk(x_fft2,x_length,0.02);
   [x_fft_ideal_high,x_raw_high,x_fft_risk_high] = ...
      CalcThreshScaleRisk(x_fft2,x_length,0.1);
   [x_haar_ideal_low,x_raw_low,x_haar_risk_low] = ...
      CalcThreshScaleRisk(x_haar,x_length,0.02);
   [x_haar_ideal_high,x_raw_high,x_haar_risk_high] = ...
      CalcThreshScaleRisk(x_haar,x_length,0.1);
   [x_symm_ideal_low,x_raw_low,x_symm_risk_low] = ...
      CalcThreshScaleRisk(x_symm,x_length,0.02);
   [x_symm_ideal_high,x_raw_high,x_symm_risk_high] = ...
      CalcThreshScaleRisk(x_symm,x_length,0.1);
      Scale = 0:log2(x_length);


   subplot(nplot,2,(2*(i-1)+1)),
      plot(Scale,x_haar_risk_low,'g');
      hold on;v = axis;axis([min(Scale) max(Scale) -2.5 1.5]);
      plot(Scale,x_haar_ideal_low);
      plot(Scale,x_symm_risk_low,'g--');
      plot(Scale,x_symm_ideal_low,'--');
      plot(Scale,x_raw_low,'g:');
      plot(Scale,x_fft_risk_low,'g-.');
        vhand = get(gca,'Children') ;
        set(vhand([1 2 4 6]),'LineWidth',2) ;
      plot(Scale,x_fft_ideal_low,'-.');
      xlabel('Threshold Scale');ylabel('log10(Risk)');
titlestr = ['#' num2str(b(i)) '  ' signal_name ':  sigma = 0.02'];
      title(titlestr);

       %  lines from PapFig2.m  
       vax = axis ;
         lx = vax(1) + .6 * (vax(2) - vax(1)) ;
         ly = vax(3) + .81 * (vax(4) - vax(3)) ;
         lxjump = 0.2 * (vax(2) - vax(1)) ;
         lyjump = .07 * (vax(4) - vax(3)) ;
       text(lx+1.2*lxjump,ly+2*lyjump,'Haar') ;
       text(lx+1.2*lxjump,ly+lyjump,'Symm8') ;
       text(lx+1.2*lxjump,ly,'Fourier') ;
       text(lx+1.2*lxjump,ly-lyjump,'Raw Y') ;
         nx = vax(1) + .1 * (vax(2) - vax(1)) ;
         ny = vax(3) + .93 * (vax(4) - vax(3)) ;
       text(nx,ny,'thin for Ideal Risk') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:5),'FontSize',8) ;
       plot([lx ;lx+lxjump ],[ly+2*lyjump; ly+2*lyjump],'-') ;
       plot([lx ;lx+lxjump ],[ly+lyjump; ly+lyjump],'--') ;
       plot([lx ;lx+lxjump ],[ly; ly],'-.') ;
       plot([lx ;lx+lxjump ],[ly-lyjump; ly-lyjump],':') ;  
         vhand = get(gca,'Children') ;
         set(vhand(1:4),'LineWidth',2) ;
 
      hold off;


   subplot(nplot,2,(2*(i-1)+2)),
      plot(Scale,x_haar_risk_high,'r');
      hold on;v = axis;axis([min(Scale) max(Scale) -2.5 1.5]);
      plot(Scale,x_haar_ideal_high);
      plot(Scale,x_symm_risk_high,'r--');
      plot(Scale,x_symm_ideal_high,'--');
      plot(Scale,x_raw_high,'r:');
      plot(Scale,x_fft_risk_high,'r-.');
        vhand = get(gca,'Children') ;
        set(vhand([1 2 4 6]),'LineWidth',2) ;
      plot(Scale,x_fft_ideal_high,'-.');
      xlabel('Threshold Scale');ylabel('log10(Risk)');
titlestr = ['#' num2str(b(i)) '  ' signal_name ':  sigma = 0.1'];
      title(titlestr);

       %  lines from PapFig2.m
       vax = axis ;
         lx = vax(1) + .6 * (vax(2) - vax(1)) ;
         ly = vax(3) + .11 * (vax(4) - vax(3)) ;
         lxjump = 0.2 * (vax(2) - vax(1)) ;
         lyjump = .07 * (vax(4) - vax(3)) ;
       text(lx+1.2*lxjump,ly+2*lyjump,'Haar') ;
       text(lx+1.2*lxjump,ly+lyjump,'Symm8') ;   
       text(lx+1.2*lxjump,ly,'Fourier') ;
       text(lx+1.2*lxjump,ly-lyjump,'Raw Y') ;
         nx = vax(1) + .1 * (vax(2) - vax(1)) ;
         ny = vax(3) + .07 * (vax(4) - vax(3)) ;   
       text(nx,ny,'thin for Ideal Risk') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:5),'FontSize',8) ;
       plot([lx ;lx+lxjump ],[ly+2*lyjump; ly+2*lyjump],'-') ;
       plot([lx ;lx+lxjump ],[ly+lyjump; ly+lyjump],'--') ;
       plot([lx ;lx+lxjump ],[ly; ly],'-.') ;
       plot([lx ;lx+lxjump ],[ly-lyjump; ly-lyjump],':') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:4),'LineWidth',2) ;

      hold off;


end    

displength = num2str(x_length);     
disp('***************************************************************');
disp(['*      The length of the signal used =  '  displength '      *']);
disp('*        Type of Thresholding:  Hard  with sqrt(2log(n))      *');
disp('***************************************************************'); 
%ax=axes('Units','Normal','Position',[0,0,1,0.2],'Visible','off',...
%'FontSize',8);
%legend(':','Raw Y','-','Haar','--','Symm8','-.','Fourier',0);

 
disp('creating postscript file') ;
  orient tall ;
print -dps PapFig6.ps ;
  
