%  Matlab script PapFig9.m
%  J. S. Marron's modification of Sudeshna Adak's script RiskFig9.m
%
%  Designed to be run as a single script, and to print an output file.
%

global x_use x_length x_name sigchoice  fig_hand3 PlotFig
global x_fft x_haar x_symm x_coif x_daub x_noise Signals____entries
global x_tmp signal_name
disp('********************************************************************');
disp('*     Hello: This is going to take about 10 minutes                  *');
disp('*     Wait till then to look at the plot                           *');
disp('********************************************************************');
 
RiskInit ;
fig_hand3 = figure(1) ;
clf ;
 
%fig_hand3 = figure;
        set( fig_hand3, 'Name', 'Paper Figure 9', ...
             'units','normal','position',[0.5,0.2,(2/3)*0.8,(2/3)*1.1],...
             'PaperUnits','normalized','PaperPosition',...
             [0.0,0,1.0,1.0],'PaperOrientation','landscape');
disp('***  This produces Figure 9 of the Paper ***');
clg;orient landscape;
nvec = 2.^(6:14);
sigchoice = zeros(1,10); sigchoice(4) = 1;sigchoice(3) = 1;
sigchoice(8) = 1;
      nplot = sum(sigchoice);
b = 1:10; b = b(sigchoice == 1);
  for i = 1:nplot,
   x_name = deblank(Signals____entries(b(i),:));
    figure(fig_hand3);
   [x_haar_ideal_low,x_haar_risk_low] = ...
      CalcSamplesizeRisk(nvec,x_name,'Haar',0.02);
   [x_haar_ideal_high,x_haar_risk_high] = ...
      CalcSamplesizeRisk(nvec,x_name,'Haar',0.1);
   [x_symm_ideal_low,x_symm_risk_low] = ...
      CalcSamplesizeRisk(nvec,x_name,'Symmlet 8',0.02);
   [x_symm_ideal_high,x_symm_risk_high] = ...
      CalcSamplesizeRisk(nvec,x_name,'Symmlet 8',0.1);
   [x_fft_ideal_low,x_fft_risk_low] = ...
      CalcSamplesizeRisk(nvec,x_name,'Fourier',0.02);
   [x_fft_ideal_high,x_fft_risk_high] = ...
      CalcSamplesizeRisk(nvec,x_name,'Fourier',0.1);
      Size = log2(nvec);
ymin = min([min(x_haar_ideal_low) min(x_haar_risk_low) ...
      min(x_haar_ideal_high) min(x_haar_risk_high) ...
      min(x_symm_ideal_low) min(x_symm_risk_low) ...
      min(x_symm_ideal_high) min(x_symm_risk_high)]);
ymax = max([max(x_haar_ideal_low) max(x_haar_risk_low) ...
      max(x_haar_ideal_high) max(x_haar_risk_high) ...
      max(x_symm_ideal_low) max(x_symm_risk_low) ...
      max(x_symm_ideal_high) max(x_symm_risk_high)]);
delta = 0.05*(ymax-ymin);
figure(fig_hand3);


%   subplot(nplot,2,(2*(i-1)+1)),
   if i == 1 ;
     subplot(3,2,3) ;
   elseif i == 2 ;   
     subplot(3,2,1) ;
   elseif i == 3 ;   
     subplot(3,2,5) ;
   end ;
      plot(Size,x_haar_risk_low,'g');
      hold on;v = axis;axis([min(Size) max(Size) (ymin-delta) (ymax+delta)]);
      plot(Size,x_haar_ideal_low);
      plot(Size,x_symm_risk_low,'g--');
      plot(Size,x_symm_ideal_low,'--');
      plot(Size,x_fft_risk_low,'g-.');
      plot(Size,x_fft_ideal_low,'-.');
         vhand = get(gca,'Children') ;
        set(vhand([2 4 6]),'LineWidth',2) ;
     xlabel('log2(n)');ylabel('log10(Risk)');
titlestr = ['#' num2str(b(i)) ' ' signal_name ':  sigma = 0.02'];
      title(titlestr);

       %  lines from PapFig6.m
       vax = axis ;
         lx = vax(1) + .6 * (vax(2) - vax(1)) ;
         ly = vax(3) + .81 * (vax(4) - vax(3)) ;
         lxjump = 0.2 * (vax(2) - vax(1)) ;
         lyjump = .07 * (vax(4) - vax(3)) ;
       text(lx+1.2*lxjump,ly+2*lyjump,'Haar') ;
       text(lx+1.2*lxjump,ly+lyjump,'Symm8') ;
       text(lx+1.2*lxjump,ly,'Fourier') ;
         nx = vax(1) + .1 * (vax(2) - vax(1)) ;
         ny = vax(3) + .93 * (vax(4) - vax(3)) ;
       text(nx,ny,'thin for Ideal Risk') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:4),'FontSize',8) ;
       plot([lx ;lx+lxjump ],[ly+2*lyjump; ly+2*lyjump],'-') ;
       plot([lx ;lx+lxjump ],[ly+lyjump; ly+lyjump],'--') ;
       plot([lx ;lx+lxjump ],[ly; ly],'-.') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:3),'LineWidth',2) ;

      hold off;


%   subplot(nplot,2,(2*(i-1)+2)),
   if i == 1 ;
     subplot(3,2,4) ;
   elseif i == 2 ;   
     subplot(3,2,2) ;
   elseif i == 3 ;   
     subplot(3,2,6) ;
   end ;
      plot(Size,x_haar_risk_high,'r');
      hold on;v = axis;axis([min(Size) max(Size) (ymin-delta) (ymax+delta)]);
      plot(Size,x_haar_ideal_high);
      plot(Size,x_symm_risk_high,'r--');
      plot(Size,x_symm_ideal_high,'--');
      plot(Size,x_fft_risk_high,'r-.');
      plot(Size,x_fft_ideal_high,'-.');
         vhand = get(gca,'Children') ;
        set(vhand([2 4 6]),'LineWidth',2) ;
      xlabel('log2(n)');ylabel('log10(Risk)');
titlestr = ['#' num2str(b(i)) ' ' signal_name ':  sigma = 0.1'];
      title(titlestr);

       %  lines from PapFig6.m
       vax = axis ;
         lx = vax(1) + .6 * (vax(2) - vax(1)) ;
         ly = vax(3) + .11 * (vax(4) - vax(3)) ;
         lxjump = 0.2 * (vax(2) - vax(1)) ;
         lyjump = .07 * (vax(4) - vax(3)) ;
       text(lx+1.2*lxjump,ly+2*lyjump,'Haar') ;
       text(lx+1.2*lxjump,ly+lyjump,'Symm8') ; 
       text(lx+1.2*lxjump,ly,'Fourier') ;
         nx = vax(1) + .1 * (vax(2) - vax(1)) ;
         ny = vax(3) + .07 * (vax(4) - vax(3)) ;
       text(nx,ny,'thin for Ideal Risk') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:4),'FontSize',8) ;
       plot([lx ;lx+lxjump ],[ly+2*lyjump; ly+2*lyjump],'-') ;
       plot([lx ;lx+lxjump ],[ly+lyjump; ly+lyjump],'--') ;   
       plot([lx ;lx+lxjump ],[ly; ly],'-.') ;
         vhand = get(gca,'Children') ;
         set(vhand(1:3),'LineWidth',2) ;
         
      hold off;
 
      hold off;


end      
disp('***************************************************************');
disp('*        Type of Thresholding:  Hard  with sqrt(2log(n))      *');
disp('*    Threshold Scale chosen to minimize risk in each case     *');
disp('***************************************************************');    
%ax=axes('Units','Normal','Position',[0,0,1,0.2],'Visible','off',...
%'FontSize',8);
%legend('-','Haar','--','Symm8','-.','Fourier');


 
disp('creating postscript file') ;
  orient tall ;
print -dps PapFig9.ps ;
  
