disp('Running MATLAB script file EgMatlabKDE.m') ;
    %  First line write to the screen which script file this is
%
%    Illustrates use of Matlab to construct Kernel Density Estimates
%    for the Hidalgo Stamp Thickness Data
    %  Recall anything after a "%" is a "comment",
    %      i.e. a reminder about what is happening


ipart = 1 ;     %  1  Load data, and do simplest analysis
                %  2  Analysis with more fancy titles, etc.
                %  3  Explore multiple window widths
    %  this structure allows trying several things,
    %  and keeping a record of all of them



%  Load the data
%
vdata = load('stamp.txt') ;
    %  this loads the data into the vector "vdata"

vdata
    %  use this to check the load process,
    %  by writing this vector to the screen



figure(1) ;
    %  This will be the "Figure Window" to the front
    %  each time this script is run
clf ;
    %  This clears everything in the figure window



if ipart == 1 ;    %  Simplest Default Analysis


  kdeSM(vdata) ;
      %  This is a "bare bones" version,
      %  already suggest 7 sources for the paper



elseif ipart == 2 ;    %  Put in Fancy titles, etc.


  paramstruct = struct('titlestr','Hidalgo Stamp Thickness Data', ...
                       'titlefontsize',18, ...
                       'xlabelstr','Thickness (mm)', ...
                       'ylabelstr','density', ...
                       'labelfontsize',15, ...
                       'ndataoverlay',2) ;
      %  this was copied and adapted from ">> help kdeSM"
      %  ndataoverlay adds "jitter plot"
      %  Idea add random component to "spread data out"
      %  Note:  can see heavy "data rounding"
      %  Also clear from looking at data file

  kdeSM(vdata,paramstruct) ;
      %  here many things have been added



elseif ipart == 3 ;    %  Explore multiple window widths


  paramstruct = struct('titlestr','Hidalgo Stamp Thickness Data', ...
                       'titlefontsize',18, ...
                       'xlabelstr','Thickness (mm)', ...
                       'ylabelstr','density', ...
                       'labelfontsize',15, ...
                       'ndataoverlay',2, ...
                       'vh',[0.0004, 0.0012, 0.0036], ...
                       'linecolor','') ;
      %  the window width is indicated by "h",
      %  "vh" is for "vector of h's"
      %  Note clearly "undersmoothed", "about right" and "oversmoothed"
      %  these were found after substantial trial and error
      %  "linecolor" = '' allows different colors

  kdeSM(vdata,paramstruct) ;
      %  here many things have been added



end ;

