disp(['Running MATLAB script SimpleDataEG.m']) ;
%
%    This does very simple analyses of favorite data sets


ipart = 1 ;    %  1 get mean, sd, and % of way through data for mean


idat = 2 ;     %  1 - Incomes, 1975 (unnormalized)
               %  2 - Response sizes, 2001, Thurs. afternoon


if idat == 1 ;

  dtitstr = 'Incomes' ;
  infstr = '\Research\GeneralData\hpstuff\j75.ein' ;
  frmtstr = '%g' ;
  nincol = 1 ;    %  read in data as 1 column
  vsavind = 1 ;   %  save only first input column
  xstr = 'Normalized Income' ;
  ystr = 'density' ;
  dcomments = 'Family Incomes from the UK, 1975, n = 7201' ;

elseif idat == 2 ;

  dtitstr = 'HTTPsize' ;
  infstr = '\Research\NetworkData\ResponseSize\DataUNC2001\20010426_1300.rsps.txt' ;
  frmtstr = '%g' ;
  nincol = 3 ;    %  read in data as 3 columns
  vsavind = 1 ;   %  save only first input column
  xstr = 'HTTP Sizes' ;
  ystr = 'density' ;
  dcomments = 'HTTP Responses Sizes, n = 6,870,022' ;

end ;    %  of idat if-block




%  Do main read
%
disp(['    Loading ' dtitstr ' Data']) ;
  fid = fopen(infstr,'r') ;

  data = fscanf(fid,frmtstr,[nincol, inf]) ;
        %  main data read
  data = data' ;

  data = data(:,vsavind) ;
        %  keep only desired columns

  fclose(fid) ;

disp(['    Read in ' num2str(length(data)) ' data points']) ;



if ipart == 1 ;

  meandat = mean(data) ;
  mediandat = median(data) ;
  sddat = std(data) ;
  pbtm = cprobSM(data,meandat) ;

  disp(' ') ;
  disp(['  Mean of data is: ' num2str(meandat)]) ;

  disp(' ') ;
  disp(['  Median of data is: ' num2str(mediandat)]) ;

  disp(' ') ;
  disp(['  % of data smaller than mean is: ' num2str(100 * pbtm)]) ;

  disp(' ') ;
  disp(['  Standard deviation of data is: ' num2str(sddat)]) ;

  disp(' ') ;
  disp(['  Mean - S.D. is: ' num2str(meandat - sddat)]) ;

  disp(' ') ;
  disp(['  Mean - 2 S.D. is: ' num2str(meandat - 2 * sddat)]) ;


end ;    %  of ipart if-block
