disp('Running MATLAB script file ToyBoxPlots.m') ;
%
%    Makes Box Plots for some data sets

idata = 4 ;     %  1  Stat31Eg16, Make Female Poll Results
                %  2  Study Index Data
                %  3  Incomes Data
                %  4  Internet traffic????


figure(1) ;
clf ;


if idata == 1 ;

  pstr = 'BoxPlotStat32MF' ;

  titstr = 'UNC Male - Female Sampling' ;
  xlabelstr = 'Question Number' ;
  ylabelstr = 'Fraction Males' ;
  cellXTickLabel = {'Q1';'Q2';'Q3';'Q4'} ;

  mdata = load('Stat31Eg16Raw.csv') ;
  mdata = mdata(:,5:8) ;


elseif idata == 2 ;

  pstr = 'BoxPlotStudyHabInd' ;

  titstr = 'Study Habits Kindex' ;
  xlabelstr = '' ;
  ylabelstr = 'Index' ;
  cellXTickLabel = {'Females';'Males'} ;

  titstr = 'Study Habits Index' ;

  mdata = load('StudyHabitsIndexData.csv') ;

  mdata(19:20,1) = [NaN; NaN] ;

  mdata


elseif idata == 3 ;

  pstr = 'BoxPlotIncomes' ;

  titstr = 'Family Incomes, Great Britain, 1975' ;
  xlabelstr = '' ;
  ylabelstr = 'Income' ;
  cellXTickLabel = {''} ;

  load('\Research\GeneralData\incomes.mat') ;

  mdata = data ;


elseif idata == 4 ;

  pstr = 'BoxPlotIntConnSize' ;

  titstr = 'HTTP Response Sizes, Thursday Afternoon' ;
  xlabelstr = '' ;
  ylabelstr = 'Response Size (bytes)' ;
  cellXTickLabel = {''} ;

  mdata = load('D:\Research\NetworkData\ResponseSize\DataUNC2001\20010426_1300.rsps.txt') ;

  mdata = mdata(:,1) ;


end ;    %  of idata if-block




boxplot(mdata) ;
  title(titstr) ;
  xlabel(xlabelstr) ;
  ylabel(ylabelstr) ;
  set(gca,'XTickLabel',cellXTickLabel) ;



%  orient landscape ;
%print('-dpsc', [pstr '.ps']) ;

  set(gcf,'PaperSize',[4.5,5.5]) ;
  set(gcf,'PaperPosition',[.25,1,4,3.5]) ;
print('-djpeg', [pstr '.jpg']) ;



