%  MATLAB SCRIPT s322e16a.m, DOES PSRT 1 OF s322eg16.m,
%  INTERACTIVE BOX COX TRANSFORMATION EXAMPLE

%  START BY CLEARING WINDOW, AND REDRAWING (JUST COPIED THESE LINES)
%  STUFF FROM s322eg16 
figure(1) ;
clf ;
          %  THIS CLEAR OF THE FIGURE WINDOW IS IMPORTANT IF THE
          %  OTHER BUTTON HAS ALREADY BEEN PUSHED.
mainh = uicontrol(gcf,'Style','frame',...
               'Position',[50 200 400 150]) ; 

pushb1 = uicontrol(gcf,'Style','push','Position',[60 280 380 60],...
              'String','Push here for Interactive Box-Cox Transformation',...
              'CallBack','s322e16a ;') ;

pushb2 = uicontrol(gcf,'Style','push','Position',[60 210 380 60],...
              'String','Push here for Interactive Leverage in Regression',...
              'CallBack','s322e16c ;') ;



%  GENERATE DATA, AND SET INITIAL STUFF
  rand('seed',29840923) ;
xdatu = rand(50,1) ;
xdat = xdatu.^2 ;
          %  PUT X'S THROUGH SQUARE TRANSFORM
  randn('seed',78987234) ;
  sig = .05 ;
ydat = .1 + xdatu + sig * randn(50,1) ;
          %  TRY PUTTING JUST xdat HERE, AND SEE HOW THINGS CHANGE
ydat = 1 ./ ydat ;
          %  PUT Y'S THROUGH EXPONENTIAL TRANSFORM

%  STARTING (DEFAULT) VALUES FOR THE TRANSFORMATION PARAMETERS
lamx = 1 ;
lamy = 1 ;

%  DEFINE ENDPOINTS FOR THE SLIDERS
lamxmin = -2 ;
lamxmax = 3 ;
lamymin = -2 ;
lamymax = 3 ;


%  A FIRST CALL TO s322e16b, TO GET INITIAL PLOTS IN FIGURE WINDOW #2
s322e16b ;


%  NOW SETUP SLIDERS IN FIGURE WINDOW #1

%  HERE IS THE lamx SLIDER
sli1h = uicontrol(figure(1),'Style','slider',...
            'Position',[100 120 275 25],...
            'Min',lamxmin,'Max',lamxmax,'Value',lamx,...
            'CallBack',['lamx = get(sli1h,''Value'') ; s322e16b ;', ...
                'set(sli1tith,''String'',[''Lambda_x = '' num2str(lamx)])']) ;
                     %  "Min" AND "Max" ARE ENDPOINTS OF THE SLIDER RANGE

                     %  CALLBACK FIRST READS THE VALUE OFF THE SLIDER, 
                     %  INTO MEMORY, THEN REDRAWS THE GRAPHICS
                     %  FINALLY WRITES THE CURRENT VALUE OF THE SLIDER
                     %  INTO THE TITLE FOR THAT SLIDER

%  NEXT COME THE TEXT LABELS FOR THE lamx SLIDER
sli1tith = uicontrol(figure(1),'Style','text',...
            'Position',[165 150 140 15],...
            'String',['Lambda_x = ' num2str(lamx)]) ;
          %  THE MAIN LABEL FOR lamx
sli1minh = uicontrol(figure(1),'Style','text',...
            'Position',[75 125 20 15],...
            'String',num2str(lamxmin)) ;
          %  THE LABEL FOR lamx LOWER END
sli1minh = uicontrol(figure(1),'Style','text',...
            'Position',[380 125 20 15],...
            'String',num2str(lamxmax)) ;
          %  THE LABEL FOR lamx UPPER END


%  HERE IS THE lamy SLIDER
sli2h = uicontrol(figure(1),'Style','slider',...
            'Position',[100 40 275 25],...
            'Min',lamymin,'Max',lamymax,'Value',lamy,...
            'CallBack',['lamy = get(sli2h,''Value'') ; s322e16b ;', ...
                'set(sli2tith,''String'',[''Lambda_y = '' num2str(lamy)])']) ;
%  NEXT COME THE TEXT LABELS FOR THE lamy SLIDER
sli2tith = uicontrol(figure(1),'Style','text',...
            'Position',[165 70 140 15],...
            'String',['Lambda_y = ' num2str(lamy)]) ;
          %  THE MAIN LABEL FOR lamy
sli2minh = uicontrol(figure(1),'Style','text',...
            'Position',[75 45 20 15],...
            'String',num2str(lamymin)) ;
          %  THE LABEL FOR lamy LOWER END
sli2minh = uicontrol(figure(1),'Style','text',...
            'Position',[380 45 20 15],...
            'String',num2str(lamymax)) ;
          %  THE LABEL FOR lamy UPPER END

