%  MATLAB SCRIPT s322e16c.m, DOES PART 2 OF s322eg16.m,
%  INTERACTICE LEVERAGE IN LINEAR REGRESSION EXAMPLE

%  START BY CLEARING WINDOW, AND REDRAWING STUFF FROM s322eg16:
figure(1) ;
clf ;
          %  THIS CLEAR OF THE FIGURE WINDOW IS IMPORTANT IF THE
          %  OTHER BUTTON HAS ALREADY BEEN PUSHED.
mainh = uicontrol(gcf,'Style','frame',...
               'Position',[50 200 400 150]) ; 

pushb1 = uicontrol(gcf,'Style','push','Position',[60 280 380 60],...
              'String','Push here for Interactive Box-Cox Transformation',...
              'CallBack','s322e16a ;') ;

pushb2 = uicontrol(gcf,'Style','push','Position',[60 210 380 60],...
              'String','Push here for Interactive Leverage in Regression',...
              'CallBack','s322e16c ;') ;



%  GENERATE DATA, AND SET INITIAL STUFF
  nobs = 10 ;
  rand('seed',29840923) ;
xdat = rand(nobs,1) ;
  rand('seed',78987234) ;
  sig = .05 ;
ydat = .5 * xdat + sig * randn(nobs,1) ;
          %  DATA NEAR LINE WITH SLOPE 1/2, THROUGH THE ORIGIN

voutl = [.5, .25] ;
          %  STARTING VALUE FOR AN "OUTLIER" TO BE BE ADDED 
          %  INTO THE DATA SET

symstr = 'o';
          %  START WITH CIRCLE AS DEFAULT SYMBOL FOR OUTLIER
osymth = .5 ;
          %  START WITH USUAL DEFAULT SYMBOL LINE THICKNESS
osymsize = 6 ;
          %  START WITH USUAL DEFAULT SYMBOL MARKER SIZE
otext = [] ;
          %  LABEL FOR OUTLIER, INITIALLY NO LABEL


%  A FIRST CALL TO s322e16d, TO CALCULATE LINEAR REGRESSION, AND MAKE
%  INITIAL VERSION OF THE PLOTS IN FIGURE WINDOW #2
s322e16d ;


%  NOW ADD PART WHERE MOUSE CLICK MOVES POINT IN FIGURE WINDOW #2.
set(gcf,'WindowButtonUpFcn',[...
     'voutl = get(gca,''CurrentPoint'') ;'...
     's322e16d ;']) ;
          %  "WindowButtonUpFcn" IS A STRING OF COMMANDS TO EXECUTE 
          %  WHENEVER THE MOUSE BUTTON IS PUSHED DOWN (E.G. "CLICKED")

          %  "CurrentPoint GIVES THE COORDINATES WHERE THE MOUSE IS 
          %  CURRENTLY POINTING

          %  FINALLY RECOMPUTE THE LINEAR REGRESSION (WITH THE NEW 
          %  OUTLIER), AND REDRAW THE PLOT
     

%  FINALLY ADD "MENU", "CHECKBOX" AND "EDITABLE TEXT" TO FIGURE 1
menuh = uimenu(figure(1),'Label','Outlier Opt''s') ;
          %  CREATES A MENU IN THE BAR THAT THE TOP OF THE MENU
  symmenuh = uimenu(menuh,'Label','Outlier Symbol') ;
          %  ENTRY IN MAIN MENU, WHICH POINTS TO SUBMENU FOR "SYMBOL"
    circleh = uimenu(symmenuh,'Label','Circle',...
                     'CallBack','symstr = ''o'';') ;
          %  PART OF SYMBOL SUBMENU, FOR CIRCLE     
          %    PUTS THE CHARACTER FOR "CIRCLE" IN THIS STRING
    starh = uimenu(symmenuh,'Label','Star',...
                     'CallBack','symstr = ''*'';') ;
          %  PART OF SYMBOL SUBMENU, FOR CIRCLE     
          %    PUTS THE CHARACTER FOR "STAR" IN THIS STRING
    xmarkh = uimenu(symmenuh,'Label','X-mark',...
                     'CallBack','symstr = ''x'';') ;
          %  PART OF SYMBOL SUBMENU, FOR CIRCLE     
          %    PUTS THE CHARACTER FOR "X-MARK" IN THIS STRING
  thmenuh = uimenu(menuh,'Label','Outlier Thickness') ;
          %  ENTRY IN MAIN MENU, WHICH POINTS TO SUBMENU FOR "THICKNESS"
    regthh = uimenu(thmenuh,'Label','Regular',...
                     'CallBack','osymth = .5 ;') ;
          %  PART OF THICKNESS SUBMENU, FOR USUAL THICKNESS     
          %    SETS THIS VARIABLE TO THE DEFAULT LINE THICKNESS
    fatthh = uimenu(thmenuh,'Label','Fat',...
                     'CallBack','osymth = 2.0 ;') ;
          %  PART OF THICKNESS SUBMENU, FOR EXTRA FAT LINE THICKNESS     
          %    SETS THIS VARIABLE TO AN EXTRA FAT LINE THICKNESS


%  CREATE A "CHECKBOX" IN THE LOWER PART OF FIGURE 1
chkboxh = uicontrol(figure(1),'Style','checkbox',...
                    'Position',[120 120 160 30],...
                    'String','Make Symbol Large',...
                    'CallBack',['osymsize = 6 ;',...
                                'if get(chkboxh,''Value'') == 1 ;'...
                                    'osymsize = 18 ;',...
                                 'end ;']) ;
          %  "String" IS THE LABEL FOR THE CHECKBOX

          %  CALLBACK FIRST SETS osymsize TO THE DEFAULT MARKER SIZE,
          %  THEN IF THE BOX IS CHECKED, IT CHANGES osymsize TO
          %  THE LARGER SIZE


etexth = uicontrol(figure(1),'Style','Text',...
                    'Position',[120 70 240 20],...
                    'String','Type a Label for the Outlier in this Box:') ;
          %  THIS CREATES SOME TEXT, TO TELL WHAT THE BELOW 
          %  "EDITABLE TEXT" IS ABOUT     

etexth = uicontrol(figure(1),'Style','Edit',...
                    'Position',[160 40 160 25],...
                    'CallBack','otext = get(etexth,''String'') ;') ;
          %  THIS CREATES AN "EDITABLE TEXT WINDOW", WHERE THE USER
          %  CAN TYPE IN INFO, ETC.


          %  NOTE THAT THESE LAST TWO COMMANDS DON'T HAVE A VISIBLE 
          %  VISIBLE EFFECT, UNTIL THE NEXT TIME THE OUTLIER IS MOVED
          %  AND THUS s322e16d.m IS CALLED AGAIN.  IF IT WERE IMPORTANT
          %  TO GET THESE BACK RIGHT AWAY, s322e16d.m SHOULD BE CALLED
          %  IN THESE "CALLBACK" STRINGS.

