%  MATLAB FUNCTION s322e16d.m, USED BY s322e16c.m
%  TO DO LINEAR FIT, AND PLOT, TOGETHER WITH DATA,
%  FOR INTERACTIVE LEVERAGE IN REGRESSION EXAMPLE
%  FROM s322eg16.m


%  DRAW EVERYTHING INTO FIGURE WINDOW#2
figure(2) ;
clf
          %  THIS CLEAR GETS RID OF ANY STUFF FROM OTHER PART

%  FIND LEAST SQUARES FIT LINE TO ALL OF DATA (INCLUDING OUTLIER)
xall = [xdat; voutl(1,1)] ;
yall = [ydat; voutl(1,2)] ;
          %  ATTACH OUTLIER TO REST OF DATA
x = [ones(length(xall),1) xall] ;
          %  USUAL LEAST SQUARES DESIGN MATRIX
betahat = inv(x' * x) * x' * yall ;
          %  USUAL LEAST SQUARES PARAMETER ESTIMATE
yline = x * betahat ;
          %  LEAST SQUARES FIT LINE, EVALUATED AT DATA POINTS


%  MAKE PLOT
  oscstr = [symstr 'r'] ;
          %  OUTLIER SYMBOL AND COLOR STRING,
          %  SYMBOL STRING WAS SET BY PROGRAMS THAT CALL THIS ONE
          %  SO IT CAN BE INTERACTIVELY ADJUSTED
plot(xdat,ydat,'+y',voutl(1,1),voutl(1,2),oscstr,xall,yline,'-b') ;
          %  "ORDINARY DATA"   - YELLOW PLUSSES
          %  "OUTLIER"         - SYMBOL ADJUSTED INTERACTIVELY
          %  "REGRESSION LINE" - BLUE SOLID LINE
  axis([0, 3, 0, 2]) ;
          %  MAKE MUCH BIGGER THAN NEEDED, TO HAVE PLENTY OF SCOPE
          %  FOR MOVING OUTLIER AROUND
  title('Click the mouse at a new location for the circle') ;
  
          %  ADJUST OUTLIER SYMBOL THICKNESS AND SIZE
  vcurveh = get(gca,'Children') ;
  set(vcurveh(2),'LineWidth',osymth) ;
          %  EARLIER CHECKED THAT 2ND ENTRY CORRESPONDED TO OUTLIER
  set(vcurveh(2),'MarkerSize',osymsize) ;
          %  HERE IS HOW SIZE IS CHANGED INTERACTIVELY

          %  ADD LABEL FOR OUTLIER
  if length(otext) > 1 ;
          %  IF THERE IS A NONEMPTY STRING
    text(voutl(1,1)+.1,voutl(1,2),otext) ;
  end ;
