%MATLAB SCRIPT FILE s322eg8.m  */
%
%    EXAMPLE 8 FOR STATISTICS 322
%    POSTED 9/26/96
%    EXPLORES MORE GRAPHICS

disp(['Running MATLAB script s322eg8.m' 10]) ;

%  FUNCTIONS CAN BE TRICKY TO PLOT WHEN THEY HAVE "A LOT OF 
%  STRUCTURE".  AN EXAMPLE IS IN THE MATLAB SCRIPT FILE s322EG8f.m
%  (THIS IS POSTED SO YOU CAN TRY IT YOURSELF, NOTE IT IS 
%  UNCOMMENTED AND THUS VERY HARD TO READ).
%  HERE IS ONE PLOT OF IT:

figure(1) ;
          %  THIS SAYS PUT NEXT PLOT IN THE WINDOW "FIGURE 1"
          %  IT ALSO APPEARS TO PULL THE PLOT TO THE "FOREGROUND"
          %  ON MY VERSION OF MATLAB 
  ngrid = 40 ;
  xgrid = linspace(0,1,ngrid) ;
plot(xgrid,s322eg8f(xgrid)) ;
          %  THIS LOOKS TERRIBLE BECAUSE THE GRID IS "TOO COARSE"
  title(['s322eg8f plotted with ' num2str(ngrid) ' points']) ;


disp('Hit any key to see a "higher resolution version"') ;
pause ;
          %  IT IS MOST COMFORTABLE TO LOOK AT THESE WITH BOTH THE 
          %  THE COMMAND WINDOW, AND ALSO THE FIGURE 1 WINDOW VISIBLE

figure(2) ;
          %  THIS CREATES A 2ND WINDOW IN WHICH TO PUT STUFF, TRY 
          %  MOVING IT AROUND, AND RESIZING IT, SO YOU CAN LOOK AT 
          %  BOTH SIMULTANEOUSLY
  ngrid = 298 ;
          %  REASON FOR THIS STRANGE NUMBER WILL BECOME APPARENT LATER
  hrxgrid = linspace(0,1,ngrid) ;
          %  THIS IS A HIGHER RESOLUTION VERSION
plot(hrxgrid,s322eg8f(hrxgrid),xgrid,s322eg8f(xgrid),':') ;
          %  THIS SHOWS THE CURVE A LOT BETTER, BECAUSE THERE ARE
          %  MORE GRID POINTS, BUT IN "HIGHER FREQENCY LOCATIONS"
          %  THERE ARE SOME ODD "HARMONIC EFFECTS" CREATED BY THE 
          %  "TOO SPARSE" SAMPLING.
          %  THE LOWER RESOLUTION CURVE IS OVERLAID, TO SHOW HOW IT 
          %  A "COARSE EVALUATION".  IT IS GOOD TO KEEP IN MIND 
          %  THAT ALL COMPUTER GENERATED PLOTS ARE SIMPLY EVALUATIONS
          %  OF THIS TYPE (OF SOME UNDERLYING "CONTINUOUS CURVE"),
          %  AND THE "RESOLUTION LEVEL" CAN BE IMPORTANT.
  title(['s322eg8f plotted with ' num2str(ngrid) ' points']) ;


disp('Hit any key to see the "fplot" version') ;
pause ;

figure(1) ;
          %  THIS NOW "RE-USES" OLD WINDOW
fplot('s322eg8f',[0,1]) ;
          %  THIS IS A SOPHISTICATED MATLAB FEATURE THAT TAKES A 
          %  "FUNCTION AS AN ARGUMENT" (ACTUALLY AS A STRING 
          %  CONTAINING THE NAME OF THE FUNCTION), AND THEN GENERATES
          %  A PLOT.  THE GRID IS VERY CLEVERLY CALCULATED, PUTTING 
          %  MORE POINTS WHERE THERE IS MORE CHANGE IN THE FUNCTION.
          %  [0,1] IS A ROW VECTOR WITH THE ENDPOINT OF THE INTERVAL
          %  WHERE THE FUNCTION IS TO BE EVALUATED.
          %  THIS RUNS QUITE A LOT SLOWER FOR ME, SUGGESTING THAT 
          %  THESE IS SOME PRETTY HEAVY DUTY CALCULATION GOING ON
          %  BUT THE TRADEOFF IS BETTER RESOLUTION OF THE DETAIL
          %  IN THIS FUNCTION
  title('s322eg8f plotted with "fplot"') ;


disp('Hit any key to do some analysis of what "fplot" did') ;
pause ;

[xfp,yfp] = fplot('s322eg8f',[0,1]) ;
          %  THIS GETS THE COORDINATES THAT fplot USES TO MAKE THE
          %  PLOT, AND SHOWS NO PLOT.

ngrid = max(size(xfp)) ;
          %  USE OF max MEANS THIS SHOWS THE NUMBER OF COMPONENTS
          %  FOR EITHER A ROW OR COLUMN VECTOR
disp(['xplot used a grid with ' num2str(ngrid) ' points']) ;
          %  THIS NUMBER WAS 298, WHICH IS WHY 298 WAS USED ABOVE,
          %  FOR A "FAIR COMPARISON".

figure(2) ;
          %  NOW REUSE THAT WINDOW
  del = 1 / (ngrid + 1) ;
plot(xfp,linspace(del,1-del,ngrid),[0,1],[0,1]) ;
          %  LAST PART OVERLAYS 45 DIAGONAL LINE
  title('P-P plot, showing "dist" used by fplot') ;
          %  THIS SHOWS HOW fplot USES A GREATER DENSITY OF GRID
          %  POINTS IN REGIONS WHERE MORE ARE USEFUL.  IN PARTICULAR:
          %  1.  ABOUT SAME DENSITY AS "EQUALLY SPACED" IN [0,.1],
          %          WHERE HAVE ROUGHLY "USUAL CURVE".
          %  2.  MORE DENSE WHERE OSCILLATIONS ARE MOST RAPID.
          %  3.  MOST SPARSE IN "FLAT" AREA.


  %  SOMETIMES IT IS USEFUL TO "ZOOM IN" ON A PICTURE, AND LOOK IN 
  %  MORE DETAIL, BECAUSE THE "PIXEL RESOLUTION" IS TOO COARSE.  
  %  WHEN YOU JUST WANT TO "LOOK YOURSELF", A GOOD WAY TO DO IT IS
  %  USING THE FOLLOWING ON THE COMMAND LINE.  TO SAVE YOU FROM
  %  HAVING TO TYPE IT, THIS IS WRITTEN SO THE RESULTS HAPPENS FROM 
  %  THE SCRIPT.
disp('Hit any key to see upper right zoom in Figure 2') ;
pause ;
figure(2) ;
  axis([.95 1 .95 1]) ;
          %  THIS IS THE ONLY COMMAND YOU NEED TO TYPE TO SO A ZOOM
          %  THE ENTRIES ARE "XMIN XMAX YMIN YMAX".
          %  TO REMEMBER THIS, NOTE THAT THIS IS THE FORM WHICH ALLOWS
          %  EASIEST UPDATING TO INCLUDE A Z COORDINATE.
          %  THIS SHOWS SOME STRUCTURE THAT WAS NOT VISIBLE
          %  IN THE MAIN PLOT

disp('Hit any key to see lower left zoom in Figure 2') ;
pause ;
  axis([0 .1 0 .1]) ;
          %  HERE ALSO IS SOME STRUCTURE NOT SO EASY TO SEE FROM
          %  THE MAIN PLOT


disp('Hit any key to see a dumb zoom in Figure 2') ;
pause ;
  axis([0 .1 .8 .95]) ;
          %  YOU DO NEED TO BE A LITTLE CAREFUL WITH WHERE YOU 
          %  CHOOSE TO ZOOM TOO!


disp('Hit any key to return to original axes in Figure 2') ;
pause ;
  axis('auto') ;
          %  AFTER A LOT OF ZOOMING AROUND, THIS COMMAND IS NICE FOR
          %  GETTING BACK TO WHERE WE WERE.


disp('Hit any key to do a zoom in Figure 1') ;
pause ;
figure(1) ;
  axis([.95 1 .98 1]) ;
          %  NOTE THAT EVEN fplot HAS LIMITS ON WHAT IT CAN HANDLE
          %  NICELY (WHICH CAN BE CONTROLLED, SEE THE MANUAL OR help).


%  WHEN MORE DETAIL IS NEEDED, THEN A RECALCULATION OF THE PLOT
%  IS REQUIRED.  HERE IS A NICE WAY TO DISPLAY THIS

disp('Hit any key to see a recalculated zoom') ;
pause ;
figure(1) ;
  axis('auto') ;
         %  FIRST RETURN TO FULL PICTURE
    xmin = .95 ;
    xmax = 1 ;
    ymin = .98 ;
    ymax = 1 ;
  hold on ;
    plot([xmin xmax xmax xmin xmin], [ymin ymin ymax ymax ymin],'c') ;
          %  THIS DRAWS A "BOX", CORNER BY CORNER, STARTING AT THE
          %  LOWER RIGHT, WHICH WILL SHOW WHERE THE ZOOMED PIECE 
          %  COMES FROM
  hold off ;

figure(2) ;
          %  NOW SWITCH OVER TO THE NEXT PICTURE, AND PUT THE NEW
          %  CALCULATION OF THE ZOOM THERE.
fplot('s322eg8f',[xmin xmax]) ;
  title('Detailed view of part in upper right box') ;
  axis([xmin xmax ymin ymax]) ;
           

disp('This one is over, hope you liked the pics!') ;
