function out = s322eg8f(x) 
% S322EG8F, Test function for Example 8 in Stat 322.
% Input:
%     x   - grid of input values, assumed to be a matrix, with
%                all values in [0,1]
% Output:
%     out - vector of example function evaluated at corresponding points

vx = x(:) ;
          %  LONG COLUMN VECTOR VERSION OF x
          %  (USEFUL FOR MANIPULATIONS DONE BELOW)

out = zeros(size(vx)) ;
          %  NOTE THIS AUTOMATICALLY GETS BOTH #ROWS AND #COLS
          %  ENTRIES OF THIS WILL BE "FILLED IN"


flaglth = (vx > 0) & (vx < (1/3)) ;
          %  1'S IN "LOWER THIRD" OF UNIT INTERVAL, "FLAGS" THOSE 
          %    FOR EASY ACCESS
xlth = vx(flaglth) ;
          %  FEEDING IN VECTOR OF 0'S AND 1'S GIVES JUST THOSE
          %  ENTRIES WITH 1/S
%out(flaglth) = xlth .* sin((6 * pi) ./ xlth) ;
  arg = xlth - (1/3) ;
out(flaglth) = (abs(arg)).^.5 .* cos(1 ./ arg) ;
          %  NOTE THIS FROM WILL BE UNDEFINED AT 0, SO LIM AS X --> 0
          %  IS DONE "SEPARATELY".


flaguth = (vx >= (2/3)) & (vx < 1) ;
          %  1'S IN "LOWER HALF" OF UNIT INTERVAL
xuth = vx(flaguth) ;
ltarg = cos(pi ./ (1 - xuth)) ;
          %  THE "LINEAR TRANFORMATION ARGUMENT", CURVE WILL BE A
          %  "SQUISHING" OF THIS BETWEEN A PARABOLA, AND THE LINE Y=1.
pofx = (1 - 9 * (xuth - 1).^2) ;
          %  THIS IS THE PARABOLA
out(flaguth) = 1 + ((1 - pofx)/2) .* (ltarg - 1) ;
          %  HERE IS THE POINTWISE MAPPING OF  [-1,1]  INTO THE RANGE
          %  [P(X),1], WHERE P(X) IS A PARABOLA.


flag1 = (vx == 1) ;
out(flag1) = ones(sum(flag1)) ;
          %  sum GIVES THE NUMBERS OF ONES TO CHANGE.

out = reshape(out,size(x)) ;
          %  FINALLY RESHAPE BACK TO DIMENSIONS OF x
