function coaipm
% COAIPM, Individual in Population Menu Generation for Cornean
%      Corneal Topography Analysis System
%   Creates a menu in the current Figure Window
%      Intended to be called by cornean.m
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina


%  Set up global variables
%
%  First some general globals
global R0 NMAX IBASIS IRECENT COMAP NRPT RMP RCP ;
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  IBASIS - 1 for full (triangle), 2 for radial (3 row)
%  IRECENT - To recenter (or not) decompositions
%  COMAP - Color Map
%  NRPT - Number of times to Repeat Movie
%  RMP - Robustness Mean Parameter
%  RCP - Robustness Covariance Parameter

global INFILESTR FEATMPATH LISTFILESTR SETLISTPATH LISTR ;
%  INFILESTR - string with input filename
%  FEATMPATH - path for storing Zernike feature matrices
%  LISTFILESTR - string with input name of file with list of filenames
%  SETLISTPATH - string to set path to lists
%  LISTR - string for inputting list file

global INDATPATH SUBDIRSTR ;
%  INDATPATH - path for input Keratron files
%  SUBDIRSTR - current subdirectory (of both indata and outputs)

global SCREENWD SCREENHT MENUWD ;
        % overall sizes of display area, generic menu width
global VERTGAP HORIZGAP TITLHT BUTTONHT
        %  generic sizes of objects on menus
%  Next the globals for handles to figure windows and plots
global IPMHANDPOS IPMHAND IPMETIHAND IPMETPHAND ;
%  IPMHANDPOS - Position coordinates for Indiv. in Population Menu
%  IPMHAND - handle for Figure Window with Indiv. in Population Menu
%  IPMETIHAND - handle for editable text, with input file prefix for Indiv.
%  IPMETPHAND - handle for editable text, with input file prefix for Pop'n
global IPCAHANDPOS 
%  IPCAHANDPOS - Position coordinates for Indiv. in PCA plot
global IPCAHAND ;
%  Handle for Indiv. in PC Analysis
global RFILESUF HFILESUF ;
%  File Suffixes for data files
global MIPMRADBUT1 MIPMRADBUT2 MIPMRADBUT3 ;
%  MIPMRADBUT1 - Mean Indiv. in Population Menu Radio Button 1
%  MIPMRADBUT2 - Mean Indiv. in Population Menu Radio Button 2
%  MIPMRADBUT3 - Mean Indiv. in Population Menu Radio Button 3
global CIPMRADBUT1 CIPMRADBUT2 CIPMRADBUT3 ;
%  CIPMRADBUT1 - Covariance Indiv. in Pop'n Menu Radio Button 1
%  CIPMRADBUT2 - Covariance Indiv. in Pop'n Menu Radio Button 2
%  CIPMRADBUT3 - Covariance Indiv. in Pop'n Menu Radio Button 3



%  Default Robustness Parameters
%
RMP = 0 ;
RCP = 0 ;




%  Create Individual in Population Menu window and set up basics
%
if isempty(IPMHAND) ;          %  then need a new window
  IPMHAND = figure ;
else ;                     %  then work with existing menu
  figure(IPMHAND) ;
end ;
clf ;
set(IPMHAND, 'NumberTitle', 'off');
set(IPMHAND,'Position', [IPMHANDPOS]) ;
set(IPMHAND,'Name','Ind. in Pop. Menu') ;





%  Create header
%
titly = IPMHANDPOS(4) - (TITLHT + VERTGAP) ;
          %  get y coord of starting point working down from top
titlwd = (MENUWD - 2 * HORIZGAP) ;
h1s = 'Corneal Topography Analysis System' ;
          %  string to display as header, window size was chosen 
          %  to make this split correctly
ipmh1hand = uicontrol(IPMHAND,'Style','text',...
            'Position',[HORIZGAP titly titlwd TITLHT],...
            'String',h1s, 'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);



%  Create Editable text, for entering individ. Keratron data filename prefix
%
t1s = 'Inidiv. Data File Prefix:' ;
          %  text to display in front of entry field
twd = IPMHANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .7 * twd ;
twd2 = .3 * twd ;
          %  respective parts for the label and editable text
ty = IPMHANDPOS(4) - (TITLHT + BUTTONHT + 2 * VERTGAP) ;
          %  get y coord of starting point working down from top
iamthand = uicontrol(IPMHAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s) ;
          %  Creation of text on Main menu, in front of entry field
IPMETIHAND = uicontrol(IPMHAND,'Style','Edit',...
                    'String',INFILESTR,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'CallBack',['INFILESTR = get(IPMETIHAND,''String'') ;',...
                    'eval(SETPATHSTR) ;']) ;
          %  User types text into window, and then global variable
          %  "INFILESTR" contains string with filename
          %  Note: "String" is just a starting default, known to be there



%  Create push button for "Individual Data File Directory"
%
buttony = IPMHANDPOS(4) - (TITLHT + 2 * BUTTONHT + 3 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
iamcbs1 = ['disp(''Contents of current "indata" subdirectory:'') ;' ...
           'eval([''dir '' INDATPATH SUBDIRSTR '' ;'']) ;'] ;
          %  Individual Analysis CallBack String 1: 
          %  shows contents of input data directory 
mmb1hand = uicontrol(IPMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','see Dir.',...
              'CallBack',iamcbs1) ;



%  Create push button for "Help"
%
buttonx = HORIZGAP + .7 * (MENUWD - 2 * HORIZGAP) ;
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
ipmcbs2 = ['disp(''      The field "Keratron Data File Prefix"'') ;'...
           'disp(''      needs to have the prefix of a file that '') ;'...
           'disp(''      is in the current "indata" directory '') ;'...
           'disp('' '') ;'] ;
          %  Individual Analysis CallBack String 1: 
          %  give some advice about file storage
mmb1hand = uicontrol(IPMHAND,'Style','push',...
              'Position',[buttonx buttony buttonwd BUTTONHT],...
              'String','Help',...
              'CallBack',ipmcbs2) ;



%  Create Editable text, for entering input List filename prefix
%
t1s = 'Pop''n File List Prefix:' ;
          %  text to display in front of entry field
twd = IPMHANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .7 * twd ;
twd2 = .3 * twd ;
          %  respective parts for the label and editable text
ty = IPMHANDPOS(4) - (TITLHT + 3 * BUTTONHT + 4 * VERTGAP) ;
          %  get y coord of starting point working down from top
ipmthand = uicontrol(IPMHAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s) ;
          %  Creation of text on Main menu, in front of entry field
IPMETPHAND = uicontrol(IPMHAND,'Style','Edit',...
                    'String',LISTFILESTR,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'CallBack',['LISTFILESTR = get(IPMETPHAND,''String'') ;',...
                    'eval(SETLISTPATH) ;']) ;
          %  User types text into window, and then global variable
          %  "LISTFILESTR" contains string with filename
          %  Note: "String" is just a starting default, known to be there



%  Create push button for "Input List File Directory"
%
buttony = IPMHANDPOS(4) - (TITLHT + 4 * BUTTONHT + 5 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
ipmcbs1 = ['disp(''Current List Files:'') ;'...
            'eval([''dir '' FEATMPATH SUBDIRSTR ''*.lst ;'']) ;'] ;
          %  Population Analysis CallBack String 1: 
          %  shows currently available list files
mmb1hand = uicontrol(IPMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','see Dir.',...
              'CallBack',ipmcbs1) ;



%  Create push button for "Help"
%
buttonx = HORIZGAP + .7 * (MENUWD - 2 * HORIZGAP) ;
buttonwd = .3 * (MENUWD - 2 * HORIZGAP) ;
          %  only use 30% of usual width
ipmcbs2 = ['disp(''      The field "Pop''''n File List Prefix:"'') ;'...
           'disp(''      needs to have the prefix of a file where '') ;'...
           'disp(''      ________.lst is in the "zfm" directory '') ;'...
           'disp('' '') ;'] ;
          %  Population Analysis CallBack String 1: 
          %  give some advice about file storage
mmb2hand = uicontrol(IPMHAND,'Style','push',...
              'Position',[buttonx buttony buttonwd BUTTONHT],...
              'String','Help',...
              'CallBack',ipmcbs2) ;




%  Create Radio buttons, controlling robustness of mean
%
buttony = IPMHANDPOS(4) - (TITLHT + 4 + 5 * BUTTONHT + 6 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd = .2 * twd ;
bgap = (.2 / 3) * twd ;
          %  respective parts for the left and right buttons
%  First set text part
MRadioButtonText = uicontrol(IPMHAND,...
          'Style','text',...
          'String','Center:',...
          'Position',[HORIZGAP buttony bwd BUTTONHT]) ;
%  First radio button
MIPMRADBUT1 = uicontrol(IPMHAND,...
          'Style','radio',...
          'String','Mean',...
          'Value',1,...
          'Position',[(HORIZGAP+bwd+bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(MIPMRADBUT1,''Value'',1),'...
               'set(MIPMRADBUT2,''Value'',0),'...
               'set(MIPMRADBUT3,''Value'',0),'...
               'RMP = 0 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Second Radio Button
MIPMRADBUT2 = uicontrol(IPMHAND,...
          'Style','radio',...
          'String','S. L1',...
          'Position',[(HORIZGAP+2*bwd+2*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(MIPMRADBUT1,''Value'',0),'...
               'set(MIPMRADBUT2,''Value'',1),'...
               'set(MIPMRADBUT3,''Value'',0),'...
               'RMP = 1 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Third Radio Button
MIPMRADBUT3 = uicontrol(IPMHAND,...
          'Style','radio',...
          'String','E. L1',...
          'Position',[(HORIZGAP+3*bwd+3*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(MIPMRADBUT1,''Value'',0),'...
               'set(MIPMRADBUT2,''Value'',0),'...
               'set(MIPMRADBUT3,''Value'',1),'...
               'RMP = 2 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"





%  Create Radio buttons, controlling robustness of covariance
%
buttony = IPMHANDPOS(4) - (TITLHT + 4 + 6 * BUTTONHT + 7 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd = .2 * twd ;
bgap = (.2 / 3) * twd ;
          %  respective parts for the left and right buttons
%  First set text part
CRadioButtonText = uicontrol(IPMHAND,...
          'Style','text',...
          'String','Scale:',...
          'Position',[HORIZGAP buttony bwd BUTTONHT]) ;
%  First radio button
CIPMRADBUT1 = uicontrol(IPMHAND,...
          'Style','radio',...
          'String','Covar.',...
          'Value',1,...
          'Position',[(HORIZGAP+bwd+bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(CIPMRADBUT1,''Value'',1),'...
               'set(CIPMRADBUT2,''Value'',0),'...
               'set(CIPMRADBUT3,''Value'',0),'...
               'RCP = 0 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Second Radio Button
CIPMRADBUT2 = uicontrol(IPMHAND,...
          'Style','radio',...
          'String','S. Cov.',...
          'Position',[(HORIZGAP+2*bwd+2*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(CIPMRADBUT1,''Value'',0),'...
               'set(CIPMRADBUT2,''Value'',1),'...
               'set(CIPMRADBUT3,''Value'',0),'...
               'RCP = 1 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Third Radio Button
CIPMRADBUT3 = uicontrol(IPMHAND,...
          'Style','radio',...
          'String','E. Cov.',...
          'Position',[(HORIZGAP+3*bwd+3*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(CIPMRADBUT1,''Value'',0),'...
               'set(CIPMRADBUT2,''Value'',0),'...
               'set(CIPMRADBUT3,''Value'',1),'...
               'RCP = 2 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"




%  Create push button for Individual in Population plot
%
buttony = IPMHANDPOS(4) - (TITLHT + 7 * BUTTONHT + 8 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
cbs1 = 'coaipca(RMP,RCP)' ;
          %  CallBack String 1: Calls coaipca.m, for
          %          individual in principal component analysis 
ipmb1hand = uicontrol(IPMHAND,'Style','push',...
              'Position',[HORIZGAP buttony twd BUTTONHT],...
              'String','Individual in PCA',...
              'CallBack',cbs1) ;
buttony = IPMHANDPOS(4) - (TITLHT + 8 * BUTTONHT + 9 * VERTGAP) ;
          %  get y coord of starting point working down from top
bgap = .2 * twd ;
bwd = twd - 2* bgap ;
cbs2 = 'coaipcap' ;
          %  CallBack String 2: Calls coaspcap.m, for making print of
          %          static principal component analysis 
ipmb2hand = uicontrol(IPMHAND,'Style','push',...
              'Position',[(HORIZGAP + bgap) buttony bwd BUTTONHT],...
              'String','Print (.ps)',...
              'CallBack',cbs2) ;




