function coapam
% COAPAM, Population Analysis Menu Generation for Cornean
%      Corneal Topography Analysis System
%   Creates a menu in the current Figure Window
%      Intended to be called by cornean.m
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina


%  Set up global variables
%
%  First some general globals
global R0 NMAX IBASIS IRECENT COMAP NRPT NRIF ;
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  IBASIS - 1 for full (triangle), 2 for radial (3 row)
%  IRECENT - To recenter (or not) decompositions
%  COMAP - Color Map
%  NRPT - Number of times to Repeat Movie
%  NRIF - Number of times to Repeat Individual Movie Frames
          %    (controls speed of .mpeg version)

global LISTFILESTR SETLISTPATH SETCLISTPATH LISTR ;
%  LISTFILESTR - string with input name of file with list of filenames
%  SETLISTPATH - string to set path to lists
%  SETCLISTPATH - string to set path to centered lists
%  LISTR - string for inputting list file


global IRECENT RMP RCP OUTPUTPATH ;
%  IRECENT - To recenter (or not) decompositions
%  RMP - Robustness Mean Parameter
%  RCP - Robustness Covariance Parameter
%  OUTPUTPATH - path for output, .ps files, .mpeg files

global SCREENWD SCREENHT MENUWD ;
        % overall sizes of display area, generic menu width
global VERTGAP HORIZGAP TITLHT BUTTONHT
        %  generic sizes of objects on menus

%  Next the path for file control
global FEATMPATH SUBDIRSTR ;
%  FEATMPATH - path for storing Zernike feature matrices
%  SUBDIRSTR - current subdirectory (of both indata and outputs)

%  Next the globals for handles to figure windows and plots
global PAMHAND PAMHANDPOS PAMETHAND VLWZRHAND ;
%  PAMHAND - handle for Figure Window with Individual Analysis Menu
%  PAMHANDPOS - Position coordinates for Individual Analysis Menu
%  PAMETHAND - handle for editable text, with input file prefix
%  VLWZRHAND - vector of handles for List-Wise Zernike Recon's

global DPCAHANDPOS DPCAM1POS DPCAM2POS DPCAM3POS DPCAM4POS SPCAHANDPOS ;
%  DPCAHANDPOS - Position coordinates for Movie Control Menu
%  DPCAM1POS - Position coordinates for PCA Movie 1
%  DPCAM2POS - Position coordinates for PCA Movie 2
%  DPCAM3POS - Position coordinates for PCA Movie 3
%  DPCAM4POS - Position coordinates for PCA Movie 4
%  SPCAHANDPOS - Position coordinates for Static PCA plot

global LWZRHANDPOS ;
%  LWZRHANDPOS - Position coordinates for List-Wise Zernike recons
global DPCAM1HAND DPCAM2HAND DPCAM3HAND DPCAM4HAND DLWRMOVHAND ;
        %  Handles for movie windows in Dynamic PC Analysis
        %  and Dynamic List Wsie Reconstruction
global SPCAHAND PCP1PHAND ;
        %  Handle for Static PC Analysis window
        %  Handle for Parallel Coordinate Plot Window
global DPCAM1 DPCAM2 DPCAM3 DPCAM4 DLWRM ;
        %  Movie matrices in Dynamic PC Analysis
        %  and Dynamic List Wsie Reconstruction
global RFILESUF HFILESUF ;
        %  File Suffixes for data files

global MPAMRADBUT1 MPAMRADBUT2 MPAMRADBUT3 ;
%  MPAMRADBUT1 - Mean Population Analysis Menu Radio Button 1
%  MPAMRADBUT2 - Mean Population Analysis Menu Radio Button 1
%  MPAMRADBUT3 - Mean Population Analysis Menu Radio Button 1

global CPAMRADBUT1 CPAMRADBUT2 CPAMRADBUT3 ;
%  CPAMRADBUT1 - Covariance Population Analysis Menu Radio Button 1
%  CPAMRADBUT2 - Covariance Population Analysis Menu Radio Button 1
%  CPAMRADBUT3 - Covariance Population Analysis Menu Radio Button 1



%  Default Robustness Parameters
%
RMP = 0 ;
RCP = 0 ;




%  Create Population Analysis Menu window and set up basics
%
if isempty(PAMHAND) ;          %  then need a new window
  PAMHAND = figure ;
else ;                     %  then work with existing menu
  figure(PAMHAND) ;
end ;
clf ;
set(PAMHAND, 'NumberTitle', 'off');
set(PAMHAND,'Position', [PAMHANDPOS]) ;
set(PAMHAND,'Name','Pop''n An. Menu') ;





%  Create header
%
titly = PAMHANDPOS(4) - (TITLHT + VERTGAP) ;
          %  get y coord of starting point working down from top
titlwd = (MENUWD - 2 * HORIZGAP) ;
h1s = 'Corneal Topography Analysis System' ;
          %  string to display as header, window size was chosen 
          %  to make this split correctly
pamh1hand = uicontrol(PAMHAND,'Style','text',...
            'Position',[HORIZGAP titly titlwd TITLHT],...
            'String',h1s, 'BackgroundColor', [0 0 0], ...
 	    'ForegroundColor', [0 1 1]);



%  Create Editable text, for entering input Keratron data filename prefix
%
t1s = 'File List Prefix:' ;
          %  text to display in front of entry field
twd = PAMHANDPOS(3) - 2 * HORIZGAP ;
          %  total width for this field
twd1 = .3 * twd ;
twd2 = .2 * twd ;
          %  respective parts for the label and editable text
ty = PAMHANDPOS(4) - (TITLHT + BUTTONHT + 2 * VERTGAP) ;
          %  get y coord of starting point working down from top
pamthand = uicontrol(PAMHAND,'Style','text',...
              'Position',[HORIZGAP ty twd1 BUTTONHT],...
              'String',t1s) ;
          %  Creation of text on Main menu, in front of entry field
PAMETHAND = uicontrol(PAMHAND,'Style','Edit',...
                    'String',LISTFILESTR,...
                    'Position',[(HORIZGAP + twd1) ty twd2 BUTTONHT],...
                    'CallBack',['LISTFILESTR = get(PAMETHAND,''String'') ;',...
                    'eval(SETLISTPATH) ;']) ;
          %  User types text into window, and then global variable
          %  "LISTFILESTR" contains string with filename
          %  Note: "String" is just a starting default, known to be there



%  Create push button for "See Directory"
%
buttony = ty ;
bwd1 = .55 * twd ;
bwd2 = .2 * twd ;
          %  only use 20% of usual width
pamcbs1 = ['disp(''Current (Uncentered) List Files:'') ;'...
            'eval([''dir '' FEATMPATH SUBDIRSTR ''*.lst ;'']) ;'...
            'disp(''Current (Centered) List Files:'') ;'...
            'eval([''dir '' FEATMPATH SUBDIRSTR ''*.cls ;'']) ;'] ;
          %  Population Analysis CallBack String 1: 
          %  shows currently available list files
mmb1hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[(HORIZGAP + bwd1) buttony bwd2 BUTTONHT],...
              'String','see Dir.',...
              'CallBack',pamcbs1) ;



%  Create push button for "Help"
%
bwd3 = .8 * twd ;
bwd4 = .2 * twd ;
buttonx = HORIZGAP + bwd3 ;
          %  only use 30% of usual width
pamcbs2 = ['disp(''      The field "File List Prefix:"'') ;'...
           'disp(''      needs to have the prefix of a file '') ;'...
           'disp(''      in the "zfm" directory, of the form: '') ;'...
           'disp(''      ________.lst when IRECENT = 0, '') ;'...
           'disp(''      ________.cls when IRECENT = 1. '') ;'...
           'disp(''      Value of IRECENT is controlled at'') ;'...
           'disp(''      Change Parameter Menu'') ;'...
           'disp('' '') ;'] ;
          %  Population Analysis CallBack String 1: 
          %  give some advice about file storage
mmb2hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[buttonx buttony bwd4 BUTTONHT],...
              'String','Help',...
              'CallBack',pamcbs2) ;



%  Create push button for "Go to Change Parameter Menu"
%
buttony = PAMHANDPOS(4) - (TITLHT + 2 * BUTTONHT + 3 * VERTGAP) ;
          %  get y coord of starting point working down from top
bgap = .15 * twd ;
bwd = .7 * twd ;
mmcbs6 = 'coacpm' ;
          %  Main Menu CallBack String 6: calls coacpm.m
mmb6hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[(HORIZGAP + bgap) buttony bwd BUTTONHT],...
              'String','Go to Parameter Change Menu',...
              'CallBack',mmcbs6) ;



%  Create push button for Listwise Zernike Decomposition
%
buttony = PAMHANDPOS(4) - (TITLHT + 3 * BUTTONHT + 4 * VERTGAP) ;
          %  get y coord of starting point working down from top
buttonwd = MENUWD - 2 * HORIZGAP ;
ddmcbs4 = 'coalwzd' ;
          %  CallBack String 4: Calls coalwzd.m, for
          %          list-wise Zernike Decomp.
pamb4hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony buttonwd BUTTONHT],...
              'String','Listwise Zernike Decomp.',...
              'CallBack',ddmcbs4) ;



% Put line between sections
%
ly = PAMHANDPOS(4) - (TITLHT + 2 + 3 * BUTTONHT + 5 * VERTGAP) ;
          %  get y coord of starting point working down from top
line1hand = uicontrol(PAMHAND,'Style','text',...
            'Position',[1 ly PAMHANDPOS(3) 2],...
            'BackgroundColor', [0 0 .5]) ;
           %  Create line between simple recon, and smoothed recon
%%--------------------------------------------------------------------




%  Create push button for static listwise recon. plot
%
buttony = PAMHANDPOS(4) - (TITLHT + 2 + 4 * BUTTONHT + 6 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd1 = .45 * twd ;
bgap = .1 * twd ;
bwd2 = .45 * twd ;
          %  respective parts for the left and right buttons
ddmcbs5 = 'coalwzr' ;
          %  CallBack String 5: Calls coalwzr.m, for
          %          static list-wise Zernike reconstruction
pamb5hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd1 BUTTONHT],...
              'String','Static Recons',...
              'CallBack',ddmcbs5) ;
ddmcbs6 = 'coalwzrp' ;
          %  CallBack String 6: Calls coalwrzp.m, for making print of
          %          static list-wise Zernike reconstruction
pamb6hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd2 BUTTONHT],...
              'String','Print (.ps)',...
              'CallBack',ddmcbs6) ;




%  Create push button for dynamic listwise recon. plot
%
buttony = PAMHANDPOS(4) - (TITLHT + 2 + 5 * BUTTONHT + 7 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd = .3 * twd ;
bgap = .05 * twd ;
ddmcbs7 = 'coadlwr' ;
          %  CallBack String 7: Calls coadlwr.m, for
          %          dynamic list-wise Zernike reconstruction
pamb7hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd BUTTONHT],...
              'String','Dynamic Recons',...
              'CallBack',ddmcbs7) ;
ddmcbs7h = ['  figure(DLWRMOVHAND) ;' ...
           '  colormap(COMAP) ;' ...
           '  movie(DLWRMOVHAND,DLWRM,NRPT) ;'] ;
          %  CallBack String 7 and a half:
          %          does rerun of last 
          %          movie of list-wise Zernike reconstruction
pamb7hhand = uicontrol(PAMHAND,'Style','push',...
              'Position',[(HORIZGAP+bwd+bgap) buttony bwd BUTTONHT],...
              'String','Rerun Last',...
              'CallBack',ddmcbs7h) ;
ddmcbs8 = 'coadlwrs' ;
          %  CallBack String 8: Calls coadlwrs.m, for doing mpeg save of
          %          movie of list-wise Zernike reconstruction
pamb8hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[(HORIZGAP+2*bwd+2*bgap) buttony bwd BUTTONHT],...
              'String','Save (.mpg)',...
              'CallBack',ddmcbs8) ;




%  Create push button for Parallel Coordinate plot
%
buttony = PAMHANDPOS(4) - (TITLHT + 2 + 6 * BUTTONHT + 8 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd1 = .45 * twd ;
bgap = .1 * twd ;
bwd2 = .45 * twd ;
          %  respective parts for the left and right buttons
ddmcbs9 = 'coa1ppcp' ;
          %  CallBack String 9: Calls coa1ppcp.m, for
          %          Parallel Coordinate Plots
pamb9hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd1 BUTTONHT],...
              'String','Parallel Coords',...
              'CallBack',ddmcbs9) ;
ddmcbs10 = 'coa1pcpp' ;
          %  CallBack String 10: Calls coa1pcpp.m, for doing Postscript print of
          %          Parallel Coordinate Plots
pamb10hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd2 BUTTONHT],...
              'String','Print (.ps)',...
              'CallBack',ddmcbs10) ;




% Put line between sections
%
ly = PAMHANDPOS(4) - (TITLHT + 4 + 6 * BUTTONHT + 9 * VERTGAP) ;
          %  get y coord of starting point working down from top
line2hand = uicontrol(PAMHAND,'Style','text',...
            'Position',[1 ly PAMHANDPOS(3) 2],...
            'BackgroundColor', [0 0 .5]) ;
           %  Create line between simple recon, and smoothed recon
%%--------------------------------------------------------------------





%  Create Radio buttons, controlling robustness of mean
%
buttony = PAMHANDPOS(4) - (TITLHT + 4 + 7 * BUTTONHT + 10 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd = .2 * twd ;
bgap = (.2 / 3) * twd ;
          %  respective parts for the left and right buttons
%  First set text part
MRadioButtonText = uicontrol(PAMHAND,...
          'Style','text',...
          'String','Center:',...
          'Position',[HORIZGAP buttony bwd BUTTONHT]) ;
%  First radio button
MPAMRADBUT1 = uicontrol(PAMHAND,...
          'Style','radio',...
          'String','Mean',...
          'Value',1,...
          'Position',[(HORIZGAP+bwd+bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(MPAMRADBUT1,''Value'',1),'...
               'set(MPAMRADBUT2,''Value'',0),'...
               'set(MPAMRADBUT3,''Value'',0),'...
               'RMP = 0 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Second Radio Button
MPAMRADBUT2 = uicontrol(PAMHAND,...
          'Style','radio',...
          'String','S. L1',...
          'Position',[(HORIZGAP+2*bwd+2*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(MPAMRADBUT1,''Value'',0),'...
               'set(MPAMRADBUT2,''Value'',1),'...
               'set(MPAMRADBUT3,''Value'',0),'...
               'RMP = 1 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Third Radio Button
MPAMRADBUT3 = uicontrol(PAMHAND,...
          'Style','radio',...
          'String','E. L1',...
          'Position',[(HORIZGAP+3*bwd+3*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(MPAMRADBUT1,''Value'',0),'...
               'set(MPAMRADBUT2,''Value'',0),'...
               'set(MPAMRADBUT3,''Value'',1),'...
               'RMP = 2 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"





%  Create Radio buttons, controlling robustness of covariance
%
buttony = PAMHANDPOS(4) - (TITLHT + 4 + 8 * BUTTONHT + 11 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd = .2 * twd ;
bgap = (.2 / 3) * twd ;
          %  respective parts for the left and right buttons
%  First set text part
CRadioButtonText = uicontrol(PAMHAND,...
          'Style','text',...
          'String','Scale:',...
          'Position',[HORIZGAP buttony bwd BUTTONHT]) ;
%  First radio button
CPAMRADBUT1 = uicontrol(PAMHAND,...
          'Style','radio',...
          'String','Covar.',...
          'Value',1,...
          'Position',[(HORIZGAP+bwd+bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(CPAMRADBUT1,''Value'',1),'...
               'set(CPAMRADBUT2,''Value'',0),'...
               'set(CPAMRADBUT3,''Value'',0),'...
               'RCP = 0 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Second Radio Button
CPAMRADBUT2 = uicontrol(PAMHAND,...
          'Style','radio',...
          'String','S. Cov.',...
          'Position',[(HORIZGAP+2*bwd+2*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(CPAMRADBUT1,''Value'',0),'...
               'set(CPAMRADBUT2,''Value'',1),'...
               'set(CPAMRADBUT3,''Value'',0),'...
               'RCP = 1 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"
%  Third Radio Button
CPAMRADBUT3 = uicontrol(PAMHAND,...
          'Style','radio',...
          'String','E. Cov.',...
          'Position',[(HORIZGAP+3*bwd+3*bgap) buttony bwd BUTTONHT],...
          'Callback',[...
               'set(CPAMRADBUT1,''Value'',0),'...
               'set(CPAMRADBUT2,''Value'',0),'...
               'set(CPAMRADBUT3,''Value'',1),'...
               'RCP = 2 ;']) ;
               %  Note this first resets all the radio buttons,
               %  then sets the global Robust Mean Parameter
          %  Value indicates which button is currently "pushed"





%  Create push button for Static PCA plot
%
buttony = PAMHANDPOS(4) - (TITLHT + 4 + 9 * BUTTONHT + 12 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd1 = .45 * twd ;
bgap = .1 * twd ;
bwd2 = .45 * twd ;
          %  respective parts for the left and right buttons
ddmcbs1 = 'coaspca(RMP,RCP)' ;
          %  CallBack String 1: Calls coaspca.m, for
          %          static principal component analysis 
pamb1hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd1 BUTTONHT],...
              'String','Static PCA',...
              'CallBack',ddmcbs1) ;
ddmcbs2 = 'coaspcap' ;
          %  CallBack String 2: Calls coaspcap.m, for making print of
          %          static principal component analysis 
pamb2hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd2 BUTTONHT],...
              'String','Print (.ps)',...
              'CallBack',ddmcbs2) ;


%  Create push button for Dynamic PCA plots
%
buttony = PAMHANDPOS(4) - (TITLHT + 4 + 10 * BUTTONHT + 13 * VERTGAP) ;
          %  get y coord of starting point working down from top
twd = MENUWD - 2 * HORIZGAP ;
          %  total width for this field
bwd1 = .45 * twd ;
bgap = .1 * twd ;
bwd2 = .45 * twd ;
          %  respective parts for the left and right buttons
ddmcbs3 = 'coadpca(RMP,RCP)' ;
          %  CallBack String 3: Calls coadpca.m, for
          %          dynamic principal component analysis 
pamb3hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[HORIZGAP buttony bwd1 BUTTONHT],...
              'String','Dynamic PCA',...
              'CallBack',ddmcbs3) ;
ddmcbs4 = 'coadpcas' ;
          %  CallBack String 4: Calls coadpcas.m, for saving
          %          dynamic principal component analysis 
          %          movies as mpeg files
pamb4hand = uicontrol(PAMHAND,'Style','push',...
              'Position',[(HORIZGAP+bwd1+bgap) buttony bwd2 BUTTONHT],...
              'String','Save (.mpg)',...
              'CallBack',ddmcbs4) ;

