function coapcdp
% COAPCDP, Does Draftsman's Plots from Analyses for 2 Populations
%      Corneal Topography Analysis System
%   Creates a laege size window with one page Draftsman's Plots
%      Intended to be called by coa2pm.m
%      Reads Data from PC2LOAD1 and PC2LOAD2
% Outputs:
%     Only graphics, in a new Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina



%  Set up global variables
%
global SPCAHANDPOS SPC2HAND ;
        %  window positioning vector,
        %  handle for Static PCA Window
global PC2STR PC2LOAD1 PC2LOAD2 ;
        %  PC2STR - String with title info for 2 population analyses
        %  PC2LOAD1 - 1st Population Loadings for 2 population analyses
        %  PC2LOAD2 - 2nd Population Loadings for 2 population analyses



if isempty(PC2STR) | isempty(PC2LOAD1) | isempty(PC2LOAD2) ;
          %  then give error message

  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Error from coapcdp.m:              !!!') ;
  disp('!!!   Not ready for Draftsman''s Plots   !!!') ;
  disp('!!!   Need to generate Data 1st          !!!') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;


else ;    %  Have data, so proceed with Draftsman's Plots

  n1 = size(PC2LOAD1,1) ;
  n2 = size(PC2LOAD2,1) ;


  %  Set up window page
  %
  SPC2HAND = figure ;
          %  create a new window
  set(SPC2HAND, 'NumberTitle', 'off');
  set(SPC2HAND,'Position', SPCAHANDPOS) ;
  set(SPC2HAND,'Name',['Draftsman''s Plot for ' PC2STR]) ;

  subplot(4,4,1) ;



  %  First work on diagonal, and put down same kde stuff
  %
  for i = 1:4 ;
    subplot(4,4,5*(i-1)+1) ;
    [kde1, xgrid1] = gpkde(PC2LOAD1(:,i)) ;
    [kde2, xgrid2] = gpkde(PC2LOAD2(:,i)) ;
    plot(xgrid1,kde1,'r',xgrid2,kde2,'c') ;
      title('1 - d Projections') ;
%      xlabel([PC2STR ' ' num2str(i)]) ;
    vlim = axis ;
          %  Get axis values for drawing vertical lines
    left = min([PC2LOAD1(:,i); PC2LOAD2(:,i)]) ;
    right = max([PC2LOAD1(:,i); PC2LOAD2(:,i)]) ;
    range = right - left ;
    left = left - .05 * range ;
    right = right + .05 * range ;
    bottom = vlim(3) ;
    top = vlim(4) ;
    axis([left right bottom top]) ;
    hold on ;
      plot([PC2LOAD2(:,i) PC2LOAD2(:,i)],[bottom top], 'c') ;
      plot([PC2LOAD1(:,i) PC2LOAD1(:,i)],[bottom top], 'r') ;
          %  Show locations of projections 
          %  (pop'n 2 first, since likely less spread)
      plot(xgrid2,kde2,'c',xgrid1,kde1,'r') ;
          %  Do a replot to ensure seeing kde
    hold off ;
end ;

  


  %  Now do off diagonals
  %
  for i = 1:4 ;

    for j = 1:4 ;


      if i ~= j ;   %  then not on diagonal, so make a plot

        subplot(4,4,4*(i-1)+j) ;

        plot(PC2LOAD1(:,j),PC2LOAD1(:,i),'r+',...
                  PC2LOAD2(:,j),PC2LOAD2(:,i),'c+') ;
          title([PC2STR ' Loadings']) ;
 %         xlabel([PC2STR ' ' num2str(j)]) ;
 %         ylabel([PC2STR ' ' num2str(i)]) ;
            left = min([PC2LOAD1(:,j); PC2LOAD2(:,j)]) ;
            right = max([PC2LOAD1(:,j); PC2LOAD2(:,j)]) ;
            range = right - left ;
            left = left - .05 * range ;
            right = right + .05 * range ;
            bottom = min([PC2LOAD1(:,i); PC2LOAD2(:,i)]) ;
            top = max([PC2LOAD1(:,i); PC2LOAD2(:,i)]) ;
            range = top - bottom ;
            bottom = bottom - .05 * range ;
            top = top + .05 * range ;
          axis([left right bottom top]) ;

      end ;


    end ;

  end ;

  PC2STR = [PC2STR 'DP'] ;
          %  reset this from printing title and filename

end ;

