function coaspc2p
% COASPC2P, Does print of Static Principal Component Analysis
%   for 2 populations
%      Corneal Topography Analysis System
%   Creates a color postscript file, of
%   large size window with one page PCA type analysis
%      Intended to be called by coa2pm.m
% Outputs:
%     Postscript file in directory ~cornean\outputs

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina




%  Set up global variables
%
global SPC2HAND LISTFILESTR1 LISTFILESTR2 PC2STR OUTPUTPATH RMP RCP ;
%  SPCAHAND - handle for Static PCA Window
%  LISTFILESTR1 - Input list file name, Population 1
%  LISTFILESTR2 Input list file name, Population 2
%  PC2STR - String with title info for 2 population analyses
%  OUTPUTPATH - path for output, .ps files, .mpeg files
%  RMP - Robustness Mean Parameter
%  RCP - Robustness Covariance Parameter




if isempty(SPC2HAND) | isempty(PC2STR) ;
        %  then SPCA window not yet created,
        %  or have not yet created message string
        %  so give error message

  disp('   ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Can''t print Static PCA plot,') ;
  disp('!!!   Since 2 Pop''n Analysis not done yet') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

else ;  %  then have done the analysis, so print result

  figure(SPC2HAND) ;

  orient landscape ;
  eval(['print ' OUTPUTPATH PC2STR LISTFILESTR1 LISTFILESTR2  ...
                                     num2str(RMP) '.ps -dpsc']) ;

  disp('  Finished Creating Postscript file for ') ;
  disp(['    2 Pop''n static ' PC2STR ' for: ' LISTFILESTR1 LISTFILESTR2]) ;


end ;
