disp('Running MATLAB script file lmtzcf21.m') ;
%
%    Makes Figure 2.1, for the Locantore, Marron, Tripoli,
%    Zhang, Cohen paper.
%    Actually creates .eps files a,b,c for each of the three rows
%
%    lines mostly from coalwzr.m


%  First define variables (nothing is local)
R0 = 4.0 ;
NMAX = 10 ;
IBASIS = 1 ;
IRECENT = 0 ;
CRAD = 0 ;
CANG = 0 ;

FEATMPATH = '\matlab\cornean\zfm\' ;
SUBDIRSTR = 'milan\' ;




%  Set up Keratron colormap
%
[COMAP, HICURVE] = coacmap ;



%  set local variables
%
ngrid = 64 ;     %  Construct surfaces as ngrid x ngrid array
picrows = 1 ;
          %  number of rows for images for output figures
piccols = 3 ;
          %  number of cols for images for output figures
r0last = R0 ;          %  Original radius of analysis
nmaxlast = [] ;        %  Original maximum number of Zernike columns
                       %       set to empty, so can tell when read
                       %       is first
ibasislast = IBASIS ;  %  Original basis type (full or radial)
irecentlast = IRECENT ;%  Original recentering (or not)


%  Create list of filenames
%
minfilestr = ['000028_1'; ...
              '000018_1'; ...
              '000008_2'; ...
              '000092_2'; ...
              '000089_1'; ...
              '000021_1'; ...
              '000002_3'; ...
              '000010_1'; ...
              '000001_2'] ;
          %  each row corresponds to one filename
          %  must have 9 of these



%  loop through filenames
%
for irow = 1:3 ;

  for ifileind = 1:3 ;

    ifile = 3*(irow - 1) + ifileind ;

    %  get current feature vector
    %
    infilestr = minfilestr(ifile,:) ;
          %  combine indiviual entries into file string
    zmistr = [FEATMPATH SUBDIRSTR infilestr '.mat'] ;
          %  full path and filename 
    eval(['load ' zmistr]) ;
          %  loads this Zernike feature matrix and parameter values


    %  Calculate grid quantities
    %
    xgrid = linspace(-R0, R0, ngrid) ;
    ygrid = xgrid ;	        %  Vectors of image coordinate values 



    disp(['  Working on file ' infilestr]) ;

    %  setup current axis for plotting image
    %
    subplot(picrows,piccols,ifileind) ;

    %  Create image with Keratron Color scheme, and put in current axes
    %
    mout = coazr(betahat) ;
    pcolor(xgrid,ygrid,mout) ;
      shading flat ;
      axis('square') ;
        caxis([0 1]) ;
      colormap(COMAP) ;

      %  Show where missing data is:
      hold on ;
        adata = linspace(0, (1 - 1/256) * 2 * pi, 256)' ;
        polar(adata,nonmissr,'-k') ;    
        angc = CANG*pi/180;
        plotang = pi + angc;
        polar(plotang, CRAD, '+k');
        plot(0,0,'ok');
      hold off ;

  end ;



    orient tall ;
    set(gcf,'PaperPosition',[1.5, 7.0, 5.5, 2.0]) ;
        %  1.5 inches on left and right, 5.5 interior, 8.5 total
        %  7.0 from bottom, 2.0 interior, 11 total
  eval(['print -depsc \matlab\steve\ps\lmtzcf21' num2str(irow) '.eps ;']) ;



end ;
