disp('Running MATLAB script file lmtzcf41.m') ;
%
%    Makes Figure 4.1, for the Locantore, Marron, Tripoli,
%    Zhang, Cohen paper.
%
%    Copied from cs1.m  (part 5)



seed = 20943343 ;
rand('seed',seed) ;
randn('seed',seed) ;

n = 10 ;
xdat = -2 + .6 * randn(n,1) ;
ydat = -2 - (xdat + 2) + 0.2 * randn(n,1) ;
xdat = [xdat; 3] ;
ydat = [ydat; 3] ;

plot(xdat,ydat,'o') ;
  axis([-4,4,-4,4]) ;
  axis('square') ;
  set(gca,'XTickLabels',[]) ;
  set(gca,'YTickLabels',[]) ;


vmean = mean([xdat, ydat]) ;
hold on ;
  plot(vmean(1),vmean(2),'o') ;
  plot(vmean(1),vmean(2),'x') ;
    vachil = get(gca,'Children') ;
    set(vachil(1),'MarkerSize',10) ;
    set(vachil(1),'LineWidth',2) ;
    set(vachil(2),'MarkerSize',10) ;
    set(vachil(2),'LineWidth',2) ;
hold off ;



  orient tall ;
  set(gcf,'PaperPosition',[2.5, 4.5, 4.5, 4.5]) ;
        %  2.0 inches on left and right, 4.0 interior, 8.5 total
        %  4.5 from bottom, 4.5 interior, 11 total
print -deps \matlab\steve\ps\lmtzcf41.eps ;



