disp('Running MATLAB script file lmtzcf43.m') ;
%
%    Makes Figure 4.3, for the Locantore, Marron, Tripoli,
%    Zhang, Cohen paper.
%
%    lines mostly from coaspca.m



global R0 NMAX IBASIS IRECENT LISTR FEATMPATH SUBDIRSTR ;
          %  These are used by coaflr
global R0 NMAX IBASIS IRECENT INDATPATH HICURVE ;
          %  These are used by coazr

%  First define variables
R0 = 4.0 ;
NMAX = 10 ;
IBASIS = 1 ;
IRECENT = 0 ;
CRAD = 0 ;
CANG = 0 ;

FEATMPATH = '\matlab\cornean\zfm\' ;
SUBDIRSTR = 'milan\' ;
LISTFILESTR = 'prkpreo' ;
SETLISTPATH = 'LISTR = [FEATMPATH SUBDIRSTR LISTFILESTR ''.lst''] ; ' ;


%  Set up Keratron colormap
%
[COMAP, HICURVE] = coacmap ;


%  Set local parameters
%
ngrid = 64 ;     %  Construct surfaces as ngrid x ngrid array


%  Read in matrix of Zernike feature coefficients
%
eval(SETLISTPATH) ;
% sets LISTR (read-in file string)
mfv = coaflr ;
d = size(mfv,1) ;
n = size(mfv,2) ;



%  Calculate grid quantities
%
xgrid = linspace(-R0, R0, ngrid) ;
ygrid = xgrid ;	        %  Vectors of image coordinate values 
[mxgrid, mygrid] = meshgrid(xgrid,ygrid) ;
              		%  Matrices of image coordinate values 



%  Main Principal Component Block
%
sst = sum(sum(mfv.^2)) ;

%  Get Spherical mean feature vector
%
vmean = rmean(mfv')' ;



%  Create image
%
imm = coazr(vmean) ;


%  Put down plots
%
%  Mean first
%
subplot(1,1,1) ;
pcolor(mxgrid,mygrid,imm) ;
  shading flat ;
  axis('square') ;
    caxis([0 1]) ;
  colormap(COMAP) ;



  orient tall ;
  set(gcf,'PaperPosition',[1.5, 7.0, 2.0, 2.0]) ;
        %  3.25 inches on left and right, 2.0 interior, 8.5 total
        %  7.0 from bottom, 2.0 interior, 11 total
print -depsc \matlab\steve\ps\lmtzcf43.eps ;


