disp('Running MATLAB script file lmtzcf51.m') ;
%
%    Makes Figure 5.1, for the Locantore, Marron, Tripoli,
%    Zhang, Cohen paper.
%
%    Copied from cs1.m  (part 1)



seed = 20943343 ;
rand('seed',seed) ;
randn('seed',seed) ;

n = 60 ;
xdat = -2 + .6 * randn(n,1) ;
ydat = -2 - (xdat + 2) + 0.2 * randn(n,1) ;
xdat = [xdat; 3] ;
ydat = [ydat; 3] ;

plot(xdat,ydat,'o') ;
  axis([-4,4,-4,4]) ;
  axis('square') ;
  set(gca,'XTickLabels',[]) ;
  set(gca,'YTickLabels',[]) ;


vmean = mean([xdat, ydat]) ;
mcov = cov([xdat, ydat]) ;
[meigv,eigval] = eig(mcov) ; 
eigval = diag(eigval) ;
[temp,visort] = sort(eigval) ;
visort = flipud(visort) ;
meigv = meigv(:,visort) ;
eigval = eigval(visort) ;


hold on ;
  plot([vmean(1); (vmean(1) + 2 * eigval(1) * meigv(1,1))], ...
       [vmean(2); (vmean(2) + 2 * eigval(1) * meigv(2,1))],'-') ;
    vhand = get(gca,'Children') ;
    set(vhand(1),'LineWidth',1.5) ;
  plot([vmean(1); (vmean(1) + 2 * eigval(2) * meigv(1,2))], ...
       [vmean(2); (vmean(2) + 2 * eigval(2) * meigv(2,2))],'-') ;
    vhand = get(gca,'Children') ;
    set(vhand(1),'LineWidth',0.5) ;

hold off ;



  orient tall ;
  set(gcf,'PaperPosition',[2.5, 4.5, 4.5, 4.5]) ;
        %  2.0 inches on left and right, 4.0 interior, 8.5 total
        %  4.5 from bottom, 4.5 interior, 11 total
print -deps \matlab\steve\ps\lmtzcf51.eps ;




