function MakeF0zf
% MakeF0zf, MAKEs Fourier 0 only Zernkike Feature vectors
%      Copied from COALWZR.M, from
%      Corneal Topography Analysis System, ver. 0.1
%   Reads in current Zernike Feature vectors, from .zfm files,
%   and zeros out all terms, except those for Fourier 0,
%   then resaves in .zfm files in directory determined by FEATMAPTH,
%   with "F0" appended.
%      Reads list of files from LISTFILESTR
% Output:
%     Matlab data file, with Zernike decomposition in vector form
%            in the directory in the global variable FEATMPATH,


%    Copyright (c) J. S. Marron, N. Locantore 1999
%    Department of Statistics, University of North Carolina




%  Set up global variables
%
%  First some general globals
global R0 NMAX IBASIS IRECENT CRAD CANG COMAP ;
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  IBASIS - 1 for full (triangle), 2 for radial (3 row)
%  IRECENT - To recenter (or not) decompositions
%  CRAD, radius of recentering (read in as editable text)
          %    this gets reloaded when a feature vec is reloaded from file
%  CANG, angle of recentering (read in as editable text)
          %    this gets reloaded when a feature vec is reloaded from file
%  COMAP - Color Map

%  Next some globals for file names, etc.
global SETLISTPATH LISTFILESTR LISTR ;
%  SETLISTPATH - string to set path to lists 
%  LISTFILESTR - string with input name of file with list of filenames
%  LISTR - string for inputting list file

%  Next the paths for file control
global FEATMPATH SUBDIRSTR ;
%  FEATMPATH - path for storing Zernike feature matrices
%  SUBDIRSTR - current subdirectory (of both indata and outputs)


%  set local variables
%
r0last = R0 ;          %  Original radius of analysis
nmaxlast = [] ;        %  Original maximum number of Zernike columns
                       %       set to empty, so can tell when read
                       %       is first
ibasislast = IBASIS ;  %  Original basis type (full or radial)
irecentlast = IRECENT ;%  Original recentering (or not)

f0SUBDIRSTR = [SUBDIRSTR(1:(length(SUBDIRSTR)-1)) 'f0\'] ;



%  Read in filename
%
eval(SETLISTPATH) ;
% sets LISTR (read-in file string)
fid = fopen(LISTR) ;
          %  assigns a file handle, (read only assumed)
if (fid == -1) ;      %  then file not found, so report

  disp('   ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Can''t do List Wise Recon., because can''t find file:') ;
  disp(['!!!       ' LISTR]) ;
  disp('!!!') ;
  disp('!!!   Terminating List Wise Recon.') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

else ;


  %  Read in list of filenames
  %
  minfilestr = fscanf(fid,'%s',[8,inf]) ;
            %  formatted read, assumes single column
  fclose(fid) ;

  minfilestr = minfilestr' ;
          %  each row corresponds to one filename



  for ifile = 1:size(minfilestr,1) ;

    %  get current feature vector
    %
    infilestr = minfilestr(ifile,:) ;
          %  combine indiviual entries into file string
    zmistr = [FEATMPATH SUBDIRSTR infilestr '.mat'] ;
          %  full path and filename 
    eval(['load ' zmistr]) ;
          %  loads this Zernike feature matrix and parameter values




    if isempty(nmaxlast) ;  
                      %  then are at first read, 
                      %  so only check other parameters

      if (R0 ~= r0last) ;
        disp('   ') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
        disp('!!!   Warning from coalwzr.m:  R0 has changed,') ;
        disp(['!!!      Old R0 = ' num2str(r0last) ',   New R0 = ' num2str(R0)]) ;
        disp('!!!   Hit Any Key to continue with new R0,') ;
        disp('!!!   Or hit (ctrl + C) (twice) to quit') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

        pause ;          
      end ;

      if (IBASIS ~= ibasislast) ;
        disp('   ') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
        disp('!!!   Warning from coalwzr.m:  IBASIS has changed,') ;
        disp(['!!!      Old IBASIS = ' num2str(ibasislast) ...
                                 ',   New IBASIS = ' num2str(IBASIS)]) ;
        disp('!!!   Hit Any Key to continue with new IBASIS,') ;
        disp('!!!   Or hit (ctrl + C) (twice) to quit') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

        pause ;          
      end ;

      if (IRECENT ~= irecentlast) ;
        disp('   ') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
        disp('!!!   Warning from coalwzr.m:  IRECENT has changed,') ;
        disp(['!!!      Old IRECENT = ' num2str(irecentlast) ...
                             ',   New IRECENT = ' num2str(IRECENT)]) ;
        disp('!!!   Hit Any Key to continue with new IRECENT,') ;
        disp('!!!   Or hit (ctrl + C) (twice) to quit') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

        pause ;          
      end ;

    else ;          %  then are at later reads, so check params

      if (R0 ~= r0last) | (NMAX ~= nmaxlast) | ...
                 (IBASIS ~= ibasislast) | (IRECENT ~= irecentlast) ;
                    %  parameter values have changed, so quit

        %  Write latest values to screen
        NMAX
        nmaxlast
        R0
        r0last
        IBASIS
        ibasislast
        IRECENT
        irecentlast

        disp('   ') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
        disp('!!!   Input Zernike Parameters have changed,') ;
        disp(['!!!           (differing file is ' infilestr ')']) ;
        disp('!!!') ;
        disp('!!!   Terminating Listwise Reconstruction') ;
        disp('!!!') ;
        disp('!!!           (Need to redo at least some of the') ;
        disp('!!!            Zernike Decompositions to fix this) ') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

        break ;
          %  jump out of loop

      end ;

    end ;

    r0last = R0 ;
    nmaxlast = NMAX ;
    ibasislast = IBASIS ;


    betahatkeep = betahat ;
          %  temporarily keep all coefficients

    betahat = zeros(length(betahat),1) ;

    flag = zeros(length(betahat)) ;



    if IBASIS == 1 ;    %   then are using full triangular basis

      icur = 1 ;
      flag(icur) = 1 ;

      for icolo2 = 1:floor(NMAX/2) ;
        icur = icur + 4*icolo2 - 1 ;
        flag(icur) = 1 ;
      end ;

    elseif IBASIS == 2 ;    %   then are using radial basis (3 row)

      icur = 1 ;
      flag(icur) = 1 ;

      icur = 4 ;
      flag(icur) = 1 ;

      for icolo2 = 2:NMAX ;
        icur = icur + 5 ;
        flag(icur) = 1 ;
      end ;

    end ;



    flag = logical(flag) ;

    betahat(flag) = betahatkeep(flag) ;
          %  replace these entries with old betahat values,
          %  leave others as 0




      %  save using lines from coalwzd.m
      %
      outfilestr = [FEATMPATH f0SUBDIRSTR infilestr '.mat'] ;  
      eval(['save ' outfilestr ' betahat nonmissr ' ... 
	                   'inmissr IBASIS IRECENT R0 NMAX CRAD CANG']);
   	disp(['Finished F0 version of file ' infilestr]) ;
	   disp('');




  end ;


  disp(['Finished overall listwise F0 versions for ' LISTR]) ;



end ;










