function coarampk
% COARAMPK, Chooses a Reconstruct Analyze Menu Generation for Cornean
%      Corneal Topography Analysis System
%   Creates a menu in the current Figure Window, depending on whether
%	file in /zfm/ directory has Zernike or Radial decomposition
%      Intended to be called by coaiam.m

%    Copyright (c) J. S. Marron, N. Locantore 1998
%    Department of Statistics, University of North Carolina

%  Set up global variables
%
%  First some general globals
global FEATMPATH INFILESTR R0 NMAX CRAD CANG ;
%  FEATMPATH - string with feature matrix pathname
%  INFILESTR - string with input filename
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  CRAD - radius of recentering (read in as editable text)
          %    this gets reloaded when a feature vec is reloaded from file
%  CANG - angle of recentering (read in as editable text)
          %    this gets reloaded when a feature vec is reloaded from file

%  Next the globals for handles to figure windows and plots
global RRAMHAND RRAMHANDPOS RRAMCBHAND  ;
%  RRAMHAND - handle for Figure Window with Reconstruct, Analyze Menu
%  RRAMCBHAND - handle for CheckBoxes in Radial Recon/Analyze Menu


  filestr = [FEATMPATH INFILESTR '.mat'] ;
  eval(['load ' filestr]);
	% call in the current file's feature matrix

  if radsym == 1;
	coarram;		% Radial decomposition reconstruct
  else ;
	coaram;			% Zernike decomposition reconstruct
  end;
