function mzc = coaflr
% COAFLR, Reads Zernike coefficient vectors from File List
%      Corneal Topography Analysis System
%   For each Zernike feature vector in the current file list
%      (in the file LISTFILESTR, whose full path is in the 
%      string LISTR), this reads the coefficients from the
%      stored file, and combines them into a large matrix
%      Intended to be called by coaspca.m and coadpca.m
% Output:
%     mzc   -   matrix of Zernike Coefficients

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina




%  Set up global variable
%
global R0 NMAX LISTR FEATMPATH
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  LISTR - string for inputting list file
%  FEATMPATH - path for storing Zernike feature matrices




%  Initialize variables
%
r0ori = R0 ;          %  Remember original radius of analysis
nmaxori = NMAX ;      %  Remember original maximum number of Zernike columns
mzc = [] ;            %  output matrix




%  Read in data
%
% LISTR, (read-in file string, set in advance in coapam.m)
fid = fopen(LISTR) ;
          %  assigns a file handle, (read only assumed)
if (fid == -1) ;      %  then file not found, so report

  disp('   ') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
  disp('!!!   Can''t read Zernike Coeffs, because can''t find file:') ;
  disp(['!!!       ' LISTR]) ;
  disp('!!!') ;
  disp('!!!   Terminating Population Analysis') ;
  disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

else ;


  %  Read in list of filenames
  %
  minfilestr = fscanf(fid,'%s',[8,inf]) ;
            %  formatted read, assumes single column
  fclose(fid) ;

  minfilestr = minfilestr' ;
          %  each row corresponds to one filename



  %  loop through filenames
  %
  nfile = size(minfilestr,1) ;
          %  number of files = rows of input matrix
  for ifile = 1:nfile ;
  
    infilestr = minfilestr(ifile,:) ;
          %  combine indiviual entries into file string
    zmistr = [FEATMPATH infilestr '.mat'] ;
          %  full path and filename 

    fid = fopen(zmistr) ;
          %  assigns a file handle, (read only assumed)
    if (fid == -1) ;      %  then file not found, so report

      disp('   ') ;
      disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
      disp(['!!!   Can''t find file:  ' zmistr]) ;
      disp('!!!   So will skip this feature vector') ;
      disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

    else ;      %  then proceed with read
      ifc = fclose(fid) ;    %  only needed to know file was there,
                             %  so now close

      eval(['load ' zmistr]) ;
          %  loads this Zernike feature matrix and parameter values


      if (R0 == r0ori) & (NMAX == nmaxori) ;
                      %  then have common parameter values, so proceed

        mzc = [mzc, betahat] ;

      else ;       %  parameter values have changed, so quit

        %  Write latest values to screen
        NMAX
        R0

        disp('   ') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;
        disp('!!!   Input Zernike Parameters have changed,') ;
        disp(['!!!           (differing file is ' infilestr ')']) ;
        disp('!!!') ;
        disp('!!!   Terminating Population Analysis') ;
        disp('!!!') ;
        disp('!!!           (Need to redo at least some of the') ;
        disp('!!!            Zernike Decompositions to fix this) ') ;
        disp('!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!') ;

        mzc = [] ;
          %  reset this to empty, to abort population analysis      
        break ;
          %  jump out of loop

      end ;

    end ;

  end ;

end ;

