function coamn
% COADPCA, Does Morphing Analysis, New Movie
%      Corneal Topography Analysis System
%   Creates a window with a morphing analysis movie
%      Intended to be called by coamam.m
% Outputs:
%     Only graphics, in current Figure

%    Copyright (c) J. S. Marron 1998
%    Department of Statistics, University of North Carolina




%  Set local parameters
%
ngrid = 64 ;     %  Construct surfaces as ngrid x ngrid array
nframe = 11 ;
          %  number of movie frames
    


%  Set up global variables
%
%  First some general globals
global R0 NMAX COMAP NRPT ;
%  R0 - radius of analysis
          %    this gets reloaded when a feature vec is reloaded from file
%  NMAX - maximum number of Zernike columns
          %    this gets reloaded when a feature vec is reloaded from file
%  COMAP - Color Map
%  NRPT - Number of times to Repeat Movie
global VERTGAP HORIZGAP TITLHT BUTTONHT
        %  generic sizes of objects on menus

global RDHANDPOS ;
        %  window positioning vector
global MAMOVHAND ;
        %  Handle for movie windows in Dynamic PC Analysis
global MAM ;
        %  Movie matrix in Morphing Analysis
global SETM1PATH SETM2PATH SETM3PATH ;
        %  Strings for readjusting movie paths
global M1STR M2STR M3STR ;
        %  Movie full filestrings (including path)




%  Calculate grid quantities
%
xgrid = linspace(-R0, R0, ngrid) ;
ygrid = xgrid ;	        %  Vectors of image coordinate values 
[mxgrid, mygrid] = meshgrid(xgrid,ygrid) ;
              		%  Matrices of image coordinate values 



%  read zfm files
%
eval(['load ' M1STR ' ;']) ;
vfeat1 = betahat ;
eval(['load ' M2STR ' ;']) ;
vfeat2 = betahat ;



%  Create Morphing movie
%
MAMOVHAND = figure ;
          %  create a new window
set(MAMOVHAND, 'NumberTitle', 'off');
set(MAMOVHAND,'Position', RDHANDPOS) ;
set(MAMOVHAND,'Name','Morph') ;


MAM = [] ;
for iframe = 1:nframe ;
  w = (iframe - 1) / (nframe - 1) ;
  vfeat = (1 - w) * vfeat1 + w * vfeat2 ;
  mout = coazr(vfeat) ;

  pcolor(mxgrid,mygrid,mout) ;
    shading flat ;
    axis('square') ;
      caxis([0 1]) ;
    colormap(COMAP) ;

    hold on ;   % add bar showing time gone
      bars = .55 * R0 ;
      barw = .40 * R0 ;
      bary = .95 * R0 ;
      plot([bars,bars+w*barw],[bary,bary],'-y') ;
        vhand = get(gca,'Children') ;
        set(vhand(1),'LineWidth',5) ;
    hold off ;


  MAM(:,iframe) = getframe(MAMOVHAND) ;
end ;

movie(MAMOVHAND,MAM,-NRPT) ;
          %  - sign says loop back and forth









